/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime;

import java.util.Locale;
import java.util.function.BooleanSupplier;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.Fold;
import org.qbicc.runtime.NoSafePoint;

public final class Build {
    private Build() {
    }

    @NoSafePoint
    public static boolean isHost() {
        return false;
    }

    @NoSafePoint
    public static boolean isTarget() {
        return false;
    }

    @NoSafePoint
    public static boolean isJvm() {
        return true;
    }

    public static final class Target {
        private static final CNative.object __GNUC__ = CNative.constant();
        @CNative.include(value="<features.h>")
        private static final CNative.c_int __GNU_LIBRARY__ = (CNative.c_int)CNative.constant();
        @CNative.include(value="<features.h>")
        private static final CNative.object __UCLIBC__ = CNative.constant();
        @CNative.include(value="<features.h>")
        private static final CNative.object __MUSL__ = CNative.constant();

        @Fold
        public static boolean isVirtual() {
            return "virtual".equals(System.getProperty("os.arch"));
        }

        public static native boolean isUnix();

        public static native boolean isLinux();

        public static native boolean isWindows();

        public static native boolean isApple();

        public static native boolean isMacOs();

        public static native boolean isIOS();

        public static native boolean isAix();

        public static native boolean isPosix();

        public static native boolean isAmd64();

        public static native boolean isI386();

        public static native boolean isArm();

        public static native boolean isAarch64();

        public static native boolean isWasm();

        public static native boolean isWasi();

        @Fold
        public static boolean isGcc() {
            return CNative.defined(__GNUC__);
        }

        @Fold
        public static boolean isGLibCLike() {
            return CNative.defined(__GNU_LIBRARY__);
        }

        @Fold
        public static boolean isGLibC() {
            return Target.isGLibCLike() && !Target.isUCLibC() && !Target.isMusl();
        }

        @Fold
        public static boolean isUCLibC() {
            return CNative.defined(__UCLIBC__);
        }

        @Fold
        public static boolean isPThreads() {
            return !Target.isWasm();
        }

        @Fold
        public static boolean isMusl() {
            return CNative.defined(__MUSL__);
        }

        public static native boolean isElf();

        public static native boolean isMachO();

        public static boolean isLlvm() {
            return false;
        }

        public static final class IsAix
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isAix();
            }
        }

        public static final class IsUnix
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isUnix();
            }
        }

        public static final class IsPThreads
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isPThreads();
            }
        }

        public static final class IsGLibCLike
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isGLibCLike();
            }
        }

        public static final class IsGLibC
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isGLibC();
            }
        }

        public static final class IsGcc
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isGcc();
            }
        }

        public static final class IsWasi
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isWasi();
            }
        }

        public static final class IsWasm
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isWasm();
            }
        }

        public static final class IsArm
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isArm();
            }
        }

        public static final class IsAmd64
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isAmd64();
            }
        }

        public static final class IsAarch64
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isAarch64();
            }
        }

        public static final class IsApple
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isApple();
            }
        }

        public static final class IsMacOs
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isMacOs();
            }
        }

        public static final class IsLinux
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isLinux();
            }
        }

        public static final class IsPosix
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Target.isPosix();
            }
        }
    }

    public static final class Host {
        @Fold
        public static boolean isLinux() {
            return System.getProperty("os.name", "unknown").toLowerCase(Locale.ROOT).contains("linux");
        }

        @Fold
        public static boolean isWindows() {
            return System.getProperty("os.name", "unknown").toLowerCase(Locale.ROOT).contains("windows");
        }

        @Fold
        public static boolean isMacOs() {
            return System.getProperty("os.name", "unknown").toLowerCase(Locale.ROOT).contains("mac os");
        }

        @Fold
        public static boolean isPosix() {
            return Host.isLinux() || Host.isMacOs();
        }

        @Fold
        public static boolean isAmd64() {
            String archName = System.getProperty("os.arch", "unknown").toLowerCase(Locale.ROOT);
            return archName.contains("amd64") || archName.contains("x86_64");
        }

        @Fold
        public static boolean isI386() {
            String archName = System.getProperty("os.arch", "unknown").toLowerCase(Locale.ROOT);
            return archName.contains("i386") || archName.contains("i486") || archName.contains("i586") || archName.contains("i686");
        }

        @Fold
        public static boolean isArm() {
            String archName = System.getProperty("os.arch", "unknown").toLowerCase(Locale.ROOT);
            return !archName.contains("arm64") && archName.contains("arm");
        }

        @Fold
        public static boolean isAarch64() {
            String archName = System.getProperty("os.arch", "unknown").toLowerCase(Locale.ROOT);
            return archName.contains("arm64") || archName.contains("aarch64");
        }

        public static final class IsArm
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Host.isArm();
            }
        }

        public static final class IsAmd64
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Host.isAmd64();
            }
        }

        public static final class IsLinux
        implements BooleanSupplier {
            @Override
            public boolean getAsBoolean() {
                return Host.isLinux();
            }
        }
    }

    public static final class IsTarget
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return Build.isTarget();
        }
    }

    public static final class IsHost
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return Build.isHost();
        }
    }
}

