/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.qbicc.runtime.AutoQueued;
import org.qbicc.runtime.InlineObject;
import org.qbicc.runtime.NoSideEffects;
import org.qbicc.runtime.stdc.Stddef;
import org.qbicc.runtime.stdc.Stdint;
import org.qbicc.runtime.stdc.String;

public final class CNative {
    private CNative() {
    }

    public static native boolean defined(object var0);

    public static native boolean isComplete(Class<? extends object> var0);

    public static native boolean isSigned(Class<? extends word> var0);

    public static native boolean isUnsigned(Class<? extends word> var0);

    public static native boolean typesAreEquivalent(Class<? extends object> var0, Class<? extends object> var1);

    public static native Stddef.size_t sizeof(object[] var0);

    public static native Stddef.size_t sizeof(object var0);

    public static native Stddef.size_t sizeofArray(Class<? extends object[]> var0);

    public static native Stddef.size_t sizeof(Class<? extends object> var0);

    public static native Stddef.size_t alignof(object var0);

    public static native Stddef.size_t alignof(Class<? extends object> var0);

    public static <T extends object> int elementCount(T[] array) {
        return (int)(CNative.sizeof(array).longValue() / CNative.sizeof(array[0]).longValue());
    }

    public static native Stddef.size_t offsetof(object var0);

    public static native <T extends object> T constant();

    public static native <T, P extends ptr<T>> P addr_of(T var0);

    public static native ptr<Stdint.int64_t> addr_of(long var0);

    public static native ptr<Stdint.int32_t> addr_of(int var0);

    public static native ptr<Stdint.int16_t> addr_of(short var0);

    public static native ptr<Stdint.int8_t> addr_of(byte var0);

    public static native ptr<Stdint.uint16_t> addr_of(char var0);

    public static native ptr<_Bool> addr_of(boolean var0);

    public static native ptr<_Float32> addr_of(float var0);

    public static native ptr<_Float64> addr_of(double var0);

    public static native <M extends object, P extends ptr<?>> P base_of(ptr<M> var0, M var1);

    public static native <T extends object> T zero();

    public static native <T extends object> T auto();

    public static native <T extends object> T auto(T var0);

    public static native byte auto(byte var0);

    public static native char auto(char var0);

    public static native double auto(double var0);

    public static native float auto(float var0);

    public static native int auto(int var0);

    public static native long auto(long var0);

    public static native short auto(short var0);

    public static native boolean auto(boolean var0);

    public static native <T extends word> T word(int var0);

    public static native <T extends word> T word(long var0);

    public static native <T extends word> T uword(int var0);

    public static native <T extends word> T uword(long var0);

    public static native <T extends word> T word(float var0);

    public static native <T extends word> T word(double var0);

    public static native <T extends word> T word(boolean var0);

    public static native Stdint.int8_t wordExact(byte var0);

    public static native Stdint.int16_t wordExact(short var0);

    public static native Stdint.int32_t wordExact(int var0);

    public static native Stdint.int64_t wordExact(long var0);

    public static native Stdint.uint16_t wordExact(char var0);

    public static native _Bool wordExact(boolean var0);

    public static native _Float32 wordExact(float var0);

    public static native _Float64 wordExact(double var0);

    public static native <W extends word> W wordAnd(W var0, W var1);

    public static native <W extends word> W wordOr(W var0, W var1);

    public static native <W extends word> W wordXor(W var0, W var1);

    public static native <W extends word> W wordComp(W var0);

    public static native <T, P extends ptr<T>> void fill(P var0, T var1, long var2);

    public static native void clear(ptr<?> var0);

    public static native void clear(ptr<?> var0, long var1);

    public static native <T> void copy(ptr<T> var0, ptr<T> var1);

    public static native <T> void copy(ptr<T> var0, ptr<T> var1, long var2);

    public static native <T> void copy_rev(ptr<T> var0, ptr<T> var1, long var2);

    public static native <T> void swap(ptr<T> var0, ptr<T> var1);

    public static void copy(ptr<Stdint.int8_t> dest, byte[] src, int srcOff, int len) {
        Objects.checkFromIndexSize(srcOff, len, src.length);
        CNative.copy(dest, CNative.addr_of(src[srcOff]), len);
    }

    public static void copy(ptr<Stdint.int16_t> dest, short[] src, int srcOff, int len) {
        Objects.checkFromIndexSize(srcOff, len, src.length);
        CNative.copy(dest, CNative.addr_of(src[srcOff]), len);
    }

    public static void copy(ptr<Stdint.int32_t> dest, int[] src, int srcOff, int len) {
        Objects.checkFromIndexSize(srcOff, len, src.length);
        CNative.copy(dest, CNative.addr_of(src[srcOff]), len);
    }

    public static void copy(ptr<Stdint.int64_t> dest, long[] src, int srcOff, int len) {
        Objects.checkFromIndexSize(srcOff, len, src.length);
        CNative.copy(dest, CNative.addr_of(src[srcOff]), len);
    }

    public static void copy(ptr<Stdint.uint16_t> dest, char[] src, int srcOff, int len) {
        Objects.checkFromIndexSize(srcOff, len, src.length);
        CNative.copy(dest, CNative.addr_of(src[srcOff]), len);
    }

    public static void copy(byte[] dest, int destOff, int destLen, ptr<@c_const Stdint.int8_t> src) {
        Objects.checkFromIndexSize(destOff, destLen, dest.length);
        CNative.copy((ptr)CNative.addr_of(dest[destOff]).cast(), (ptr)src.cast(), destLen);
    }

    public static void copy(short[] dest, int destOff, int destLen, ptr<@c_const Stdint.int16_t> src) {
        Objects.checkFromIndexSize(destOff, destLen, dest.length);
        CNative.copy((ptr)CNative.addr_of(dest[destOff]).cast(), (ptr)src.cast(), destLen);
    }

    public static void copy(int[] dest, int destOff, int destLen, ptr<@c_const Stdint.int32_t> src) {
        Objects.checkFromIndexSize(destOff, destLen, dest.length);
        CNative.copy((ptr)CNative.addr_of(dest[destOff]).cast(), (ptr)src.cast(), destLen);
    }

    public static void copy(long[] dest, int destOff, int destLen, ptr<@c_const Stdint.int64_t> src) {
        Objects.checkFromIndexSize(destOff, destLen, dest.length);
        CNative.copy((ptr)CNative.addr_of(dest[destOff]).cast(), (ptr)src.cast(), destLen);
    }

    public static void copy(char[] dest, int destOff, int destLen, ptr<@c_const Stdint.uint16_t> src) {
        Objects.checkFromIndexSize(destOff, destLen, dest.length);
        CNative.copy((ptr)CNative.addr_of(dest[destOff]).cast(), (ptr)src.cast(), destLen);
    }

    public static java.lang.String utf8zToJavaString(ptr<@c_const Stdint.uint8_t> ptr2) {
        return CNative.utf8ToJavaString(ptr2, String.strlen((ptr)ptr2.cast()).intValue());
    }

    public static java.lang.String utf8ToJavaString(ptr<@c_const Stdint.uint8_t> ptr2, int len) {
        byte[] bytes = new byte[len];
        CNative.copy(bytes, 0, len, (ptr)ptr2.cast());
        return new java.lang.String(bytes, StandardCharsets.UTF_8);
    }

    public static java.lang.String asciizToJavaString(ptr<@c_const c_char> ptr2) {
        return CNative.asciiToJavaString(ptr2, String.strlen(ptr2).intValue());
    }

    public static java.lang.String asciiToJavaString(ptr<@c_const c_char> ptr2, int len) {
        byte[] bytes = new byte[len];
        CNative.copy(bytes, 0, len, (ptr)ptr2.cast());
        return new java.lang.String(bytes, StandardCharsets.US_ASCII);
    }

    public static native <T> T ptrToRef(ptr<T> var0);

    public static native <T, P extends ptr<T>> P refToPtr(T var0);

    public static native <T, P extends ptr<T>> T deref(P var0);

    public static native <T> T deref(ptr<?> var0, Class<T> var1);

    public static native <T> T cast(Object var0);

    @NoSideEffects
    private static native int floatToInt1(float var0);

    @NoSideEffects
    @AutoQueued
    public static int floatToInt(float fv) {
        return CNative.floatToInt1(fv);
    }

    @NoSideEffects
    private static native long floatToLong1(float var0);

    @NoSideEffects
    @AutoQueued
    public static long floatToLong(float fv) {
        return CNative.floatToLong1(fv);
    }

    @NoSideEffects
    private static native int doubleToInt1(double var0);

    @NoSideEffects
    @AutoQueued
    public static int doubleToInt(double dv) {
        return CNative.doubleToInt1(dv);
    }

    @NoSideEffects
    private static native long doubleToLong1(double var0);

    @NoSideEffects
    @AutoQueued
    public static long doubleToLong(double dv) {
        return CNative.doubleToLong1(dv);
    }

    public static native <P extends ptr<?>> P alloca(Stddef.size_t var0);

    public static native ptr<@c_const c_char> utf8z(java.lang.String var0);

    public static abstract class object
    extends InlineObject {
        protected object() {
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return this.cast(Stdint.int32_t.class).intValue();
        }

        public final int sizeInBytes() {
            return CNative.sizeof(this).intValue();
        }

        public final int alignment() {
            return CNative.alignof(this).intValue();
        }

        public final native <T extends object> T cast();

        public final native <T extends object> T cast(Class<T> var1);

        public final boolean fitsIntoByte() {
            return CNative.sizeof(this).intValue() <= 1;
        }

        public final boolean fitsIntoShort() {
            return CNative.sizeof(this).intValue() <= 2;
        }

        public final boolean fitsIntoInt() {
            return CNative.sizeof(this).intValue() <= 4;
        }

        public final boolean fitsIntoLong() {
            return CNative.sizeof(this).intValue() <= 8;
        }

        public final java.lang.String toString() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class ptr<T>
    extends word {
        public native T[] asArray();

        public T get(int arrayIdx) {
            return ((ptr)this.plus(arrayIdx)).loadUnshared();
        }

        public void set(int arrayIdx, T newVal) {
            ((ptr)this.plus(arrayIdx)).storeUnshared(newVal);
        }

        public native T loadUnshared();

        public native <V> V loadUnshared(Class<V> var1);

        public native T loadPlain();

        public native <V> V loadPlain(Class<V> var1);

        public native T loadOpaque();

        public native <V> V loadOpaque(Class<V> var1);

        public native T loadSingleAcquire();

        public native <V> V loadSingleAcquire(Class<V> var1);

        public native T loadAcquire();

        public native <V> V loadAcquire(Class<V> var1);

        public native T loadVolatile();

        public native <V> V loadVolatile(Class<V> var1);

        public native void storeUnshared(T var1);

        public native <V> void storeUnshared(Class<V> var1, V var2);

        public native void storePlain(T var1);

        public native <V> void storePlain(Class<V> var1, V var2);

        public native void storeOpaque(T var1);

        public native <V> void storeOpaque(Class<V> var1, V var2);

        public native void storeSingleRelease(T var1);

        public native <V> void storeSingleRelease(Class<V> var1, V var2);

        public native void storeRelease(T var1);

        public native <V> void storeRelease(Class<V> var1, V var2);

        public native void storeVolatile(T var1);

        public native <V> void storeVolatile(Class<V> var1, V var2);

        public native boolean compareAndSetOpaque(T var1, T var2);

        public native <V> boolean compareAndSetOpaque(Class<V> var1, V var2, V var3);

        public native boolean compareAndSetAcquire(T var1, T var2);

        public native <V> boolean compareAndSetAcquire(Class<V> var1, V var2, V var3);

        public native boolean compareAndSetRelease(T var1, T var2);

        public native <V> boolean compareAndSetRelease(Class<V> var1, V var2, V var3);

        public native boolean compareAndSet(T var1, T var2);

        public native <V> boolean compareAndSet(Class<V> var1, V var2, V var3);

        public native boolean weakCompareAndSetOpaque(T var1, T var2);

        public native <V> boolean weakCompareAndSetOpaque(Class<V> var1, V var2, V var3);

        public native boolean weakCompareAndSetAcquire(T var1, T var2);

        public native <V> boolean weakCompareAndSetAcquire(Class<V> var1, V var2, V var3);

        public native boolean weakCompareAndSetRelease(T var1, T var2);

        public native <V> boolean weakCompareAndSetRelease(Class<V> var1, V var2, V var3);

        public native boolean weakCompareAndSet(T var1, T var2);

        public native <V> boolean weakCompareAndSet(Class<V> var1, V var2, V var3);

        public native T compareAndSwapOpaque(T var1, T var2);

        public native <V> V compareAndSwapOpaque(Class<V> var1, V var2, V var3);

        public native T compareAndSwapAcquire(T var1, T var2);

        public native <V> V compareAndSwapAcquire(Class<V> var1, V var2, V var3);

        public native T compareAndSwapRelease(T var1, T var2);

        public native <V> V compareAndSwapRelease(Class<V> var1, V var2, V var3);

        public native T compareAndSwap(T var1, T var2);

        public native <V> V compareAndSwap(Class<V> var1, V var2, V var3);

        public native T weakCompareAndSwapOpaque(T var1, T var2);

        public native <V> V weakCompareAndSwapOpaque(Class<V> var1, V var2, V var3);

        public native T weakCompareAndSwapAcquire(T var1, T var2);

        public native <V> V weakCompareAndSwapAcquire(Class<V> var1, V var2, V var3);

        public native T weakCompareAndSwapRelease(T var1, T var2);

        public native <V> V weakCompareAndSwapRelease(Class<V> var1, V var2, V var3);

        public native T weakCompareAndSwap(T var1, T var2);

        public native <V> V weakCompareAndSwap(Class<V> var1, V var2, V var3);

        public native T getAndSetOpaque(T var1);

        public native <V> V getAndSetOpaque(Class<V> var1, V var2);

        public native T getAndSetAcquire(T var1);

        public native <V> V getAndSetAcquire(Class<V> var1, V var2);

        public native T getAndSetRelease(T var1);

        public native <V> V getAndSetRelease(Class<V> var1, V var2);

        public native T getAndSet(T var1);

        public native <V> V getAndSet(Class<V> var1, V var2);

        public native T getAndSetMinOpaque(T var1);

        public native <V> V getAndSetMinOpaque(Class<V> var1, V var2);

        public native T getAndSetMinAcquire(T var1);

        public native <V> V getAndSetMinAcquire(Class<V> var1, V var2);

        public native T getAndSetMinRelease(T var1);

        public native <V> V getAndSetMinRelease(Class<V> var1, V var2);

        public native T getAndSetMin(T var1);

        public native <V> V getAndSetMin(Class<V> var1, V var2);

        public native T getAndSetMaxOpaque(T var1);

        public native <V> V getAndSetMaxOpaque(Class<V> var1, V var2);

        public native T getAndSetMaxAcquire(T var1);

        public native <V> V getAndSetMaxAcquire(Class<V> var1, V var2);

        public native T getAndSetMaxRelease(T var1);

        public native <V> V getAndSetMaxRelease(Class<V> var1, V var2);

        public native T getAndSetMax(T var1);

        public native <V> V getAndSetMax(Class<V> var1, V var2);

        public native T getAndAddOpaque(T var1);

        public native <V> V getAndAddOpaque(Class<V> var1, V var2);

        public native T getAndAddAcquire(T var1);

        public native <V> V getAndAddAcquire(Class<V> var1, V var2);

        public native T getAndAddRelease(T var1);

        public native <V> V getAndAddRelease(Class<V> var1, V var2);

        public native T getAndAdd(T var1);

        public native <V> V getAndAdd(Class<V> var1, V var2);

        public native T getAndSubtractOpaque(T var1);

        public native <V> V getAndSubtractOpaque(Class<V> var1, V var2);

        public native T getAndSubtractAcquire(T var1);

        public native <V> V getAndSubtractAcquire(Class<V> var1, V var2);

        public native T getAndSubtractRelease(T var1);

        public native <V> V getAndSubtractRelease(Class<V> var1, V var2);

        public native T getAndSubtract(T var1);

        public native <V> V getAndSubtract(Class<V> var1, V var2);

        public native T getAndBitwiseAndOpaque(T var1);

        public native <V> V getAndBitwiseAndOpaque(Class<V> var1, V var2);

        public native T getAndBitwiseAndAcquire(T var1);

        public native <V> V getAndBitwiseAndAcquire(Class<V> var1, V var2);

        public native T getAndBitwiseAndRelease(T var1);

        public native <V> V getAndBitwiseAndRelease(Class<V> var1, V var2);

        public native T getAndBitwiseAnd(T var1);

        public native <V> V getAndBitwiseAnd(Class<V> var1, V var2);

        public native T getAndBitwiseOrOpaque(T var1);

        public native <V> V getAndBitwiseOrOpaque(Class<V> var1, V var2);

        public native T getAndBitwiseOrAcquire(T var1);

        public native <V> V getAndBitwiseOrAcquire(Class<V> var1, V var2);

        public native T getAndBitwiseOrRelease(T var1);

        public native <V> V getAndBitwiseOrRelease(Class<V> var1, V var2);

        public native T getAndBitwiseOr(T var1);

        public native <V> V getAndBitwiseOr(Class<V> var1, V var2);

        public native T getAndBitwiseXorOpaque(T var1);

        public native <V> V getAndBitwiseXorOpaque(Class<V> var1, V var2);

        public native T getAndBitwiseXorAcquire(T var1);

        public native <V> V getAndBitwiseXorAcquire(Class<V> var1, V var2);

        public native T getAndBitwiseXorRelease(T var1);

        public native <V> V getAndBitwiseXorRelease(Class<V> var1, V var2);

        public native T getAndBitwiseXor(T var1);

        public native <V> V getAndBitwiseXor(Class<V> var1, V var2);

        public native T getAndBitwiseNandOpaque(T var1);

        public native <V> V getAndBitwiseNandOpaque(Class<V> var1, V var2);

        public native T getAndBitwiseNandAcquire(T var1);

        public native <V> V getAndBitwiseNandAcquire(Class<V> var1, V var2);

        public native T getAndBitwiseNandRelease(T var1);

        public native <V> V getAndBitwiseNandRelease(Class<V> var1, V var2);

        public native T getAndBitwiseNand(T var1);

        public native <V> V getAndBitwiseNand(Class<V> var1, V var2);

        public native <P extends ptr<T>> P plus(int var1);

        public native <P extends ptr<T>> P plus(long var1);

        public native <P extends ptr<T>> P minus(int var1);

        public native <P extends ptr<T>> P minus(long var1);

        public native Stddef.ptrdiff_t minus(ptr<T> var1);

        public T sel() {
            return CNative.deref(this);
        }

        public <V> V sel(Class<V> pointeeType) {
            return CNative.deref(this, pointeeType);
        }

        public native boolean isPinned();
    }

    public static enum CallingConvention {
        C;

    }

    public static enum ExportScope {
        LOCAL,
        GLOBAL;

    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface array_size {
        public int value();
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface c_volatile {
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface restrict {
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface c_const {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    @Documented
    public static @interface destructor {
        public int priority() default 1000;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    @Documented
    public static @interface constructor {
        public int priority() default 1000;
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    @Documented
    public static @interface export {
        public ExportScope withScope() default ExportScope.GLOBAL;

        public CallingConvention callingConvention() default CallingConvention.C;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    @Documented
    public static @interface internal {
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    @Documented
    public static @interface extern {
        public java.lang.String withName() default "";

        public ExportScope withScope() default ExportScope.GLOBAL;

        public CallingConvention callingConvention() default CallingConvention.C;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    @Repeatable(value=List.class)
    @Documented
    public static @interface signed {
        public boolean value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE})
        @Retention(value=RetentionPolicy.CLASS)
        @Documented
        public static @interface List {
            public signed[] value();
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    @Repeatable(value=List.class)
    @Documented
    public static @interface offset {
        public int value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.FIELD})
        @Retention(value=RetentionPolicy.CLASS)
        @Documented
        public static @interface List {
            public offset[] value();
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    @Repeatable(value=List.class)
    @Documented
    public static @interface align_as {
        public Class<?> value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD})
        @Retention(value=RetentionPolicy.CLASS)
        @Documented
        public static @interface List {
            public align_as[] value();
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    @Repeatable(value=List.class)
    @Documented
    public static @interface align {
        public int value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD})
        @Retention(value=RetentionPolicy.CLASS)
        @Documented
        public static @interface List {
            public align[] value();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    @Repeatable(value=List.class)
    @Documented
    public static @interface size {
        public int value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE})
        @Retention(value=RetentionPolicy.CLASS)
        @Documented
        public static @interface List {
            public size[] value();
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    @Repeatable(value=List.class)
    @Documented
    public static @interface incomplete {
        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD})
        @Retention(value=RetentionPolicy.CLASS)
        @Documented
        public static @interface List {
            public incomplete[] value();
        }
    }

    @Repeatable(value=List.class)
    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.CLASS)
    @Documented
    public static @interface name {
        public java.lang.String value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
        @Retention(value=RetentionPolicy.CLASS)
        @Documented
        public static @interface List {
            public name[] value();
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface macro {
    }

    @Repeatable(value=List.class)
    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface undef {
        public java.lang.String value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
        @Retention(value=RetentionPolicy.CLASS)
        public static @interface List {
            public undef[] value();
        }
    }

    @Repeatable(value=List.class)
    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface define {
        public java.lang.String value();

        public java.lang.String as() default "";

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
        @Retention(value=RetentionPolicy.CLASS)
        public static @interface List {
            public define[] value();
        }
    }

    @Repeatable(value=List.class)
    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface include {
        public java.lang.String value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
        @Retention(value=RetentionPolicy.CLASS)
        public static @interface List {
            public include[] value();
        }
    }

    @Repeatable(value=List.class)
    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface lib {
        public java.lang.String value();

        public Class<? extends BooleanSupplier>[] when() default {};

        public Class<? extends BooleanSupplier>[] unless() default {};

        @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
        @Retention(value=RetentionPolicy.CLASS)
        public static @interface List {
            public lib[] value();
        }
    }

    @name(value="double")
    public static final class _Float64
    extends word {
    }

    @name(value="float")
    public static final class _Float32
    extends word {
    }

    @incomplete
    public static final class function<F>
    extends object {
        function() {
        }

        public native F asInvokable();

        public static native <F> function<F> of(F var0);
    }

    @incomplete
    public static final class c_void
    extends object {
    }

    @name(value="long double")
    public static final class long_double
    extends word {
    }

    @name(value="double")
    public static final class c_double
    extends word {
    }

    @name(value="float")
    public static final class c_float
    extends word {
    }

    @name(value="unsigned long long")
    @signed(value=false)
    public static final class unsigned_long_long
    extends word {
    }

    @name(value="unsigned long")
    @signed(value=false)
    public static final class unsigned_long
    extends word {
    }

    @name(value="unsigned int")
    @signed(value=false)
    public static final class unsigned_int
    extends word {
    }

    @name(value="unsigned short")
    @signed(value=false)
    public static final class unsigned_short
    extends word {
    }

    @name(value="unsigned char")
    @size(value=1)
    @signed(value=false)
    public static final class unsigned_char
    extends word {
    }

    @name(value="long long")
    @signed(value=true)
    public static final class long_long
    extends word {
    }

    @name(value="long")
    @signed(value=true)
    public static final class c_long
    extends word {
    }

    @name(value="int")
    @signed(value=true)
    public static final class c_int
    extends word {
    }

    @name(value="short")
    @signed(value=true)
    public static final class c_short
    extends word {
    }

    @name(value="signed char")
    @size(value=1)
    @signed(value=true)
    public static final class signed_char
    extends word {
    }

    public static final class _Bool
    extends word {
    }

    @name(value="char")
    @size(value=1)
    public static final class c_char
    extends word {
    }

    public static final class reference<B>
    extends word {
        public static native <B> reference<B> of(B var0);

        public static native <B> reference<B> fromWord(word var0);

        public native B toObject();
    }

    public static final class header_type
    extends word {
    }

    public static final class type_id
    extends word {
    }

    public static abstract class union
    extends object {
    }

    public static abstract class struct
    extends object {
    }

    public static abstract class word
    extends object {
        public final native long longValue();

        public final double doubleValue() {
            return Double.longBitsToDouble(this.longValue());
        }

        public final native int intValue();

        public final native long uintValue();

        public final float floatValue() {
            return Float.intBitsToFloat(this.intValue());
        }

        public final native short shortValue();

        public final native int ushortValue();

        public final native byte byteValue();

        public final native int ubyteValue();

        public final native char charValue();

        public final native boolean isZero();

        public final boolean booleanValue() {
            return !this.isZero();
        }

        public final boolean isNonZero() {
            return !this.isZero();
        }

        public final boolean isNonNull() {
            return !this.isZero();
        }

        public final boolean isNull() {
            return this.isZero();
        }

        public final boolean isTrue() {
            return !this.isZero();
        }

        public final boolean isFalse() {
            return this.isZero();
        }

        public final boolean isNegative() {
            assert (CNative.isSigned(this.getClass()));
            return this.longValue() < 0L;
        }

        public final boolean isNotNegative() {
            return CNative.isUnsigned(this.getClass()) || this.longValue() >= 0L;
        }

        public final boolean isPositive() {
            return CNative.isUnsigned(this.getClass()) ? this.isNonZero() : this.longValue() > 0L;
        }

        public final boolean isNotPositive() {
            return CNative.isUnsigned(this.getClass()) ? this.isZero() : this.longValue() <= 0L;
        }

        public native boolean isLt(word var1);

        public native boolean isGt(word var1);

        public native boolean isLe(word var1);

        public native boolean isGe(word var1);
    }
}

