/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.host;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public final class HostBasicFileAttributes
implements BasicFileAttributes {
    static final int BA_EXISTS = 1;
    static final int BA_REGULAR = 2;
    static final int BA_DIRECTORY = 4;
    static final int BA_HIDDEN = 8;
    private final long modTime;
    private final long accessTime;
    private final long createTime;
    private final boolean regularFile;
    private final boolean directory;
    private final boolean symlink;
    private final boolean other;
    private final long size;
    private final long inode;

    HostBasicFileAttributes(long[] data) {
        this.modTime = data[0];
        this.accessTime = data[1];
        this.createTime = data[2];
        long attrs = data[3];
        this.regularFile = (attrs & 2L) != 0L;
        this.directory = (attrs & 4L) != 0L;
        this.symlink = false;
        this.other = (attrs & 6L) == 0L && (attrs & 1L) != 0L;
        this.size = data[4];
        this.inode = data[5];
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.fromMillis(this.modTime);
    }

    @Override
    public FileTime lastAccessTime() {
        return FileTime.fromMillis(this.accessTime);
    }

    @Override
    public FileTime creationTime() {
        return FileTime.fromMillis(this.createTime);
    }

    @Override
    public boolean isRegularFile() {
        return this.regularFile;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.symlink;
    }

    @Override
    public boolean isOther() {
        return this.other;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object fileKey() {
        return this.inode;
    }
}

