/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.host;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.qbicc.runtime.SerializeBooleanAs;
import org.qbicc.runtime.SerializeIntegralAs;
import org.qbicc.runtime.host.HostIO;

public final class HostDirectoryStream
implements DirectoryStream<Path> {
    private final Path base;
    private final DirectoryStream.Filter<? super Path> filter;
    @SerializeBooleanAs(value=true)
    private boolean iterated;
    @SerializeIntegralAs(value=-1L)
    private int fd;

    HostDirectoryStream(String pathName, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.base = Path.of(pathName, new String[0]);
        this.fd = HostIO.open(pathName, 64, 0);
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Path> iterator() {
        HostDirectoryStream hostDirectoryStream = this;
        synchronized (hostDirectoryStream) {
            if (this.iterated) {
                throw new IllegalStateException();
            }
            this.iterated = true;
            return new Itr(this.base);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        HostDirectoryStream hostDirectoryStream = this;
        synchronized (hostDirectoryStream) {
            if (this.fd != -1) {
                HostIO.close(this.fd);
                this.fd = -1;
            }
        }
    }

    final class Itr
    implements Iterator<Path> {
        final Path base;
        Path next;

        Itr(Path base) {
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            HostDirectoryStream hostDirectoryStream = HostDirectoryStream.this;
            synchronized (hostDirectoryStream) {
                if (HostDirectoryStream.this.fd == -1) {
                    return false;
                }
                if (this.next == null) {
                    Path path;
                    boolean ok;
                    DirectoryStream.Filter<? super Path> filter = HostDirectoryStream.this.filter;
                    do {
                        String str;
                        try {
                            str = HostIO.readDirectoryEntry(HostDirectoryStream.this.fd);
                        }
                        catch (IOException e) {
                            return false;
                        }
                        if (str == null) {
                            return false;
                        }
                        if (str.equals(".") || str.equals("..")) {
                            path = null;
                            ok = false;
                            continue;
                        }
                        path = this.base.resolve(str);
                        try {
                            ok = filter == null || filter.accept(path);
                        }
                        catch (IOException e) {
                            return false;
                        }
                    } while (!ok);
                    this.next = path;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Path next() {
            HostDirectoryStream hostDirectoryStream = HostDirectoryStream.this;
            synchronized (hostDirectoryStream) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Path next = this.next;
                this.next = null;
                return next;
            }
        }
    }
}

