/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.main;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.qbicc.runtime.Hidden;

public final class Monitor {
    private static final long MAX_MILLIS = 9223372036854L;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    @Hidden
    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    @Hidden
    public void enter() {
        this.lock.lock();
    }

    @Hidden
    public void exit() throws IllegalMonitorStateException {
        this.lock.unlock();
    }

    @Hidden
    public void await() throws InterruptedException {
        this.condition.await();
    }

    @Hidden
    public void await(long millis) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("Invalid milliseconds");
        }
        this.condition.await(millis, TimeUnit.MILLISECONDS);
    }

    @Hidden
    public void await(long millis, int nanos) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("Invalid milliseconds");
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("Invalid nanoseconds");
        }
        if (millis < 9223372036854L) {
            this.condition.await(millis * 1000000L + (long)nanos, TimeUnit.NANOSECONDS);
        } else {
            if (nanos > 0) {
                ++millis;
            }
            this.condition.await(millis, TimeUnit.MILLISECONDS);
        }
    }

    @Hidden
    public void signal() throws IllegalMonitorStateException {
        this.condition.signal();
    }

    @Hidden
    public void signalAll() throws IllegalMonitorStateException {
        this.condition.signalAll();
    }
}

