/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.main;

import org.qbicc.runtime.AutoQueued;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.Hidden;
import org.qbicc.runtime.main.CompilerIntrinsics;
import org.qbicc.runtime.stdc.Stdint;

public class ObjectModel {
    @Hidden
    private static Class<?> getOrCreateArrayClass(Class<?> componentClass) {
        Class<?> arrayClass = CompilerIntrinsics.getArrayClassOf(componentClass);
        if (arrayClass == null) {
            CNative.type_id elemTypeId = CompilerIntrinsics.getTypeIdFromClass(componentClass);
            int dims = CompilerIntrinsics.getDimensionsFromClass(componentClass).intValue();
            if (dims > 254) {
                throw new IllegalArgumentException();
            }
            if (dims > 0 || CompilerIntrinsics.isPrimArray(elemTypeId)) {
                String className = "[" + componentClass.getName();
                arrayClass = CompilerIntrinsics.createClass(className, elemTypeId, (Stdint.uint8_t)CNative.word((int)(dims + 1)), componentClass);
            } else {
                String className = "[L" + componentClass.getName() + ";";
                arrayClass = CompilerIntrinsics.createClass(className, elemTypeId, (Stdint.uint8_t)CNative.word((int)1), componentClass);
            }
            if (!CompilerIntrinsics.setArrayClass(componentClass, arrayClass)) {
                arrayClass = CompilerIntrinsics.getArrayClassOf(componentClass);
            }
        }
        return arrayClass;
    }

    @Hidden
    public static Class<?> getArrayClassOfDimension(Class<?> leafClass, Stdint.uint8_t dimensions) {
        if (dimensions.intValue() == 1) {
            return ObjectModel.getOrCreateArrayClass(leafClass);
        }
        Class<?> cls = ObjectModel.getArrayClassOfDimension(leafClass, (Stdint.uint8_t)CNative.word((int)(dimensions.intValue() - 1)));
        return ObjectModel.getOrCreateArrayClass(cls);
    }

    @Hidden
    @AutoQueued
    public static Class<?> getOrCreateClassForRefArray(Class<?> leafClass, Stdint.uint8_t dimensions) {
        return ObjectModel.getArrayClassOfDimension(leafClass, dimensions);
    }
}

