/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.main;

import java.util.Arrays;
import org.qbicc.runtime.AutoQueued;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.Hidden;
import org.qbicc.runtime.Inline;
import org.qbicc.runtime.InlineCondition;
import org.qbicc.runtime.NoReturn;
import org.qbicc.runtime.NoSideEffects;
import org.qbicc.runtime.NotReachableException;
import org.qbicc.runtime.main.CompilerIntrinsics;
import org.qbicc.runtime.main.InitialHeap;
import org.qbicc.runtime.stdc.Stdint;

public final class VMHelpers {
    @NoSideEffects
    @Hidden
    @AutoQueued
    public static boolean instanceofClass(Object instance, Class<?> cls) {
        if (instance == null) {
            return false;
        }
        CNative.type_id toTypeId = CompilerIntrinsics.getTypeIdFromClass(cls);
        Stdint.uint8_t toDim = CompilerIntrinsics.getDimensionsFromClass(cls);
        return VMHelpers.isAssignableTo(instance, toTypeId, toDim);
    }

    @NoSideEffects
    @Hidden
    @AutoQueued
    public static boolean instanceofTypeId(Object instance, CNative.type_id typeId, Stdint.uint8_t dimensions) {
        if (instance == null) {
            return false;
        }
        return VMHelpers.isAssignableTo(instance, typeId, dimensions);
    }

    @Hidden
    @AutoQueued
    public static void arrayStoreCheck(Object value, CNative.type_id toTypeId, Stdint.uint8_t toDimensions) {
        if (value == null || VMHelpers.isAssignableTo(value, toTypeId, toDimensions)) {
            return;
        }
        VMHelpers.raiseArrayStoreException();
    }

    @Hidden
    @AutoQueued
    public static void checkcastClass(Object value, Class<?> cls) {
        CNative.type_id toTypeId = CompilerIntrinsics.getTypeIdFromClass(cls);
        Stdint.uint8_t toDim = CompilerIntrinsics.getDimensionsFromClass(cls);
        VMHelpers.checkcastTypeId(value, toTypeId, toDim);
    }

    @Hidden
    @AutoQueued
    public static void checkcastTypeId(Object value, CNative.type_id toTypeId, Stdint.uint8_t toDimensions) {
        if (value == null || VMHelpers.isAssignableTo(value, toTypeId, toDimensions)) {
            return;
        }
        throw new ClassCastException();
    }

    @NoSideEffects
    @Hidden
    public static boolean isAssignableTo(Object value, CNative.type_id toTypeId, Stdint.uint8_t toDimensions) {
        CNative.type_id fromTypeId = CompilerIntrinsics.typeIdOf(value);
        if (CompilerIntrinsics.isReferenceArray(fromTypeId)) {
            return VMHelpers.isTypeIdAssignableTo(CompilerIntrinsics.elementTypeIdOf(value), CompilerIntrinsics.dimensionsOf(value), toTypeId, toDimensions);
        }
        return VMHelpers.isTypeIdAssignableTo(fromTypeId, (Stdint.uint8_t)CNative.zero(), toTypeId, toDimensions);
    }

    @NoSideEffects
    @Hidden
    public static boolean isTypeIdAssignableTo(CNative.type_id fromTypeId, Stdint.uint8_t fromDimensions, CNative.type_id toTypeId, Stdint.uint8_t toDimensions) {
        return fromDimensions == toDimensions && VMHelpers.isAssignableToLeaf(fromTypeId, toTypeId) || fromDimensions.isGt((CNative.word)toDimensions) && VMHelpers.isAssignableToLeaf(CompilerIntrinsics.getReferenceArrayTypeId(), toTypeId);
    }

    @NoSideEffects
    @Hidden
    private static boolean isAssignableToLeaf(CNative.type_id fromTypeId, CNative.type_id toTypeId) {
        if (CompilerIntrinsics.isPrimitive(toTypeId) || CompilerIntrinsics.isPrimitive(fromTypeId)) {
            return false;
        }
        if (CompilerIntrinsics.isInterface(toTypeId)) {
            return CompilerIntrinsics.doesImplement(fromTypeId, toTypeId);
        }
        return toTypeId.isLe((CNative.word)fromTypeId) && fromTypeId.isLe((CNative.word)CompilerIntrinsics.maxSubClassTypeIdOf(toTypeId));
    }

    @Hidden
    @AutoQueued
    public static Class<?> getClassFromObject(Object instance) {
        CNative.type_id typeId = CompilerIntrinsics.typeIdOf(instance);
        Stdint.uint8_t dims = (Stdint.uint8_t)CNative.word((int)0);
        if (CompilerIntrinsics.isReferenceArray(typeId)) {
            typeId = CompilerIntrinsics.elementTypeIdOf(instance);
            dims = CompilerIntrinsics.dimensionsOf(instance);
        }
        return CompilerIntrinsics.getClassFromTypeId(typeId, dims);
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseAbstractMethodError() {
        throw new AbstractMethodError();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseArithmeticException() {
        throw new ArithmeticException();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseArrayIndexOutOfBoundsException() {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseArrayStoreException() {
        throw new ArrayStoreException();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseClassCastException() {
        throw new ClassCastException();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseIncompatibleClassChangeError() {
        throw new IncompatibleClassChangeError();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseNegativeArraySizeException() {
        throw new NegativeArraySizeException();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseNullPointerException() {
        throw new NullPointerException();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseUnsatisfiedLinkError(String target) {
        throw new UnsatisfiedLinkError(target);
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseUnsatisfiedLinkErrorDispatchStub() {
        throw new UnsatisfiedLinkError();
    }

    @Hidden
    @NoReturn
    @Inline(value=InlineCondition.NEVER)
    @AutoQueued
    static void raiseUnreachableCodeError(String target) {
        throw new NotReachableException(target);
    }

    public static Class<?> findLoadedClass(String name, ClassLoader loader) {
        int loaderIndex = -1;
        if (loader == null) {
            loaderIndex = 0;
        } else {
            for (int i = 0; i < InitialHeap.classLoaders.length; ++i) {
                if (InitialHeap.classLoaders[i] != loader) continue;
                loaderIndex = i;
                break;
            }
        }
        if (loaderIndex == -1) {
            return null;
        }
        int idx = Arrays.binarySearch(InitialHeap.classNames[loaderIndex], name);
        return idx >= 0 ? InitialHeap.classes[loaderIndex][idx] : null;
    }
}

