/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.stackwalk;

import java.lang.invoke.MethodType;
import org.qbicc.runtime.AutoQueued;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.Hidden;
import org.qbicc.runtime.NoSafePoint;
import org.qbicc.runtime.NoThrow;
import org.qbicc.runtime.StackObject;
import org.qbicc.runtime.main.CompilerIntrinsics;
import org.qbicc.runtime.stackwalk.CallSiteTable;
import org.qbicc.runtime.stackwalk.ClassAccess;
import org.qbicc.runtime.stackwalk.StackWalker;

public final class JavaStackWalker
extends StackObject {
    private static final int I_ACC_HIDDEN = 262144;
    private final boolean skipHidden;
    private int index = -1;
    private // Could not load outer class - annotation placement on inner may be incorrect
    CNative.ptr<@CNative.c_const CallSiteTable.struct_call_site> call_site_ptr;
    private // Could not load outer class - annotation placement on inner may be incorrect
    CNative.ptr<@CNative.c_const CallSiteTable.struct_source> source_ptr;

    @NoSafePoint
    @NoThrow
    public JavaStackWalker(boolean skipHidden) {
        this.skipHidden = skipHidden;
    }

    @NoSafePoint
    @NoThrow
    public JavaStackWalker(JavaStackWalker original) {
        this.skipHidden = original.skipHidden;
        this.index = original.index;
        this.call_site_ptr = original.call_site_ptr;
        this.source_ptr = original.source_ptr;
    }

    @NoSafePoint
    @NoThrow
    public boolean next(StackWalker stackWalker) {
        while (true) {
            if (this.source_ptr != null) {
                this.source_ptr = CallSiteTable.getInlinedAt(this.source_ptr);
            } else {
                if (!stackWalker.next()) {
                    return false;
                }
                this.call_site_ptr = CallSiteTable.findInsnTableEntry(stackWalker.getIp());
                if (this.call_site_ptr == null) continue;
                this.source_ptr = CallSiteTable.getCallSiteSourceInfo(this.call_site_ptr);
            }
            if (this.source_ptr == null) continue;
            // Could not load outer class - annotation placement on inner may be incorrect
            CNative.ptr<@CNative.c_const CallSiteTable.struct_subprogram> method_ptr = CallSiteTable.getMethodInfo(this.source_ptr);
            if (!this.skipHidden || !CallSiteTable.methodHasAllModifiersOf(method_ptr, 262144)) break;
        }
        ++this.index;
        return true;
    }

    @Hidden
    @AutoQueued
    @NoSafePoint
    @NoThrow
    public static int getFrameCount(Throwable exceptionObject) {
        StackWalker sw = new StackWalker();
        JavaStackWalker javaStackWalker = new JavaStackWalker(true);
        int cnt = 0;
        while (javaStackWalker.next(sw)) {
            ++cnt;
        }
        return cnt;
    }

    @Hidden
    @NoSafePoint
    @NoThrow
    public static int getFrameCount(int skipRawFrames, int skipJavaFrames, boolean skipHidden) {
        StackWalker sw = new StackWalker();
        for (int i = 0; i < skipRawFrames; ++i) {
            sw.next();
        }
        JavaStackWalker jsw = new JavaStackWalker(skipHidden);
        for (int i = 0; i < skipJavaFrames; ++i) {
            jsw.next(sw);
        }
        int cnt = 0;
        while (jsw.next(sw)) {
            ++cnt;
        }
        return cnt;
    }

    @NoSafePoint
    @NoThrow
    public int getIndex() {
        return this.index;
    }

    @NoSafePoint
    @NoThrow
    public String getFrameSourceFileName() {
        return CallSiteTable.getMethodFileName(CallSiteTable.getMethodInfo(this.source_ptr));
    }

    @NoSafePoint
    @NoThrow
    public String getFrameMethodName() {
        return CallSiteTable.getMethodName(CallSiteTable.getMethodInfo(this.source_ptr));
    }

    @NoSafePoint
    @NoThrow
    public MethodType getFrameMethodType() {
        return CallSiteTable.getMethodType(CallSiteTable.getMethodInfo(this.source_ptr));
    }

    @NoSafePoint
    @NoThrow
    public String getFrameClassName() {
        CNative.type_id enclosingType = CallSiteTable.getEnclosingType(CallSiteTable.getMethodInfo(this.source_ptr));
        ClassAccess clazz = (ClassAccess)((Object)CompilerIntrinsics.getClassFromTypeIdSimple(enclosingType));
        return clazz.name;
    }

    @NoSafePoint
    @NoThrow
    public CNative.ptr<CallSiteTable.struct_call_site> getCallSitePtr() {
        return this.call_site_ptr;
    }

    @NoSafePoint
    @NoThrow
    public CNative.ptr<CallSiteTable.struct_source> getSourcePtr() {
        return this.source_ptr;
    }

    @NoSafePoint
    @NoThrow
    public Class<?> getFrameClass() {
        return CompilerIntrinsics.getClassFromTypeIdSimple(CallSiteTable.getEnclosingType(CallSiteTable.getMethodInfo(this.source_ptr)));
    }

    @NoSafePoint
    @NoThrow
    public int getFrameLineNumber() {
        return ((CallSiteTable.struct_source)((Object)CNative.deref(this.source_ptr))).line.intValue();
    }

    @NoSafePoint
    @NoThrow
    public int getFrameBytecodeIndex() {
        return ((CallSiteTable.struct_source)((Object)CNative.deref(this.source_ptr))).bci.intValue();
    }

    @NoSafePoint
    @NoThrow
    public int getSourceIndex() {
        return CallSiteTable.getCallSiteSourceIndex(this.call_site_ptr);
    }

    @NoSafePoint
    @NoThrow
    public void reset() {
        this.call_site_ptr = (CNative.ptr)CNative.zero();
        this.source_ptr = (CNative.ptr)CNative.zero();
        this.index = -1;
    }
}

