/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.stackwalk;

import org.qbicc.runtime.AutoQueued;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.stackwalk.CallSiteTable;
import org.qbicc.runtime.stackwalk.ModuleDescriptorAccess;
import org.qbicc.runtime.stackwalk.StackTraceElementAccess;

public final class MethodData {
    @AutoQueued
    public static void fillStackTraceElements(StackTraceElement[] steArray, Object backtrace, int depth) {
        int[] sourceCodeIndexList = (int[])backtrace;
        for (int i = 0; i < depth; ++i) {
            String modVer;
            String modName;
            int sc = sourceCodeIndexList[i];
            // Could not load outer class - annotation placement on inner may be incorrect
            CNative.ptr<@CNative.c_const CallSiteTable.struct_source> sourceInfo = CallSiteTable.getSourceInfo(sc);
            // Could not load outer class - annotation placement on inner may be incorrect
            CNative.ptr<@CNative.c_const CallSiteTable.struct_subprogram> methodInfo = CallSiteTable.getMethodInfo(sourceInfo);
            Class<?> clazz = CallSiteTable.getEnclosingTypeClass(methodInfo);
            Module module = clazz.getModule();
            if (module == null) {
                modName = null;
                modVer = null;
            } else {
                ModuleDescriptorAccess descriptor = (ModuleDescriptorAccess)((Object)module.getDescriptor());
                if (descriptor == null) {
                    modName = null;
                    modVer = null;
                } else {
                    modName = module.getName();
                    modVer = descriptor.rawVersionString;
                }
            }
            ClassLoader classLoader = clazz.getClassLoader();
            String classLoaderName = classLoader == null ? null : classLoader.getName();
            steArray[i] = new StackTraceElement(classLoaderName, modName, modVer, clazz.getName(), CallSiteTable.getMethodName(methodInfo), CallSiteTable.getMethodFileName(methodInfo), CallSiteTable.getSourceLine(sourceInfo));
            ((StackTraceElementAccess)((Object)steArray[i])).declaringClassObject = clazz;
        }
    }
}

