/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.unwind;

import org.qbicc.runtime.Build;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.stdc.Stddef;
import org.qbicc.runtime.stdc.Stdint;

@CNative.include(value="<unwind.h>")
@CNative.lib.List(value={@CNative.lib(value="gcc_s", unless={Build.Target.IsMacOs.class, Build.Target.IsWasm.class}), @CNative.lib(value="gcc_s.1", when={Build.Target.IsMacOs.class})})
public final class Unwind {
    public static final _Unwind_Reason_Code _URC_NO_REASON = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_OK = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_FOREIGN_EXCEPTION_CAUGHT = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_FATAL_PHASE2_ERROR = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_FATAL_PHASE1_ERROR = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_NORMAL_STOP = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_END_OF_STACK = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_HANDLER_FOUND = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_INSTALL_CONTEXT = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Reason_Code _URC_CONTINUE_UNWIND = (_Unwind_Reason_Code)CNative.constant();
    @CNative.incomplete(unless={Build.Target.IsArm.class})
    public static final _Unwind_Reason_Code _URC_FAILURE = (_Unwind_Reason_Code)CNative.constant();
    public static final _Unwind_Action _UA_SEARCH_PHASE = (_Unwind_Action)CNative.constant();
    public static final _Unwind_Action _UA_CLEANUP_PHASE = (_Unwind_Action)CNative.constant();
    public static final _Unwind_Action _UA_HANDLER_FRAME = (_Unwind_Action)CNative.constant();
    public static final _Unwind_Action _UA_FORCE_UNWIND = (_Unwind_Action)CNative.constant();
    public static final _Unwind_Action _UA_END_OF_STACK = (_Unwind_Action)CNative.constant();
    public static final CNative.c_int SP;
    public static final Stdint.uint64_t QBICC_EXCEPTION_CLASS;

    private Unwind() {
    }

    public static native _Unwind_Reason_Code _Unwind_RaiseException(CNative.ptr<struct__Unwind_Exception> var0);

    public static native void _Unwind_Resume(CNative.ptr<struct__Unwind_Exception> var0);

    public static native void _Unwind_DeleteException(CNative.ptr<struct__Unwind_Exception> var0);

    public static native CNative.unsigned_long _Unwind_GetGR(CNative.ptr<struct__Unwind_Context> var0, CNative.c_int var1);

    public static native void _Unwind_SetGR(CNative.ptr<struct__Unwind_Context> var0, CNative.c_int var1, CNative.unsigned_long var2);

    public static native CNative.unsigned_long _Unwind_GetIP(CNative.ptr<struct__Unwind_Context> var0);

    public static native void _Unwind_SetIP(CNative.ptr<struct__Unwind_Context> var0, CNative.unsigned_long var1);

    public static native CNative.unsigned_long _Unwind_GetRegionStart(CNative.ptr<struct__Unwind_Context> var0);

    public static native CNative.unsigned_long _Unwind_GetLanguageSpecificData(CNative.ptr<struct__Unwind_Context> var0);

    public static native _Unwind_Reason_Code _Unwind_ForcedUnwind(CNative.ptr<struct__Unwind_Exception> var0, CNative.function_ptr<_Unwind_Stop_Fn> var1, CNative.void_ptr var2);

    @CNative.export
    public static _Unwind_Reason_Code personality(CNative.c_int version, _Unwind_Action action, Stdint.uint64_t exceptionClass, CNative.ptr<struct__Unwind_Exception> exceptionObject, CNative.ptr<struct__Unwind_Context> context) {
        CNative.unsigned_long ip = Unwind._Unwind_GetIP(context);
        ip = (CNative.unsigned_long)CNative.word((long)(ip.longValue() - 1L));
        CNative.unsigned_long methodStart = Unwind._Unwind_GetRegionStart(context);
        CNative.unsigned_long lsda = Unwind._Unwind_GetLanguageSpecificData(context);
        long offset = ip.longValue() - methodStart.longValue();
        CNative.ptr lsdaPtr = (CNative.ptr)lsda.cast();
        long lpOffset = Unwind.getHandlerOffset((CNative.ptr<Stdint.uint8_t>)lsdaPtr, offset);
        if ((action.intValue() & _UA_SEARCH_PHASE.intValue()) != 0) {
            if (lpOffset == 0L) {
                return _URC_CONTINUE_UNWIND;
            }
            return _URC_HANDLER_FOUND;
        }
        if ((action.intValue() & _UA_HANDLER_FRAME.intValue()) != 0) {
            Unwind._Unwind_SetIP(context, (CNative.unsigned_long)CNative.word((long)(methodStart.longValue() + lpOffset)));
            return _URC_INSTALL_CONTEXT;
        }
        return _URC_CONTINUE_UNWIND;
    }

    public static long getHandlerOffset(CNative.ptr<Stdint.uint8_t> lsda, long pcOffset) {
        Stdint.uint8_t typeEncodingEncoding;
        int offset = CNative.auto((int)0);
        Stdint.int32_t_ptr offsetPtr = CNative.addr_of((int)offset);
        Stdint.uint8_t header = (Stdint.uint8_t)lsda.plus(offset++).loadPlain();
        if ((typeEncodingEncoding = (Stdint.uint8_t)lsda.plus(offset++).loadPlain()).byteValue() != -1) {
            long l = Unwind.readULEB(lsda, (CNative.ptr<Stdint.int32_t>)offsetPtr);
        }
        Stdint.uint8_t callSiteEncodingEncoding = (Stdint.uint8_t)lsda.plus(offset++).loadPlain();
        byte callSiteEncoding = callSiteEncodingEncoding.byteValue();
        long callSiteTableLength = Unwind.readULEB(lsda, (CNative.ptr<Stdint.int32_t>)offsetPtr);
        long callSiteTableEnd = (long)offset + callSiteTableLength;
        while ((long)((Stdint.int32_t)offsetPtr.loadUnshared()).intValue() < callSiteTableEnd) {
            long startOffset = Unwind.read(lsda, (CNative.ptr<Stdint.int32_t>)offsetPtr, callSiteEncoding);
            long size = Unwind.read(lsda, (CNative.ptr<Stdint.int32_t>)offsetPtr, callSiteEncoding);
            long lpOffset = Unwind.read(lsda, (CNative.ptr<Stdint.int32_t>)offsetPtr, callSiteEncoding);
            long action = Unwind.readULEB(lsda, (CNative.ptr<Stdint.int32_t>)offsetPtr);
            if (startOffset > pcOffset || pcOffset >= startOffset + size) continue;
            return lpOffset;
        }
        return 0L;
    }

    public static long read(CNative.ptr<Stdint.uint8_t> lsda, CNative.ptr<Stdint.int32_t> offset, int callSiteEncoding) {
        long result = 0L;
        switch (callSiteEncoding) {
            case 1: {
                result = Unwind.readULEB(lsda, offset);
                break;
            }
            case 3: {
                int offsetVal = ((Stdint.int32_t)offset.loadPlain()).intValue();
                CNative.ptr adjustedLsda = (CNative.ptr)lsda.plus(offsetVal).cast();
                result = ((Stdint.uint32_t)adjustedLsda.loadPlain()).longValue();
                offset.storePlain((Object)((Stdint.int32_t)CNative.word((int)(offsetVal + 4))));
                break;
            }
        }
        return result;
    }

    public static long readULEB(CNative.ptr<Stdint.uint8_t> lsda, CNative.ptr<Stdint.int32_t> offset) {
        long result = 0L;
        int shift = 0;
        byte singleByte = 0;
        do {
            int offsetVal = ((Stdint.int32_t)offset.loadPlain()).intValue();
            singleByte = ((Stdint.uint8_t)lsda.plus(offsetVal).loadPlain()).byteValue();
            offset.storePlain((Object)((Stdint.int32_t)CNative.word((int)(offsetVal + 1))));
            result |= ((long)singleByte & 0x7FL) << shift;
            shift += 7;
        } while ((singleByte & 0x80) != 0);
        return result;
    }

    static {
        if (Build.Target.isAarch64()) {
            SP = (CNative.c_int)CNative.word((int)31);
        } else if (Build.Target.isArm()) {
            SP = (CNative.c_int)CNative.word((int)13);
        } else if (Build.Target.isAmd64()) {
            SP = (CNative.c_int)CNative.word((int)7);
        } else if (Build.Target.isI386()) {
            SP = (CNative.c_int)CNative.word((int)4);
        } else if (Build.Target.isWasm()) {
            SP = (CNative.c_int)CNative.word((int)4);
        } else {
            throw new IllegalStateException("Unsupported architecture");
        }
        QBICC_EXCEPTION_CLASS = (Stdint.uint64_t)CNative.word((long)8170208549171975745L);
    }

    public static final class _Unwind_Action
    extends CNative.word {
    }

    public static final class _Unwind_Reason_Code
    extends CNative.word {
    }

    @FunctionalInterface
    public static interface _Unwind_Stop_Fn {
        public _Unwind_Reason_Code run(CNative.c_int var1, _Unwind_Action var2, Stdint.uint64_t var3, CNative.ptr<struct__Unwind_Context> var4, CNative.ptr<struct__Unwind_Context> var5, CNative.void_ptr var6);
    }

    @CNative.incomplete
    public static final class struct__Unwind_Context
    extends CNative.struct {
    }

    @FunctionalInterface
    public static interface _Unwind_Exception_Cleanup_Fn {
        public void cleanup(_Unwind_Reason_Code var1, CNative.ptr<struct__Unwind_Exception> var2);
    }

    @CNative.align_as(value=Stddef.max_align_t.class)
    public static final class struct__Unwind_Exception
    extends CNative.struct {
        public Stdint.uint64_t exception_class;
        public CNative.function_ptr<_Unwind_Exception_Cleanup_Fn> exception_cleanup;
    }
}

