/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.rt.annotation.processors;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.qbicc.rt.annotation.Tracking;

@SupportedAnnotationTypes(value={"org.qbicc.rt.annotation.Tracking", "org.qbicc.rt.annotation.Tracking.List"})
@AutoService(value={Processor.class})
public class TrackingProcessor
extends AbstractProcessor {
    private HashSet<String> trackedFiles = new HashSet();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                for (Tracking ta : (Tracking[])element.getAnnotationsByType(Tracking.class)) {
                    this.trackedFiles.add(ta.value());
                }
            }
        }
        if (!this.trackedFiles.isEmpty()) {
            try {
                FileObject tracked = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "TrackedFiles.txt", new Element[0]);
                PrintWriter printWriter = new PrintWriter(tracked.openOutputStream(), true);
                this.trackedFiles.stream().sorted(Comparator.naturalOrder()).forEach(f -> pw.println((String)f));
            }
            catch (IOException e) {
                System.err.println(e);
                e.printStackTrace(System.err);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error writing TrackedFiles.txt");
            }
            this.trackedFiles.clear();
        }
        return true;
    }
}

