/*
 * Decompiled with CFR 0.152.
 */
package apple.security;

import apple.security.KeychainStore;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import sun.security.util.SecurityConstants;

public final class AppleProvider
extends Provider {
    private static final String info = "Apple Provider";

    public AppleProvider() {
        super("Apple", SecurityConstants.PROVIDER_VER, info);
        final AppleProvider p = this;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AppleProvider.this.putService(new ProviderService(p, "KeyStore", "KeychainStore", "apple.security.KeychainStore"));
                return null;
            }
        });
    }

    private static final class ProviderService
    extends Provider.Service {
        ProviderService(Provider p, String type, String algo, String cn) {
            super(p, type, algo, cn, null, null);
        }

        @Override
        public Object newInstance(Object ctrParamObj) throws NoSuchAlgorithmException {
            String type = this.getType();
            if (ctrParamObj != null) {
                throw new InvalidParameterException("constructorParameter not used with " + type + " engines");
            }
            String algo = this.getAlgorithm();
            try {
                if (type.equals("KeyStore") && algo.equals("KeychainStore")) {
                    return new KeychainStore();
                }
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Error constructing " + type + " for " + algo + " using Apple", ex);
            }
            throw new ProviderException("No impl for " + algo + " " + type);
        }
    }
}

