/*
 * Decompiled with CFR 0.152.
 */
package apple.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import jdk.internal.loader.BootLoader;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class KeychainStore
extends KeyStoreSpi {
    private Hashtable<String, Object> deletedEntries = new Hashtable();
    private Hashtable<String, Object> addedEntries = new Hashtable();
    private Hashtable<String, Object> entries = new Hashtable();
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID = ObjectIdentifier.of(KnownOIDs.PKCS8ShroudedKeyBag);
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID = ObjectIdentifier.of(KnownOIDs.PBEWithSHA1AndDESede);
    private static final int iterationCount = 1024;
    private static final int SALT_LEN = 20;
    private static final Debug debug = Debug.getInstance("keystore");
    private SecureRandom random;

    private static void permissionCheck() {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(new RuntimePermission("useKeychainStore"));
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object entry;
        KeychainStore.permissionCheck();
        if (password == null || password.length == 0) {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            password = Long.toString(this.random.nextLong()).toCharArray();
        }
        if ((entry = this.entries.get(alias.toLowerCase())) == null || !(entry instanceof KeyEntry)) {
            return null;
        }
        byte[] exportedKeyInfo = this._getEncodedKeyData(((KeyEntry)entry).keyRef, password);
        if (exportedKeyInfo == null) {
            return null;
        }
        PrivateKey returnValue = null;
        try {
            AlgorithmParameters algParams;
            ObjectIdentifier algOid;
            byte[] encryptedKey;
            byte[] pkcs8KeyData = this.fetchPrivateKeyFromBag(exportedKeyInfo);
            try {
                EncryptedPrivateKeyInfo encrInfo = new EncryptedPrivateKeyInfo(pkcs8KeyData);
                encryptedKey = encrInfo.getEncryptedData();
                DerValue val = new DerValue(encrInfo.getAlgorithm().encode());
                DerInputStream in = val.toDerInputStream();
                algOid = in.getOID();
                algParams = this.parseAlgParameters(in);
            }
            catch (IOException ioe) {
                UnrecoverableKeyException uke = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + ioe);
                uke.initCause(ioe);
                throw uke;
            }
            SecretKey skey = this.getPBEKey(password);
            Cipher cipher = Cipher.getInstance(algOid.toString());
            cipher.init(2, (Key)skey, algParams);
            byte[] decryptedPrivateKey = cipher.doFinal(encryptedKey);
            PKCS8EncodedKeySpec kspec = new PKCS8EncodedKeySpec(decryptedPrivateKey);
            DerValue val = new DerValue(decryptedPrivateKey);
            DerInputStream in = val.toDerInputStream();
            int i = in.getInteger();
            DerValue[] value = in.getSequence(2);
            if (value.length < 1 || value.length > 2) {
                throw new IOException("Invalid length for AlgorithmIdentifier");
            }
            AlgorithmId algId = new AlgorithmId(value[0].getOID());
            String algName = algId.getName();
            KeyFactory kfac = KeyFactory.getInstance(algName);
            returnValue = kfac.generatePrivate(kspec);
        }
        catch (Exception e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Get Key failed: " + e.getMessage());
            uke.initCause(e);
            throw uke;
        }
        return returnValue;
    }

    private native byte[] _getEncodedKeyData(long var1, char[] var3);

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        KeychainStore.permissionCheck();
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof KeyEntry) {
            if (((KeyEntry)entry).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)entry).chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        KeychainStore.permissionCheck();
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)entry).cert;
            }
            KeyEntry ke = (KeyEntry)entry;
            if (ke.chain == null || ke.chain.length == 0) {
                return null;
            }
            return ke.chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        KeychainStore.permissionCheck();
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)entry).date.getTime());
            }
            return new Date(((KeyEntry)entry).date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            try {
                String lowerAlias;
                KeyEntry entry = new KeyEntry();
                entry.date = new Date();
                if (key instanceof PrivateKey) {
                    if (!key.getFormat().equals("PKCS#8") && !key.getFormat().equals("PKCS8")) {
                        throw new KeyStoreException("Private key is not encoded as PKCS#8");
                    }
                } else {
                    throw new KeyStoreException("Key is not a PrivateKey");
                }
                entry.protectedPrivKey = this.encryptPrivateKey(key.getEncoded(), password);
                entry.password = (char[])password.clone();
                if (chain != null) {
                    if (chain.length > 1 && !this.validateChain(chain)) {
                        throw new KeyStoreException("Certificate chain does not validate");
                    }
                    entry.chain = (Certificate[])chain.clone();
                    entry.chainRefs = new long[entry.chain.length];
                }
                if (this.entries.get(lowerAlias = alias.toLowerCase()) != null) {
                    this.deletedEntries.put(lowerAlias, this.entries.get(lowerAlias));
                }
                this.entries.put(lowerAlias, entry);
                this.addedEntries.put(lowerAlias, entry);
            }
            catch (Exception nsae) {
                KeyStoreException ke = new KeyStoreException("Key protection algorithm not found: " + nsae);
                ke.initCause(nsae);
                throw ke;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            String lowerAlias;
            KeyEntry entry = new KeyEntry();
            try {
                EncryptedPrivateKeyInfo privateKey = new EncryptedPrivateKeyInfo(key);
                entry.protectedPrivKey = privateKey.getEncoded();
            }
            catch (IOException ioe) {
                throw new KeyStoreException("key is not encoded as EncryptedPrivateKeyInfo");
            }
            entry.date = new Date();
            if (chain != null && chain.length != 0) {
                entry.chain = (Certificate[])chain.clone();
                entry.chainRefs = new long[entry.chain.length];
            }
            if (this.entries.get(lowerAlias = alias.toLowerCase()) != null) {
                this.deletedEntries.put(lowerAlias, this.entries.get(alias));
            }
            this.entries.put(lowerAlias, entry);
            this.addedEntries.put(lowerAlias, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null && entry instanceof KeyEntry) {
                throw new KeyStoreException("Cannot overwrite key entry with certificate");
            }
            Collection<Object> allValues = this.entries.values();
            for (Object value : allValues) {
                if (!(value instanceof TrustedCertEntry)) continue;
                TrustedCertEntry tce = (TrustedCertEntry)value;
                if (!tce.cert.equals(cert)) continue;
                throw new KeyStoreException("Keychain does not support mulitple copies of same certificate.");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = cert;
            trustedCertEntry.date = new Date();
            String lowerAlias = alias.toLowerCase();
            if (this.entries.get(lowerAlias) != null) {
                this.deletedEntries.put(lowerAlias, this.entries.get(lowerAlias));
            }
            this.entries.put(lowerAlias, trustedCertEntry);
            this.addedEntries.put(lowerAlias, trustedCertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.remove(alias.toLowerCase());
            this.deletedEntries.put(alias.toLowerCase(), entry);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        KeychainStore.permissionCheck();
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        KeychainStore.permissionCheck();
        return this.entries.containsKey(alias.toLowerCase());
    }

    @Override
    public int engineSize() {
        KeychainStore.permissionCheck();
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        KeychainStore.permissionCheck();
        Object entry = this.entries.get(alias.toLowerCase());
        return entry != null && entry instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        KeychainStore.permissionCheck();
        Object entry = this.entries.get(alias.toLowerCase());
        return entry != null && entry instanceof TrustedCertEntry;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        KeychainStore.permissionCheck();
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                certElem = ((TrustedCertEntry)entry).cert;
            } else {
                KeyEntry ke = (KeyEntry)entry;
                if (ke.chain == null || ke.chain.length == 0) continue;
                certElem = ke.chain[0];
            }
            if (!certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object entry;
        String alias;
        KeychainStore.permissionCheck();
        Enumeration<String> e = this.deletedEntries.keys();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            entry = this.deletedEntries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                if (((TrustedCertEntry)entry).certRef == 0L) continue;
                this._removeItemFromKeychain(((TrustedCertEntry)entry).certRef);
                this._releaseKeychainItemRef(((TrustedCertEntry)entry).certRef);
                continue;
            }
            KeyEntry keyEntry = (KeyEntry)entry;
            if (keyEntry.chain == null) continue;
            for (int i = 0; i < keyEntry.chain.length; ++i) {
                if (keyEntry.chainRefs[i] == 0L) continue;
                this._removeItemFromKeychain(keyEntry.chainRefs[i]);
                this._releaseKeychainItemRef(keyEntry.chainRefs[i]);
            }
            if (keyEntry.keyRef == 0L) continue;
            this._removeItemFromKeychain(keyEntry.keyRef);
            this._releaseKeychainItemRef(keyEntry.keyRef);
        }
        e = this.addedEntries.keys();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            entry = this.addedEntries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                TrustedCertEntry tce = (TrustedCertEntry)entry;
                Certificate certElem = tce.cert;
                tce.certRef = this.addCertificateToKeychain(alias, certElem);
                continue;
            }
            KeyEntry keyEntry = (KeyEntry)entry;
            if (keyEntry.chain == null) continue;
            for (int i = 0; i < keyEntry.chain.length; ++i) {
                keyEntry.chainRefs[i] = this.addCertificateToKeychain(alias, keyEntry.chain[i]);
            }
            keyEntry.keyRef = this._addItemToKeychain(alias, false, keyEntry.protectedPrivKey, keyEntry.password);
        }
        this.deletedEntries.clear();
        this.addedEntries.clear();
    }

    private long addCertificateToKeychain(String alias, Certificate cert) {
        byte[] certblob = null;
        long returnValue = 0L;
        try {
            certblob = cert.getEncoded();
            returnValue = this._addItemToKeychain(alias, true, certblob, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    private native long _addItemToKeychain(String var1, boolean var2, byte[] var3, char[] var4);

    private native int _removeItemFromKeychain(long var1);

    private native void _releaseKeychainItemRef(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        KeychainStore.permissionCheck();
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Enumeration<String> e = this.entries.keys();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Object entry = this.entries.get(alias);
                if (entry instanceof TrustedCertEntry) {
                    if (((TrustedCertEntry)entry).certRef == 0L) continue;
                    this._releaseKeychainItemRef(((TrustedCertEntry)entry).certRef);
                    continue;
                }
                KeyEntry keyEntry = (KeyEntry)entry;
                if (keyEntry.chain == null) continue;
                for (int i = 0; i < keyEntry.chain.length; ++i) {
                    if (keyEntry.chainRefs[i] == 0L) continue;
                    this._releaseKeychainItemRef(keyEntry.chainRefs[i]);
                }
                if (keyEntry.keyRef == 0L) continue;
                this._releaseKeychainItemRef(keyEntry.keyRef);
            }
            this.entries.clear();
            this._scanKeychain();
            if (debug != null) {
                debug.println("KeychainStore load entry count: " + this.entries.size());
            }
        }
    }

    private native void _scanKeychain();

    private void createTrustedCertEntry(String alias, long keychainItemRef, long creationDate, byte[] derStream) {
        TrustedCertEntry tce = new TrustedCertEntry();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream input = new ByteArrayInputStream(derStream);
            X509Certificate cert = (X509Certificate)cf.generateCertificate(input);
            ((InputStream)input).close();
            tce.cert = cert;
            tce.certRef = keychainItemRef;
            tce.date = creationDate != 0L ? new Date(creationDate) : new Date();
            int uniqueVal = 1;
            String originalAlias = alias;
            while (this.entries.containsKey(alias.toLowerCase())) {
                alias = originalAlias + " " + uniqueVal;
                ++uniqueVal;
            }
            this.entries.put(alias.toLowerCase(), tce);
        }
        catch (Exception e) {
            System.err.println("KeychainStore Ignored Exception: " + e);
        }
    }

    private void createKeyEntry(String alias, long creationDate, long secKeyRef, long[] secCertificateRefs, byte[][] rawCertData) {
        KeyEntry ke = new KeyEntry();
        ke.protectedPrivKey = null;
        ke.keyRef = secKeyRef;
        ke.date = creationDate != 0L ? new Date(creationDate) : new Date();
        ArrayList<CertKeychainItemPair> createdCerts = new ArrayList<CertKeychainItemPair>();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < rawCertData.length; ++i) {
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(rawCertData[i]);
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(input);
                    ((InputStream)input).close();
                    createdCerts.add(new CertKeychainItemPair(secCertificateRefs[i], cert));
                    continue;
                }
                catch (CertificateException e) {
                    System.err.println("KeychainStore Ignored Exception: " + e);
                }
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        CertKeychainItemPair[] objArray = createdCerts.toArray(new CertKeychainItemPair[0]);
        Certificate[] certArray = new Certificate[objArray.length];
        long[] certRefArray = new long[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            CertKeychainItemPair addedItem = objArray[i];
            certArray[i] = addedItem.mCert;
            certRefArray[i] = addedItem.mCertificateRef;
        }
        ke.chain = certArray;
        ke.chainRefs = certRefArray;
        int uniqueVal = 1;
        String originalAlias = alias;
        while (this.entries.containsKey(alias.toLowerCase())) {
            alias = originalAlias + " " + uniqueVal;
            ++uniqueVal;
        }
        this.entries.put(alias.toLowerCase(), ke);
    }

    private boolean validateChain(Certificate[] certChain) {
        for (int i = 0; i < certChain.length - 1; ++i) {
            X500Principal subjectDN;
            X500Principal issuerDN = ((X509Certificate)certChain[i]).getIssuerX500Principal();
            if (issuerDN.equals(subjectDN = ((X509Certificate)certChain[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }

    private byte[] fetchPrivateKeyFromBag(byte[] privateKeyInfo) throws IOException, NoSuchAlgorithmException, CertificateException {
        byte[] returnValue = null;
        DerValue val = new DerValue(new ByteArrayInputStream(privateKeyInfo));
        DerInputStream s = val.toDerInputStream();
        int version = s.getInteger();
        if (version != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        ContentInfo authSafe = new ContentInfo(s);
        ObjectIdentifier contentType = authSafe.getContentType();
        if (!contentType.equals(ContentInfo.DATA_OID)) {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] authSafeData = authSafe.getData();
        DerInputStream as = new DerInputStream(authSafeData);
        DerValue[] safeContentsArray = as.getSequence(2);
        int count = safeContentsArray.length;
        for (int i = 0; i < count; ++i) {
            Object eAlgId = null;
            DerInputStream sci = new DerInputStream(safeContentsArray[i].toByteArray());
            ContentInfo safeContents = new ContentInfo(sci);
            contentType = safeContents.getContentType();
            byte[] safeContentsData = null;
            if (!contentType.equals(ContentInfo.DATA_OID)) {
                if (contentType.equals(ContentInfo.ENCRYPTED_DATA_OID)) continue;
                throw new IOException("public key protected PKCS12 not supported");
            }
            safeContentsData = safeContents.getData();
            DerInputStream sc = new DerInputStream(safeContentsData);
            returnValue = this.extractKeyData(sc);
        }
        return returnValue;
    }

    private byte[] extractKeyData(DerInputStream stream) throws IOException, NoSuchAlgorithmException, CertificateException {
        byte[] returnValue = null;
        DerValue[] safeBags = stream.getSequence(2);
        int count = safeBags.length;
        for (int i = 0; i < count; ++i) {
            Object bagItem = null;
            DerInputStream sbi = safeBags[i].toDerInputStream();
            ObjectIdentifier bagId = sbi.getOID();
            DerValue bagValue = sbi.getDerValue();
            if (!bagValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + bagValue.tag);
            }
            bagValue = bagValue.data.getDerValue();
            if (bagId.equals(PKCS8ShroudedKeyBag_OID)) {
                returnValue = bagValue.toByteArray();
                continue;
            }
            System.out.println("Unsupported bag type '" + bagId + "'");
        }
        return returnValue;
    }

    private AlgorithmParameters getAlgorithmParameters(String algorithm) throws IOException {
        AlgorithmParameters algParams = null;
        PBEParameterSpec paramSpec = new PBEParameterSpec(this.getSalt(), 1024);
        try {
            algParams = AlgorithmParameters.getInstance(algorithm);
            algParams.init(paramSpec);
        }
        catch (Exception e) {
            IOException ioe = new IOException("getAlgorithmParameters failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return algParams;
    }

    private byte[] getSalt() {
        byte[] salt = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(salt);
        return salt;
    }

    private AlgorithmParameters parseAlgParameters(DerInputStream in) throws IOException {
        AlgorithmParameters algParams = null;
        try {
            DerValue params;
            if (in.available() == 0) {
                params = null;
            } else {
                params = in.getDerValue();
                if (params.tag == 5) {
                    params = null;
                }
            }
            if (params != null) {
                algParams = AlgorithmParameters.getInstance("PBE");
                algParams.init(params.toByteArray());
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("parseAlgParameters failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return algParams;
    }

    private SecretKey getPBEKey(char[] password) throws IOException {
        SecretKey skey = null;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory skFac = SecretKeyFactory.getInstance("PBE");
            skey = skFac.generateSecret(keySpec);
        }
        catch (Exception e) {
            IOException ioe = new IOException("getSecretKey failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return skey;
    }

    private byte[] encryptPrivateKey(byte[] data, char[] password) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] key = null;
        try {
            AlgorithmParameters algParams = this.getAlgorithmParameters("PBEWithSHA1AndDESede");
            SecretKey skey = this.getPBEKey(password);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndDESede");
            cipher.init(1, (Key)skey, algParams);
            byte[] encryptedKey = cipher.doFinal(data);
            AlgorithmId algid = new AlgorithmId(pbeWithSHAAnd3KeyTripleDESCBC_OID, algParams);
            EncryptedPrivateKeyInfo encrInfo = new EncryptedPrivateKeyInfo(algid, encryptedKey);
            key = encrInfo.getEncoded();
        }
        catch (Exception e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Encrypt Private Key failed: " + e.getMessage());
            uke.initCause(e);
            throw uke;
        }
        return key;
    }

    static {
        BootLoader.loadLibrary("osxsecurity");
    }

    static class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        char[] password;
        long keyRef;
        Certificate[] chain;
        long[] chainRefs;

        KeyEntry() {
        }
    }

    static class TrustedCertEntry {
        Date date;
        Certificate cert;
        long certRef;

        TrustedCertEntry() {
        }
    }

    private static class CertKeychainItemPair {
        long mCertificateRef;
        Certificate mCert;

        CertKeychainItemPair(long inCertRef, Certificate cert) {
            this.mCertificateRef = inCertRef;
            this.mCert = cert;
        }
    }
}

