/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.KWUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.IllegalBlockSizeException;

class AESKeyWrap
extends FeedbackCipher {
    static final byte[] ICV1 = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    AESKeyWrap() {
        super(new AESCrypt());
    }

    @Override
    String getFeedback() {
        return "KW";
    }

    @Override
    void save() {
        throw new UnsupportedOperationException("save not supported");
    }

    @Override
    void restore() {
        throw new UnsupportedOperationException("restore not supported");
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("Invalid null key");
        }
        if (iv != null && iv.length != 8) {
            throw new InvalidAlgorithmParameterException("Invalid IV");
        }
        this.embeddedCipher.init(decrypting, algorithm, key);
        this.iv = iv == null ? ICV1 : iv;
    }

    @Override
    void reset() {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    int encrypt(byte[] pt, int ptOfs, int ptLen, byte[] ct, int ctOfs) {
        throw new UnsupportedOperationException("multi-part not supported");
    }

    @Override
    int decrypt(byte[] ct, int ctOfs, int ctLen, byte[] pt, int ptOfs) {
        throw new UnsupportedOperationException("multi-part not supported");
    }

    @Override
    int encryptFinal(byte[] pt, int dummy1, int ptLen, byte[] dummy2, int dummy3) throws IllegalBlockSizeException {
        if (ptLen < 24 || ptLen % 8 != 0) {
            throw new IllegalBlockSizeException("data should be at least 16 bytes and multiples of 8");
        }
        return KWUtil.W(this.iv, pt, ptLen, this.embeddedCipher);
    }

    @Override
    int decryptFinal(byte[] ct, int dummy1, int ctLen, byte[] dummy2, int dummy3) throws IllegalBlockSizeException {
        if (ctLen < 24 || ctLen % 8 != 0) {
            throw new IllegalBlockSizeException("data should be at least 24 bytes and multiples of 8");
        }
        byte[] ivOut = new byte[8];
        ctLen = KWUtil.W_INV(ct, ctLen, ivOut, this.embeddedCipher);
        if (!MessageDigest.isEqual(ivOut, this.iv)) {
            throw new IllegalBlockSizeException("Integrity check failed");
        }
        return ctLen;
    }
}

