/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.KWUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import javax.crypto.IllegalBlockSizeException;

class AESKeyWrapPadded
extends FeedbackCipher {
    static final byte[] ICV2 = new byte[]{-90, 89, 89, -90};
    private static final byte[] PAD_BLK = new byte[7];

    private static void setIvAndLen(byte[] dest, byte[] iv, int inLen) {
        assert (dest.length >= 8) : "buffer needs at least 8 bytes";
        System.arraycopy(iv, 0, dest, 0, iv.length);
        dest[4] = (byte)(inLen >>> 24 & 0xFF);
        dest[5] = (byte)(inLen >>> 16 & 0xFF);
        dest[6] = (byte)(inLen >>> 8 & 0xFF);
        dest[7] = (byte)(inLen & 0xFF);
    }

    private static int validateIV(byte[] ivAndLen, byte[] iv) throws IllegalBlockSizeException {
        int match = 0;
        for (int i = 0; i < ICV2.length; ++i) {
            match |= ivAndLen[i] ^ iv[i];
        }
        if (match != 0) {
            throw new IllegalBlockSizeException("Integrity check failed");
        }
        int outLen = ivAndLen[4];
        for (int k = 5; k < 8; ++k) {
            if (outLen != 0) {
                outLen <<= 8;
            }
            outLen |= ivAndLen[k] & 0xFF;
        }
        return outLen;
    }

    AESKeyWrapPadded() {
        super(new AESCrypt());
    }

    @Override
    String getFeedback() {
        return "KWP";
    }

    @Override
    void save() {
        throw new UnsupportedOperationException("save not supported");
    }

    @Override
    void restore() {
        throw new UnsupportedOperationException("restore not supported");
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("Invalid null key");
        }
        if (iv != null && iv.length != ICV2.length) {
            throw new InvalidAlgorithmParameterException("Invalid IV length");
        }
        this.embeddedCipher.init(decrypting, algorithm, key);
        this.iv = iv == null ? ICV2 : iv;
    }

    @Override
    void reset() {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    int encrypt(byte[] pt, int ptOfs, int ptLen, byte[] ct, int ctOfs) {
        throw new UnsupportedOperationException("multi-part not supported");
    }

    @Override
    int decrypt(byte[] ct, int ctOfs, int ctLen, byte[] pt, int ptOfs) {
        throw new UnsupportedOperationException("multi-part not supported");
    }

    @Override
    int encryptFinal(byte[] pt, int dummy1, int ptLen, byte[] dummy2, int dummy3) throws IllegalBlockSizeException {
        int actualLen = ptLen - 8;
        if (actualLen < 1) {
            throw new IllegalBlockSizeException("data should have at least 1 byte");
        }
        if (ptLen % 8 != 0) {
            int rem = 8 - ptLen % 8;
            System.arraycopy(PAD_BLK, 0, pt, ptLen, rem);
            ptLen += rem;
        }
        if (ptLen <= 16) {
            AESKeyWrapPadded.setIvAndLen(pt, this.iv, actualLen);
            this.embeddedCipher.encryptBlock(pt, 0, pt, 0);
        } else {
            byte[] ivAndLen = new byte[8];
            AESKeyWrapPadded.setIvAndLen(ivAndLen, this.iv, actualLen);
            ptLen = KWUtil.W(ivAndLen, pt, ptLen, this.embeddedCipher);
        }
        return ptLen;
    }

    @Override
    int decryptFinal(byte[] ct, int dummy1, int ctLen, byte[] dummy2, int dummy3) throws IllegalBlockSizeException {
        if (ctLen < 16 || ctLen % 8 != 0) {
            throw new IllegalBlockSizeException("data should be at least 16 bytes and multiples of 8");
        }
        byte[] ivAndLen = new byte[8];
        if (ctLen == 16) {
            this.embeddedCipher.decryptBlock(ct, 0, ct, 0);
            System.arraycopy(ct, 0, ivAndLen, 0, 8);
            System.arraycopy(ct, 8, ct, 0, 8);
            ctLen -= 8;
        } else {
            ctLen = KWUtil.W_INV(ct, ctLen, ivAndLen, this.embeddedCipher);
        }
        int outLen = AESKeyWrapPadded.validateIV(ivAndLen, this.iv);
        int padLen = ctLen - outLen;
        if (padLen < 0 || padLen >= 8) {
            throw new IllegalBlockSizeException("Invalid KWP pad length " + padLen);
        }
        for (int k = padLen; k > 0; --k) {
            if (ct[ctLen - k] == 0) continue;
            throw new IllegalBlockSizeException("Invalid KWP pad value");
        }
        return outLen;
    }
}

