/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.HexDumpEncoder;

final class BlockCipherParamsCore {
    private int block_size = 0;
    private byte[] iv = null;
    private int[] moreSizes = null;

    BlockCipherParamsCore(int blksize, int ... moreSizes) {
        this.block_size = blksize;
        this.moreSizes = moreSizes;
    }

    void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        boolean check;
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        byte[] tmpIv = ((IvParameterSpec)paramSpec).getIV();
        boolean bl = check = tmpIv.length == this.block_size;
        if (!check && this.moreSizes != null) {
            for (int s : this.moreSizes) {
                if (tmpIv.length != s) continue;
                check = true;
                break;
            }
        }
        if (!check) {
            String expectedLen = this.block_size + (this.moreSizes == null ? "" : Arrays.toString(this.moreSizes));
            throw new InvalidParameterSpecException("IV length not " + expectedLen + " bytes long");
        }
        this.iv = (byte[])tmpIv.clone();
    }

    void init(byte[] encoded) throws IOException {
        boolean check;
        DerInputStream der = new DerInputStream(encoded);
        byte[] tmpIv = der.getOctetString();
        if (der.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        boolean bl = check = tmpIv.length == this.block_size;
        if (!check) {
            String expectedLen = this.block_size + (this.moreSizes == null ? "" : Arrays.toString(this.moreSizes));
            throw new IOException("IV not " + expectedLen + " bytes long");
        }
        this.iv = tmpIv;
    }

    void init(byte[] encoded, String decodingMethod) throws IOException {
        if (decodingMethod != null && !decodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.init(encoded);
    }

    <T extends AlgorithmParameterSpec> T getParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (IvParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new IvParameterSpec(this.iv)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    byte[] getEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putOctetString(this.iv);
        return out.toByteArray();
    }

    byte[] getEncoded(String encodingMethod) throws IOException {
        return this.getEncoded();
    }

    public String toString() {
        String LINE_SEP = System.lineSeparator();
        String ivString = LINE_SEP + "    iv:" + LINE_SEP + "[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        ivString = ivString + encoder.encodeBuffer(this.iv);
        ivString = ivString + "]" + LINE_SEP;
        return ivString;
    }
}

