/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;
import sun.security.util.ArrayUtil;

final class CipherFeedback
extends FeedbackCipher {
    private final byte[] k;
    private final byte[] register;
    private int numBytes;
    private byte[] registerSave = null;

    CipherFeedback(SymmetricCipher embeddedCipher, int numBytes) {
        super(embeddedCipher);
        if (numBytes > this.blockSize) {
            numBytes = this.blockSize;
        }
        this.numBytes = numBytes;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
    }

    @Override
    String getFeedback() {
        return "CFB";
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException {
        if (key == null || iv == null || iv.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = iv;
        this.reset();
        this.embeddedCipher.init(false, algorithm, key);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.registerSave == null) {
            this.registerSave = new byte[this.blockSize];
        }
        System.arraycopy(this.register, 0, this.registerSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.registerSave, 0, this.register, 0, this.blockSize);
    }

    @Override
    int encrypt(byte[] plain2, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        ArrayUtil.blockSizeCheck(plainLen, this.numBytes);
        ArrayUtil.nullAndBoundsCheck(plain2, plainOffset, plainLen);
        ArrayUtil.nullAndBoundsCheck(cipher, cipherOffset, plainLen);
        int nShift = this.blockSize - this.numBytes;
        for (int loopCount = plainLen / this.numBytes; loopCount > 0; --loopCount) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            if (nShift != 0) {
                System.arraycopy(this.register, this.numBytes, this.register, 0, nShift);
            }
            for (int i = 0; i < this.numBytes; ++i) {
                byte by = (byte)(this.k[i] ^ plain2[i + plainOffset]);
                cipher[i + cipherOffset] = by;
                this.register[nShift + i] = by;
            }
            plainOffset += this.numBytes;
            cipherOffset += this.numBytes;
        }
        return plainLen;
    }

    @Override
    int encryptFinal(byte[] plain2, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        int oddBytes = plainLen % this.numBytes;
        int len = this.encrypt(plain2, plainOffset, plainLen - oddBytes, cipher, cipherOffset);
        plainOffset += len;
        cipherOffset += len;
        if (oddBytes != 0) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            for (int i = 0; i < oddBytes; ++i) {
                cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain2[i + plainOffset]);
            }
        }
        return plainLen;
    }

    @Override
    int decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain2, int plainOffset) {
        ArrayUtil.blockSizeCheck(cipherLen, this.numBytes);
        ArrayUtil.nullAndBoundsCheck(cipher, cipherOffset, cipherLen);
        ArrayUtil.nullAndBoundsCheck(plain2, plainOffset, cipherLen);
        int nShift = this.blockSize - this.numBytes;
        for (int loopCount = cipherLen / this.numBytes; loopCount > 0; --loopCount) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            if (nShift != 0) {
                System.arraycopy(this.register, this.numBytes, this.register, 0, nShift);
            }
            for (int i = 0; i < this.numBytes; ++i) {
                this.register[i + nShift] = cipher[i + cipherOffset];
                plain2[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
            }
            plainOffset += this.numBytes;
            cipherOffset += this.numBytes;
        }
        return cipherLen;
    }

    @Override
    int decryptFinal(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain2, int plainOffset) {
        int oddBytes = cipherLen % this.numBytes;
        int len = this.decrypt(cipher, cipherOffset, cipherLen - oddBytes, plain2, plainOffset);
        cipherOffset += len;
        plainOffset += len;
        if (oddBytes != 0) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            for (int i = 0; i < oddBytes; ++i) {
                plain2[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
            }
        }
        return cipherLen;
    }
}

