/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import jdk.internal.access.SharedSecrets;

final class ConstructKeys {
    ConstructKeys() {
    }

    private static final PublicKey constructPublicKey(byte[] encodedKey, int ofs, int len, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey key = null;
        byte[] keyBytes = ofs == 0 && encodedKey.length == len ? encodedKey : Arrays.copyOfRange(encodedKey, ofs, ofs + len);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm, SunJCE.getInstance());
            key = keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                key = keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException nsae2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
            }
            catch (InvalidKeySpecException ikse2) {
                InvalidKeyException ike = new InvalidKeyException("Cannot construct public key");
                ike.initCause(ikse2);
                throw ike;
            }
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct public key");
            ike.initCause(ikse);
            throw ike;
        }
        return key;
    }

    private static final PrivateKey constructPrivateKey(byte[] encodedKey, int ofs, int len, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey key = null;
        byte[] keyBytes = ofs == 0 && encodedKey.length == len ? encodedKey : Arrays.copyOfRange(encodedKey, ofs, ofs + len);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm, SunJCE.getInstance());
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                key = keyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException nsae2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
            }
            catch (InvalidKeySpecException ikse2) {
                InvalidKeyException ike = new InvalidKeyException("Cannot construct private key");
                ike.initCause(ikse2);
                throw ike;
            }
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct private key");
            ike.initCause(ikse);
            throw ike;
        }
        finally {
            SharedSecrets.getJavaSecuritySpecAccess().clearEncodedKeySpec(keySpec);
            if (keyBytes != encodedKey) {
                Arrays.fill(keyBytes, (byte)0);
            }
        }
        return key;
    }

    private static final SecretKey constructSecretKey(byte[] encodedKey, int ofs, int len, String encodedKeyAlgorithm) {
        return new SecretKeySpec(encodedKey, ofs, len, encodedKeyAlgorithm);
    }

    static final Key constructKey(byte[] encoding, String keyAlgorithm, int keyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return ConstructKeys.constructKey(encoding, 0, encoding.length, keyAlgorithm, keyType);
    }

    static final Key constructKey(byte[] encoding, int ofs, int len, String keyAlgorithm, int keyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return switch (keyType) {
            case 3 -> ConstructKeys.constructSecretKey(encoding, ofs, len, keyAlgorithm);
            case 2 -> ConstructKeys.constructPrivateKey(encoding, ofs, len, keyAlgorithm);
            case 1 -> ConstructKeys.constructPublicKey(encoding, ofs, len, keyAlgorithm);
            default -> throw new NoSuchAlgorithmException("Unsupported key type");
        };
    }
}

