/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class DESKeyFactory
extends SecretKeyFactorySpi {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESKey dESKey;
        byte[] encoded;
        if (keySpec instanceof DESKeySpec) {
            encoded = ((DESKeySpec)keySpec).getKey();
        } else if (keySpec instanceof SecretKeySpec) {
            encoded = ((SecretKeySpec)keySpec).getEncoded();
        } else {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        try {
            dESKey = new DESKey(encoded);
        }
        catch (Throwable throwable) {
            try {
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
        }
        Arrays.fill(encoded, (byte)0);
        return dESKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        DESKeySpec dESKeySpec;
        if (!(key instanceof SecretKey) || !key.getAlgorithm().equalsIgnoreCase("DES") || !key.getFormat().equalsIgnoreCase("RAW")) throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        if (keySpec == null || !keySpec.isAssignableFrom(DESKeySpec.class)) throw new InvalidKeySpecException("Inappropriate key specification");
        byte[] encoded = key.getEncoded();
        try {
            dESKeySpec = new DESKeySpec(encoded);
            if (encoded == null) return dESKeySpec;
        }
        catch (Throwable throwable) {
            try {
                if (encoded == null) throw throwable;
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Secret key has wrong size");
            }
        }
        Arrays.fill(encoded, (byte)0);
        return dESKeySpec;
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof DESKey) {
                    return key;
                }
                DESKeySpec desKeySpec = (DESKeySpec)this.engineGetKeySpec(key, DESKeySpec.class);
                return this.engineGenerateSecret(desKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

