/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;

public final class DESKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;

    @Override
    protected void engineInit(SecureRandom random) {
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("DES key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (keysize != 56) {
            throw new InvalidParameterException("Wrong keysize: must be equal to 56");
        }
        this.engineInit(random);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        DESKey desKey = null;
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        try {
            byte[] key = new byte[8];
            do {
                this.random.nextBytes(key);
                DESKeyGenerator.setParityBit(key, 0);
            } while (DESKeySpec.isWeak(key, 0));
            desKey = new DESKey(key);
            Arrays.fill(key, (byte)0);
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return desKey;
    }

    static void setParityBit(byte[] key, int offset) {
        if (key == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int b = key[offset] & 0xFE;
            b |= Integer.bitCount(b) & 1 ^ 1;
            key[offset++] = (byte)b;
        }
    }
}

