/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESedeKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class DESedeKeyFactory
extends SecretKeyFactorySpi {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESedeKey dESedeKey;
        byte[] encoded;
        if (keySpec instanceof DESedeKeySpec) {
            encoded = ((DESedeKeySpec)keySpec).getKey();
        } else if (keySpec instanceof SecretKeySpec) {
            encoded = ((SecretKeySpec)keySpec).getEncoded();
        } else {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        try {
            dESedeKey = new DESedeKey(encoded);
        }
        catch (Throwable throwable) {
            try {
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
        }
        Arrays.fill(encoded, (byte)0);
        return dESedeKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        DESedeKeySpec dESedeKeySpec;
        if (!(key instanceof SecretKey) || !key.getAlgorithm().equalsIgnoreCase("DESede") || !key.getFormat().equalsIgnoreCase("RAW")) throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        if (!keySpec.isAssignableFrom(DESedeKeySpec.class)) throw new InvalidKeySpecException("Inappropriate key specification");
        byte[] encoded = key.getEncoded();
        try {
            dESedeKeySpec = new DESedeKeySpec(encoded);
            if (encoded == null) return dESedeKeySpec;
        }
        catch (Throwable throwable) {
            try {
                if (encoded == null) throw throwable;
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Secret key has wrong size");
            }
        }
        Arrays.fill(encoded, (byte)0);
        return dESedeKeySpec;
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof DESedeKey) {
                    return key;
                }
                DESedeKeySpec desEdeKeySpec = (DESedeKeySpec)this.engineGetKeySpec(key, DESedeKeySpec.class);
                return this.engineGenerateSecret(desEdeKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

