/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKeyGenerator;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class DESedeKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keysize = 168;

    @Override
    protected void engineInit(SecureRandom random) {
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Triple DES key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (keysize != 112 && keysize != 168) {
            throw new InvalidParameterException("Wrong keysize: must be equal to 112 or 168");
        }
        this.keysize = keysize;
        this.engineInit(random);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        byte[] rawkey = new byte[24];
        if (this.keysize == 168) {
            this.random.nextBytes(rawkey);
            DESKeyGenerator.setParityBit(rawkey, 0);
            DESKeyGenerator.setParityBit(rawkey, 8);
            DESKeyGenerator.setParityBit(rawkey, 16);
        } else {
            byte[] tmpkey = new byte[16];
            this.random.nextBytes(tmpkey);
            DESKeyGenerator.setParityBit(tmpkey, 0);
            DESKeyGenerator.setParityBit(tmpkey, 8);
            System.arraycopy(tmpkey, 0, rawkey, 0, tmpkey.length);
            System.arraycopy(tmpkey, 0, rawkey, 16, 8);
            Arrays.fill(tmpkey, (byte)0);
        }
        DESedeKey desEdeKey = null;
        try {
            desEdeKey = new DESedeKey(rawkey);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike.getMessage());
        }
        Arrays.fill(rawkey, (byte)0);
        return desEdeKey;
    }
}

