/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.GCMParameterSpec;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.HexDumpEncoder;

public final class GCMParameters
extends AlgorithmParametersSpi {
    private byte[] iv;
    private int tLen;

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof GCMParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        GCMParameterSpec gps = (GCMParameterSpec)paramSpec;
        this.tLen = gps.getTLen() / 8;
        this.iv = gps.getIV();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        int tLen;
        byte[] iv;
        DerValue val = new DerValue(encoded);
        if (val.tag == 48) {
            iv = val.data.getOctetString();
            if (val.data.available() != 0) {
                tLen = val.data.getInteger();
                if (tLen < 12 || tLen > 16) {
                    throw new IOException("GCM parameter parsing error: unsupported tag len: " + tLen);
                }
                if (val.data.available() != 0) {
                    throw new IOException("GCM parameter parsing error: extra data");
                }
            } else {
                tLen = 12;
            }
        } else {
            throw new IOException("GCM parameter parsing error: no SEQ tag");
        }
        this.iv = (byte[])iv.clone();
        this.tLen = tLen;
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (GCMParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new GCMParameterSpec(this.tLen * 8, this.iv)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        bytes.putOctetString(this.iv);
        bytes.putInteger(this.tLen);
        out.write((byte)48, bytes);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String LINE_SEP = System.lineSeparator();
        HexDumpEncoder encoder = new HexDumpEncoder();
        StringBuilder sb = new StringBuilder(LINE_SEP + "    iv:" + LINE_SEP + "[" + encoder.encodeBuffer(this.iv) + "]");
        sb.append(LINE_SEP + "tLen(bits):" + LINE_SEP + this.tLen * 8 + LINE_SEP);
        return sb.toString();
    }
}

