/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SymmetricCipher;
import java.util.Arrays;

class KWUtil {
    static final int BLKSIZE = 16;
    static final int SEMI_BLKSIZE = 8;
    static final int MIN_INPUTLEN = 24;

    KWUtil() {
    }

    static final int W(byte[] icvIn, byte[] in, int inLen, SymmetricCipher cipher) {
        assert (inLen >= 24 && inLen % 8 == 0) : "Invalid data length for W: " + inLen;
        assert (icvIn.length == 8) : "Invalid ICV buffer size";
        System.arraycopy(icvIn, 0, in, 0, 8);
        int n = inLen / 8 - 1;
        byte[] buffer = new byte[16];
        byte[] out = in;
        for (int j = 0; j < 6; ++j) {
            for (int i = 1; i <= n; ++i) {
                int T = i + j * n;
                System.arraycopy(out, 0, buffer, 0, 8);
                System.arraycopy(out, i << 3, buffer, 8, 8);
                cipher.encryptBlock(buffer, 0, buffer, 0);
                int k = 1;
                while (T != 0) {
                    byte v = (byte)T;
                    int n2 = 8 - k;
                    buffer[n2] = (byte)(buffer[n2] ^ v);
                    T >>>= 8;
                    ++k;
                }
                System.arraycopy(buffer, 0, out, 0, 8);
                System.arraycopy(buffer, 8, out, i << 3, 8);
            }
        }
        return inLen;
    }

    static final int W_INV(byte[] in, int inLen, byte[] icvOut, SymmetricCipher cipher) {
        assert (inLen >= 24 && inLen % 8 == 0) : "Invalid data length for W_INV: " + inLen;
        assert (icvOut.length == 8) : "Invalid ICV buffer size";
        byte[] buffer = new byte[16];
        System.arraycopy(in, 0, buffer, 0, 8);
        System.arraycopy(in, 8, in, 0, inLen - 8);
        int n = (inLen - 8) / 8;
        for (int j = 5; j >= 0; --j) {
            for (int i = n; i > 0; --i) {
                int T = i + n * j;
                int idx = i - 1 << 3;
                System.arraycopy(in, idx, buffer, 8, 8);
                int k = 1;
                while (T != 0) {
                    byte v = (byte)T;
                    int n2 = 8 - k;
                    buffer[n2] = (byte)(buffer[n2] ^ v);
                    T >>>= 8;
                    ++k;
                }
                cipher.decryptBlock(buffer, 0, buffer, 0);
                System.arraycopy(buffer, 8, in, idx, 8);
            }
        }
        System.arraycopy(buffer, 0, icvOut, 0, 8);
        Arrays.fill(buffer, (byte)0);
        return inLen - 8;
    }
}

