/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class KeyGeneratorCore {
    private final String name;
    private final int defaultKeySize;
    private int keySize;
    private SecureRandom random;

    KeyGeneratorCore(String name, int defaultKeySize) {
        this.name = name;
        this.defaultKeySize = defaultKeySize;
        this.implInit(null);
    }

    void implInit(SecureRandom random) {
        this.keySize = this.defaultKeySize;
        this.random = random;
    }

    void implInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(this.name + " key generation does not take any parameters");
    }

    void implInit(int keysize, SecureRandom random) {
        if (keysize < 40) {
            throw new InvalidParameterException("Key length must be at least 40 bits");
        }
        this.keySize = keysize;
        this.random = random;
    }

    SecretKey implGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        byte[] b = new byte[this.keySize + 7 >> 3];
        this.random.nextBytes(b);
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(b, this.name);
            return secretKeySpec;
        }
        finally {
            Arrays.fill(b, (byte)0);
        }
    }

    public static final class ChaCha20KeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("ChaCha20", 256);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            if (keySize != 256) {
                throw new InvalidParameterException("Key length for ChaCha20 must be 256 bits");
            }
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class ARCFOURKeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("ARCFOUR", 128);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            if (keySize < 40 || keySize > 1024) {
                throw new InvalidParameterException("Key length for ARCFOUR must be between 40 and 1024 bits");
            }
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class RC2KeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("RC2", 128);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            if (keySize < 40 || keySize > 1024) {
                throw new InvalidParameterException("Key length for RC2 must be between 40 and 1024 bits");
            }
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    static abstract class HmacKG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core;

        protected HmacKG(String algoName, int len) {
            this.core = new KeyGeneratorCore(algoName, len);
        }

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }

        public static final class SHA3_512
        extends HmacKG {
            public SHA3_512() {
                super("HmacSHA3-512", 512);
            }
        }

        public static final class SHA3_384
        extends HmacKG {
            public SHA3_384() {
                super("HmacSHA3-384", 384);
            }
        }

        public static final class SHA3_256
        extends HmacKG {
            public SHA3_256() {
                super("HmacSHA3-256", 256);
            }
        }

        public static final class SHA3_224
        extends HmacKG {
            public SHA3_224() {
                super("HmacSHA3-224", 224);
            }
        }

        public static final class SHA512_256
        extends HmacKG {
            public SHA512_256() {
                super("HmacSHA512/256", 256);
            }
        }

        public static final class SHA512_224
        extends HmacKG {
            public SHA512_224() {
                super("HmacSHA512/224", 224);
            }
        }

        public static final class SHA512
        extends HmacKG {
            public SHA512() {
                super("HmacSHA512", 512);
            }
        }

        public static final class SHA384
        extends HmacKG {
            public SHA384() {
                super("HmacSHA384", 384);
            }
        }

        public static final class SHA256
        extends HmacKG {
            public SHA256() {
                super("HmacSHA256", 256);
            }
        }

        public static final class SHA224
        extends HmacKG {
            public SHA224() {
                super("HmacSHA224", 224);
            }
        }
    }
}

