/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.AESKeyWrap;
import com.sun.crypto.provider.AESKeyWrapPadded;
import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.PKCS5Padding;
import com.sun.crypto.provider.Padding;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

abstract class KeyWrapCipher
extends CipherSpi {
    private final FeedbackCipher cipher;
    private final Padding padding;
    private int opmode = -1;
    private final int fixedKeySize;
    private byte[] dataBuf;
    private int dataIdx;

    private void store(byte[] in, int inOfs, int inLen) {
        int remain = Integer.MAX_VALUE - this.dataIdx;
        if (inLen > remain) {
            throw new ProviderException("SunJCE provider can only take " + remain + " more bytes");
        }
        if (this.dataBuf == null || this.dataBuf.length - this.dataIdx < inLen) {
            int newSize = Math.addExact(this.dataIdx, inLen);
            int lastBlk = (this.dataIdx + inLen - 8) % 16;
            if (lastBlk != 0 || this.padding != null) {
                newSize = Math.addExact(newSize, 16 - lastBlk);
            }
            byte[] temp = new byte[newSize];
            if (this.dataBuf != null && this.dataIdx > 0) {
                System.arraycopy(this.dataBuf, 0, temp, 0, this.dataIdx);
            }
            this.dataBuf = temp;
        }
        if (in != null) {
            System.arraycopy(in, inOfs, this.dataBuf, this.dataIdx, inLen);
            this.dataIdx += inLen;
        }
    }

    public KeyWrapCipher(FeedbackCipher cipher, Padding padding, int keySize) {
        this.cipher = cipher;
        this.padding = padding;
        this.fixedKeySize = keySize;
        this.dataBuf = null;
        this.dataIdx = 0;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !this.cipher.getFeedback().equalsIgnoreCase(mode)) {
            throw new NoSuchAlgorithmException(mode + " cannot be used");
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (this.padding == null && !"NoPadding".equalsIgnoreCase(padding) || this.padding instanceof PKCS5Padding && !"PKCS5Padding".equalsIgnoreCase(padding)) {
            throw new NoSuchPaddingException("Unsupported padding " + padding);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    protected int engineGetOutputSize(int inLen) {
        int result;
        if (this.opmode == 1 || this.opmode == 3) {
            int n;
            result = this.dataIdx > 0 ? Math.addExact(inLen, this.dataIdx - 8) : inLen;
            int padLen = 0;
            if (this.padding != null) {
                padLen = this.padding.padLength(result);
            } else if (this.cipher instanceof AESKeyWrapPadded && (n = result % 8) != 0) {
                padLen = 8 - n;
            }
            result = Math.addExact(result, 8 + padLen);
        } else {
            result = inLen - 8;
            if (this.dataIdx > 0) {
                result = Math.addExact(result, this.dataIdx);
            }
        }
        return result;
    }

    @Override
    protected byte[] engineGetIV() {
        byte[] iv = this.cipher.getIV();
        return iv == null ? null : (byte[])iv.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implInit(int opmode, Key key, byte[] iv, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] keyBytes = key.getEncoded();
        if (keyBytes == null) {
            throw new InvalidKeyException("Null key");
        }
        this.opmode = opmode;
        boolean decrypting = opmode == 2 || opmode == 4;
        try {
            this.cipher.init(decrypting, key.getAlgorithm(), keyBytes, iv);
            this.dataBuf = null;
            this.dataIdx = 0;
        }
        finally {
            Arrays.fill(keyBytes, (byte)0);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.implInit(opmode, key, null, random);
        }
        catch (InvalidAlgorithmParameterException iae) {
            throw new AssertionError((Object)iae);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only IvParameterSpec is accepted");
        }
        byte[] iv = params == null ? null : ((IvParameterSpec)params).getIV();
        this.implInit(opmode, key, iv, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv = null;
        if (params != null) {
            try {
                IvParameterSpec spec = params.getParameterSpec(IvParameterSpec.class);
                iv = spec.getIV();
            }
            catch (InvalidParameterSpecException ispe) {
                throw new InvalidAlgorithmParameterException("Only IvParameterSpec is accepted");
            }
        }
        try {
            this.implInit(opmode, key, iv, random);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidAlgorithmParameterException(iae.getMessage());
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("Cipher not initialized for update");
        }
        this.implUpdate(in, inOffset, inLen);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("Cipher not initialized for update");
        }
        this.implUpdate(in, inOffset, inLen);
        return 0;
    }

    private void implUpdate(byte[] in, int inOfs, int inLen) {
        if (inLen <= 0) {
            return;
        }
        if (this.opmode == 1 && this.dataIdx == 0) {
            this.dataIdx = 8;
        }
        this.store(in, inOfs, inLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray;
        int estOutLen = this.engineGetOutputSize(inLen);
        byte[] out = new byte[estOutLen];
        int outLen = this.engineDoFinal(in, inOfs, inLen, out, 0);
        if (outLen >= estOutLen) return out;
        try {
            byArray = Arrays.copyOf(out, outLen);
        }
        catch (Throwable throwable) {
            try {
                Arrays.fill(out, (byte)0);
                throw throwable;
            }
            catch (ShortBufferException sbe) {
                throw new AssertionError((Object)sbe);
            }
        }
        Arrays.fill(out, (byte)0);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("Cipher not initialized for doFinal");
        }
        int estOutLen = this.engineGetOutputSize(inLen);
        if (out.length - outOfs < estOutLen) {
            throw new ShortBufferException("Need at least " + estOutLen);
        }
        try {
            if (outOfs == 0 && this.opmode == 1) {
                int n = this.implDoFinal(in, inOfs, inLen, out);
                return n;
            }
            this.store(null, 0, inLen);
            int outLen = this.implDoFinal(in, inOfs, inLen, this.dataBuf);
            if (outLen > estOutLen) {
                throw new AssertionError((Object)"Actual output length exceeds estimated length");
            }
            System.arraycopy(this.dataBuf, 0, out, outOfs, outLen);
            int n = outLen;
            return n;
        }
        finally {
            if (this.dataBuf != null) {
                Arrays.fill(this.dataBuf, (byte)0);
            }
            this.dataBuf = null;
            this.dataIdx = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int implDoFinal(byte[] in, int inOfs, int inLen, byte[] out) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int len;
        int n = len = out == this.dataBuf ? this.dataIdx : 0;
        if (out != this.dataBuf && this.dataIdx > 0) {
            System.arraycopy(this.dataBuf, 0, out, 0, this.dataIdx);
            len = this.dataIdx;
        }
        if (this.opmode == 1 && len == 0) {
            len = 8;
        }
        if (inLen > 0) {
            System.arraycopy(in, inOfs, out, len, inLen);
            len += inLen;
        }
        try {
            int n2 = this.opmode == 1 ? this.helperEncrypt(out, len) : this.helperDecrypt(out, len);
            return n2;
        }
        finally {
            if (this.dataBuf != null && this.dataBuf != out) {
                Arrays.fill(this.dataBuf, (byte)0);
            }
        }
    }

    private int helperEncrypt(byte[] inBuf, int inLen) throws IllegalBlockSizeException, ShortBufferException {
        if (this.padding != null) {
            int paddingLen = this.padding.padLength(inLen - 8);
            if (inLen + paddingLen > inBuf.length) {
                throw new AssertionError((Object)"encrypt buffer too small");
            }
            try {
                this.padding.padWithLen(inBuf, inLen, paddingLen);
                inLen += paddingLen;
            }
            catch (ShortBufferException sbe) {
                throw new AssertionError((Object)sbe);
            }
        }
        return this.cipher.encryptFinal(inBuf, 0, inLen, null, 0);
    }

    private int helperDecrypt(byte[] inBuf, int inLen) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int outLen = this.cipher.decryptFinal(inBuf, 0, inLen, null, 0);
        if (this.padding != null) {
            int padIdx = this.padding.unpad(inBuf, 0, outLen);
            if (padIdx <= 0) {
                throw new BadPaddingException("Bad Padding: " + padIdx);
            }
            outLen = padIdx;
        }
        return outLen;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        byte[] iv = this.cipher.getIV();
        if (iv == null) {
            iv = this.cipher instanceof AESKeyWrap ? AESKeyWrap.ICV1 : AESKeyWrapPadded.ICV2;
        }
        try {
            params = AlgorithmParameters.getInstance("AES");
            params.init(new IvParameterSpec(iv));
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new AssertionError();
        }
        return params;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Cannot decide key length");
        }
        Arrays.fill(encoded, (byte)0);
        int keyLen = encoded.length;
        if (!key.getAlgorithm().equalsIgnoreCase("AES") || !AESCrypt.isKeySizeValid(keyLen) || this.fixedKeySize != -1 && this.fixedKeySize != keyLen) {
            throw new InvalidKeyException("Invalid key length: " + keyLen + " bytes");
        }
        return Math.multiplyExact(keyLen, 8);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.opmode != 3) {
            throw new IllegalStateException("Cipher not initialized for wrap");
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
        }
        byte[] out = new byte[this.engineGetOutputSize(encoded.length)];
        int len = 8;
        System.arraycopy(encoded, 0, out, len, encoded.length);
        len += encoded.length;
        Arrays.fill(encoded, (byte)0);
        try {
            int outLen = this.helperEncrypt(out, len);
            if (outLen != out.length) {
                throw new AssertionError((Object)"Wrong output buffer size");
            }
            return out;
        }
        catch (ShortBufferException sbe) {
            throw new AssertionError();
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.opmode != 4) {
            throw new IllegalStateException("Cipher not initialized for unwrap");
        }
        byte[] buf = (byte[])wrappedKey.clone();
        try {
            int outLen = this.helperDecrypt(buf, buf.length);
            Key key = ConstructKeys.constructKey(buf, 0, outLen, wrappedKeyAlgorithm, wrappedKeyType);
            return key;
        }
        catch (ShortBufferException sbe) {
            throw new AssertionError();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException(e);
        }
        finally {
            Arrays.fill(buf, (byte)0);
        }
    }

    public static final class AES256_KWP_NoPadding
    extends KeyWrapCipher {
        public AES256_KWP_NoPadding() {
            super(new AESKeyWrapPadded(), null, 32);
        }
    }

    public static final class AES192_KWP_NoPadding
    extends KeyWrapCipher {
        public AES192_KWP_NoPadding() {
            super(new AESKeyWrapPadded(), null, 24);
        }
    }

    public static final class AES128_KWP_NoPadding
    extends KeyWrapCipher {
        public AES128_KWP_NoPadding() {
            super(new AESKeyWrapPadded(), null, 16);
        }
    }

    public static final class AES_KWP_NoPadding
    extends KeyWrapCipher {
        public AES_KWP_NoPadding() {
            super(new AESKeyWrapPadded(), null, -1);
        }
    }

    public static final class AES256_KW_PKCS5Padding
    extends KeyWrapCipher {
        public AES256_KW_PKCS5Padding() {
            super(new AESKeyWrap(), new PKCS5Padding(16), 32);
        }
    }

    public static final class AES192_KW_PKCS5Padding
    extends KeyWrapCipher {
        public AES192_KW_PKCS5Padding() {
            super(new AESKeyWrap(), new PKCS5Padding(16), 24);
        }
    }

    public static final class AES128_KW_PKCS5Padding
    extends KeyWrapCipher {
        public AES128_KW_PKCS5Padding() {
            super(new AESKeyWrap(), new PKCS5Padding(16), 16);
        }
    }

    public static final class AES_KW_PKCS5Padding
    extends KeyWrapCipher {
        public AES_KW_PKCS5Padding() {
            super(new AESKeyWrap(), new PKCS5Padding(16), -1);
        }
    }

    public static final class AES256_KW_NoPadding
    extends KeyWrapCipher {
        public AES256_KW_NoPadding() {
            super(new AESKeyWrap(), null, 32);
        }
    }

    public static final class AES192_KW_NoPadding
    extends KeyWrapCipher {
        public AES192_KW_NoPadding() {
            super(new AESKeyWrap(), null, 24);
        }
    }

    public static final class AES128_KW_NoPadding
    extends KeyWrapCipher {
        public AES128_KW_NoPadding() {
            super(new AESKeyWrap(), null, 16);
        }
    }

    public static final class AES_KW_NoPadding
    extends KeyWrapCipher {
        public AES_KW_NoPadding() {
            super(new AESKeyWrap(), null, -1);
        }
    }
}

