/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBKDF2KeyImpl;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

abstract class PBKDF2Core
extends SecretKeyFactorySpi {
    private final String prfAlgo;

    PBKDF2Core(String prfAlgo) {
        this.prfAlgo = prfAlgo;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        PBEKeySpec ks = (PBEKeySpec)keySpec;
        return new PBKDF2KeyImpl(ks, this.prfAlgo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpecCl) throws InvalidKeySpecException {
        if (key instanceof PBEKey) {
            if (keySpecCl != null && PBEKeySpec.class.isAssignableFrom(keySpecCl)) {
                PBEKey pKey = (PBEKey)key;
                char[] passwd = pKey.getPassword();
                byte[] encoded = pKey.getEncoded();
                try {
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(passwd, pKey.getSalt(), pKey.getIterationCount(), encoded.length * 8);
                    return pBEKeySpec;
                }
                finally {
                    if (passwd != null) {
                        Arrays.fill(passwd, '\u0000');
                    }
                    Arrays.fill(encoded, (byte)0);
                }
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key != null && key.getAlgorithm().equalsIgnoreCase("PBKDF2With" + this.prfAlgo) && key.getFormat().equalsIgnoreCase("RAW")) {
            if (key instanceof PBKDF2KeyImpl) {
                return key;
            }
            if (key instanceof PBEKey) {
                PBEKey pKey = (PBEKey)key;
                char[] password = pKey.getPassword();
                byte[] encoding = pKey.getEncoded();
                PBEKeySpec spec = new PBEKeySpec(password, pKey.getSalt(), pKey.getIterationCount(), encoding.length * 8);
                try {
                    PBKDF2KeyImpl pBKDF2KeyImpl = new PBKDF2KeyImpl(spec, this.prfAlgo);
                    return pBKDF2KeyImpl;
                }
                catch (InvalidKeySpecException re) {
                    InvalidKeyException ike = new InvalidKeyException("Invalid key component(s)");
                    ike.initCause(re);
                    throw ike;
                }
                finally {
                    if (password != null) {
                        Arrays.fill(password, '\u0000');
                        spec.clearPassword();
                    }
                    Arrays.fill(encoding, (byte)0);
                }
            }
        }
        throw new InvalidKeyException("Invalid key format/algorithm");
    }

    public static final class HmacSHA512
    extends PBKDF2Core {
        public HmacSHA512() {
            super("HmacSHA512");
        }
    }

    public static final class HmacSHA384
    extends PBKDF2Core {
        public HmacSHA384() {
            super("HmacSHA384");
        }
    }

    public static final class HmacSHA256
    extends PBKDF2Core {
        public HmacSHA256() {
            super("HmacSHA256");
        }
    }

    public static final class HmacSHA224
    extends PBKDF2Core {
        public HmacSHA224() {
            super("HmacSHA224");
        }
    }

    public static final class HmacSHA1
    extends PBKDF2Core {
        public HmacSHA1() {
            super("HmacSHA1");
        }
    }
}

