/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBKDF2KeyImpl;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

public final class PBKDF2HmacSHA1Factory
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        PBEKeySpec ks = (PBEKeySpec)keySpec;
        return new PBKDF2KeyImpl(ks, "HmacSHA1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpecCl) throws InvalidKeySpecException {
        if (key instanceof PBEKey) {
            if (keySpecCl != null && PBEKeySpec.class.isAssignableFrom(keySpecCl)) {
                PBEKey pKey = (PBEKey)key;
                char[] passwd = pKey.getPassword();
                byte[] encoded = pKey.getEncoded();
                try {
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(passwd, pKey.getSalt(), pKey.getIterationCount(), encoded.length * 8);
                    return pBEKeySpec;
                }
                finally {
                    if (passwd != null) {
                        Arrays.fill(passwd, '\u0000');
                    }
                    Arrays.fill(encoded, (byte)0);
                }
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key != null && key.getAlgorithm().equalsIgnoreCase("PBKDF2WithHmacSHA1") && key.getFormat().equalsIgnoreCase("RAW")) {
            if (key instanceof PBKDF2KeyImpl) {
                return key;
            }
            if (key instanceof PBEKey) {
                PBEKey pKey = (PBEKey)key;
                char[] password = pKey.getPassword();
                byte[] encoding = pKey.getEncoded();
                PBEKeySpec spec = new PBEKeySpec(password, pKey.getSalt(), pKey.getIterationCount(), encoding.length * 8);
                try {
                    PBKDF2KeyImpl pBKDF2KeyImpl = new PBKDF2KeyImpl(spec, "HmacSHA1");
                    return pBKDF2KeyImpl;
                }
                catch (InvalidKeySpecException re) {
                    InvalidKeyException ike = new InvalidKeyException("Invalid key component(s)");
                    ike.initCause(re);
                    throw ike;
                }
                finally {
                    if (password != null) {
                        Arrays.fill(password, '\u0000');
                        spec.clearPassword();
                    }
                    Arrays.fill(encoding, (byte)0);
                }
            }
        }
        throw new InvalidKeyException("Invalid key format/algorithm");
    }
}

