/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SealedObject;
import jdk.internal.access.SharedSecrets;

final class SealedObjectForKeyProtector
extends SealedObject {
    static final long serialVersionUID = -3650226485480866989L;
    private static final String KEY_SERIAL_FILTER = "jceks.key.serialFilter";

    SealedObjectForKeyProtector(Serializable object2, Cipher c) throws IOException, IllegalBlockSizeException {
        super(object2, c);
    }

    SealedObjectForKeyProtector(SealedObject so) {
        super(so);
    }

    AlgorithmParameters getParameters() {
        AlgorithmParameters params = null;
        if (this.encodedParams != null) {
            try {
                params = AlgorithmParameters.getInstance("PBE", SunJCE.getInstance());
                params.init(this.encodedParams);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("SunJCE provider is not configured properly");
            }
            catch (IOException io) {
                throw new RuntimeException("Parameter failure: " + io.getMessage());
            }
        }
        return params;
    }

    final Key getKey(Cipher c, int maxLength) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        try (ObjectInputStream ois = SharedSecrets.getJavaxCryptoSealedObjectAccess().getExtObjectInputStream(this, c);){
            AccessController.doPrivileged(() -> {
                ois.setObjectInputFilter(new DeserializationChecker(maxLength));
                return null;
            });
            try {
                Key t;
                Key key = t = (Key)ois.readObject();
                return key;
            }
            catch (InvalidClassException ice) {
                String msg = ice.getMessage();
                if (msg.contains("REJECTED")) {
                    throw new IOException("Rejected by the jceks.key.serialFilter or jdk.serialFilter property", ice);
                }
                throw ice;
            }
        }
    }

    private static class DeserializationChecker
    implements ObjectInputFilter {
        private static final ObjectInputFilter OWN_FILTER;
        private final int maxLength;

        private DeserializationChecker(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo info) {
            ObjectInputFilter.Status result;
            if (info.arrayLength() > (long)this.maxLength) {
                return ObjectInputFilter.Status.REJECTED;
            }
            if (info.serialClass() == Object.class) {
                return ObjectInputFilter.Status.UNDECIDED;
            }
            if (OWN_FILTER != null && (result = OWN_FILTER.checkInput(info)) != ObjectInputFilter.Status.UNDECIDED) {
                return result;
            }
            ObjectInputFilter defaultFilter = ObjectInputFilter.Config.getSerialFilter();
            if (defaultFilter != null) {
                return defaultFilter.checkInput(info);
            }
            return ObjectInputFilter.Status.UNDECIDED;
        }

        static {
            String prop = AccessController.doPrivileged(() -> {
                String tmp = System.getProperty(SealedObjectForKeyProtector.KEY_SERIAL_FILTER);
                if (tmp != null) {
                    return tmp;
                }
                return Security.getProperty(SealedObjectForKeyProtector.KEY_SERIAL_FILTER);
            });
            OWN_FILTER = prop == null ? null : ObjectInputFilter.Config.createFilter(prop);
        }
    }
}

