/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;

public final class TlsRsaPremasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsRsaPremasterSecretGenerator must be initialized using a TlsRsaPremasterSecretParameterSpec";
    private TlsRsaPremasterSecretParameterSpec spec;
    private SecureRandom random;

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsRsaPremasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsRsaPremasterSecretParameterSpec)params;
        this.random = random;
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsRsaPremasterSecretGenerator must be initialized");
        }
        byte[] b = this.spec.getEncodedSecret();
        if (b == null) {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            b = new byte[48];
            this.random.nextBytes(b);
        }
        b[0] = (byte)this.spec.getMajorVersion();
        b[1] = (byte)this.spec.getMinorVersion();
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(b, "TlsRsaPremasterSecret");
            return secretKeySpec;
        }
        finally {
            Arrays.fill(b, (byte)0);
        }
    }
}

