/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Formatter;
import jdk.internal.access.JavaIOAccess;
import jdk.internal.access.SharedSecrets;
import sun.nio.cs.StreamDecoder;
import sun.nio.cs.StreamEncoder;
import sun.security.action.GetPropertyAction;

public final class Console
implements Flushable {
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private Reader reader;
    private Writer out = StreamEncoder.forOutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), this.writeLock, CHARSET);
    private PrintWriter pw = new PrintWriter(this.out, true){

        @Override
        public void close() {
        }
    };
    private Formatter formatter = new Formatter(this.out);
    private char[] rcb;
    private boolean restoreEcho;
    private boolean shutdownHookInstalled;
    private static final Charset CHARSET;
    private static Console cons;

    public PrintWriter writer() {
        return this.pw;
    }

    public Reader reader() {
        return this.reader;
    }

    public Console format(String fmt, Object ... args) {
        this.formatter.format(fmt, args).flush();
        return this;
    }

    public Console printf(String format, Object ... args) {
        return this.format(format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String fmt, Object ... args) {
        String line = null;
        Object object2 = this.writeLock;
        synchronized (object2) {
            Object object3 = this.readLock;
            synchronized (object3) {
                if (!fmt.isEmpty()) {
                    this.pw.format(fmt, args);
                }
                try {
                    char[] ca = this.readline(false);
                    if (ca != null) {
                        line = new String(ca);
                    }
                }
                catch (IOException x) {
                    throw new IOError(x);
                }
            }
        }
        return line;
    }

    public String readLine() {
        return this.readLine("", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] readPassword(String fmt, Object ... args) {
        char[] passwd = null;
        Object object2 = this.writeLock;
        synchronized (object2) {
            Object object3 = this.readLock;
            synchronized (object3) {
                block22: {
                    this.installShutdownHook();
                    try {
                        this.restoreEcho = Console.echo(false);
                    }
                    catch (IOException x) {
                        throw new IOError(x);
                    }
                    IOError ioe = null;
                    try {
                        if (!fmt.isEmpty()) {
                            this.pw.format(fmt, args);
                        }
                        passwd = this.readline(true);
                    }
                    catch (IOException x) {
                        ioe = new IOError(x);
                        return ioe;
                    }
                    finally {
                        try {
                            if (this.restoreEcho) {
                                this.restoreEcho = Console.echo(true);
                            }
                        }
                        catch (IOException x) {
                            if (ioe == null) {
                                ioe = new IOError(x);
                            }
                            ioe.addSuppressed(x);
                        }
                        if (ioe == null) break block22;
                        throw ioe;
                    }
                }
                this.pw.println();
            }
        }
        return passwd;
    }

    private void installShutdownHook() {
        if (this.shutdownHookInstalled) {
            return;
        }
        try {
            SharedSecrets.getJavaLangAccess().registerShutdownHook(0, false, new Runnable(){

                @Override
                public void run() {
                    try {
                        if (Console.this.restoreEcho) {
                            Console.echo(true);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.shutdownHookInstalled = true;
    }

    public char[] readPassword() {
        return this.readPassword("", new Object[0]);
    }

    @Override
    public void flush() {
        this.pw.flush();
    }

    public Charset charset() {
        assert (CHARSET != null) : "charset() should not return null";
        return CHARSET;
    }

    private static native String encoding();

    private static native boolean echo(boolean var0) throws IOException;

    private char[] readline(boolean zeroOut) throws IOException {
        int len = this.reader.read(this.rcb, 0, this.rcb.length);
        if (len < 0) {
            return null;
        }
        if (this.rcb[len - 1] == '\r') {
            --len;
        } else if (this.rcb[len - 1] == '\n' && --len > 0 && this.rcb[len - 1] == '\r') {
            --len;
        }
        char[] b = new char[len];
        if (len > 0) {
            System.arraycopy(this.rcb, 0, b, 0, len);
            if (zeroOut) {
                Arrays.fill(this.rcb, 0, len, ' ');
            }
        }
        return b;
    }

    private char[] grow() {
        assert (Thread.holdsLock(this.readLock));
        char[] t = new char[this.rcb.length * 2];
        System.arraycopy(this.rcb, 0, t, 0, this.rcb.length);
        this.rcb = t;
        return this.rcb;
    }

    private static native boolean istty();

    private Console() {
        this.reader = new LineReader(StreamDecoder.forInputStreamReader((InputStream)new FileInputStream(FileDescriptor.in), this.readLock, CHARSET));
        this.rcb = new char[1024];
    }

    static {
        String csname = Console.encoding();
        Charset cs = null;
        if (csname == null) {
            csname = GetPropertyAction.privilegedGetProperty("sun.stdout.encoding");
        }
        if (csname != null) {
            try {
                cs = Charset.forName(csname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CHARSET = cs == null ? Charset.defaultCharset() : cs;
        SharedSecrets.setJavaIOAccess(new JavaIOAccess(){

            @Override
            public Console console() {
                if (Console.istty()) {
                    if (cons == null) {
                        cons = new Console();
                    }
                    return cons;
                }
                return null;
            }

            @Override
            public Charset charset() {
                return CHARSET;
            }
        });
    }

    class LineReader
    extends Reader {
        private Reader in;
        private char[] cb;
        private int nChars;
        private int nextChar;
        boolean leftoverLF;

        LineReader(Reader in) {
            this.in = in;
            this.cb = new char[1024];
            this.nChars = 0;
            this.nextChar = 0;
            this.leftoverLF = false;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean ready() throws IOException {
            return this.in.ready();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            int off = offset;
            int end = offset + length;
            if (offset < 0 || offset > cbuf.length || length < 0 || end < 0 || end > cbuf.length) {
                throw new IndexOutOfBoundsException();
            }
            Object object2 = Console.this.readLock;
            synchronized (object2) {
                boolean eof = false;
                char c = '\u0000';
                do {
                    if (this.nextChar >= this.nChars) {
                        int n = 0;
                        while ((n = this.in.read(this.cb, 0, this.cb.length)) == 0) {
                        }
                        if (n > 0) {
                            this.nChars = n;
                            this.nextChar = 0;
                            if (n < this.cb.length && this.cb[n - 1] != '\n' && this.cb[n - 1] != '\r') {
                                eof = true;
                            }
                        } else {
                            if (off - offset == 0) {
                                return -1;
                            }
                            return off - offset;
                        }
                    }
                    if (this.leftoverLF && cbuf == Console.this.rcb && this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.leftoverLF = false;
                    while (this.nextChar < this.nChars) {
                        int n = off++;
                        char c2 = this.cb[this.nextChar];
                        cbuf[n] = c2;
                        c = c2;
                        this.cb[this.nextChar++] = '\u0000';
                        if (c == '\n') {
                            return off - offset;
                        }
                        if (c == '\r') {
                            if (off == end) {
                                if (cbuf == Console.this.rcb) {
                                    cbuf = Console.this.grow();
                                    end = cbuf.length;
                                } else {
                                    this.leftoverLF = true;
                                    return off - offset;
                                }
                            }
                            if (this.nextChar == this.nChars && this.in.ready()) {
                                this.nChars = this.in.read(this.cb, 0, this.cb.length);
                                this.nextChar = 0;
                            }
                            if (this.nextChar < this.nChars && this.cb[this.nextChar] == '\n') {
                                cbuf[off++] = 10;
                                ++this.nextChar;
                            }
                            return off - offset;
                        }
                        if (off != end) continue;
                        if (cbuf == Console.this.rcb) {
                            cbuf = Console.this.grow();
                            end = cbuf.length;
                            continue;
                        }
                        return off - offset;
                    }
                } while (!eof);
                return off - offset;
            }
        }
    }
}

