/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;
    private byte[] bytearr = null;
    private final byte[] writeBuffer = new byte[8];

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    private void incCount(int value) {
        int temp = this.written + value;
        if (temp < 0) {
            temp = Integer.MAX_VALUE;
        }
        this.written = temp;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        this.incCount(1);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 8);
        this.writeBuffer[1] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 2);
        this.incCount(2);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 8);
        this.writeBuffer[1] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 2);
        this.incCount(2);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 24);
        this.writeBuffer[1] = (byte)(v >>> 16);
        this.writeBuffer[2] = (byte)(v >>> 8);
        this.writeBuffer[3] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 4);
        this.incCount(4);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 8);
        this.incCount(8);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.out.write((byte)s.charAt(i));
        }
        this.incCount(len);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeBuffer[0] = (byte)(v >>> 8);
            this.writeBuffer[1] = (byte)(v >>> 0);
            this.out.write(this.writeBuffer, 0, 2);
        }
        this.incCount(len * 2);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        DataOutputStream.writeUTF(str, this);
    }

    static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        byte[] bytearr;
        int strlen;
        int utflen = strlen = str.length();
        for (int i = 0; i < strlen; ++i) {
            char c2 = str.charAt(i);
            if (c2 < '\u0080' && c2 != '\u0000') continue;
            utflen += c2 >= '\u0800' ? 2 : 1;
        }
        if (utflen > 65535 || utflen < strlen) {
            throw new UTFDataFormatException(DataOutputStream.tooLongMsg(str, utflen));
        }
        if (out instanceof DataOutputStream) {
            DataOutputStream dos = (DataOutputStream)out;
            if (dos.bytearr == null || dos.bytearr.length < utflen + 2) {
                dos.bytearr = new byte[utflen * 2 + 2];
            }
            bytearr = dos.bytearr;
        } else {
            bytearr = new byte[utflen + 2];
        }
        int count = 0;
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) < '\u0080' && c != '\u0000'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c < '\u0080' && c != '\u0000') {
                bytearr[count++] = (byte)c;
            } else if (c >= '\u0800') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen + 2);
        return utflen + 2;
    }

    private static String tooLongMsg(String s, int bits32) {
        int slen = s.length();
        String head = s.substring(0, 8);
        String tail = s.substring(slen - 8, slen);
        long actualLength = (long)slen + Integer.toUnsignedLong(bits32 - slen);
        return "encoded string (" + head + "..." + tail + ") too long: " + actualLength + " bytes";
    }

    public final int size() {
        return this.written;
    }
}

