/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DefaultFileSystem;
import java.io.DeleteOnExitHook;
import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import jdk.internal.misc.Unsafe;
import sun.security.action.GetPropertyAction;

public class File
implements Serializable,
Comparable<File> {
    private static final FileSystem fs = DefaultFileSystem.getFileSystem();
    private final String path;
    private transient PathStatus status = null;
    private final transient int prefixLength;
    public static final char separatorChar = fs.getSeparator();
    public static final String separator = "" + separatorChar;
    public static final char pathSeparatorChar = fs.getPathSeparator();
    public static final String pathSeparator = "" + pathSeparatorChar;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long PATH_OFFSET = UNSAFE.objectFieldOffset(File.class, "path");
    private static final long PREFIX_LENGTH_OFFSET = UNSAFE.objectFieldOffset(File.class, "prefixLength");
    private static final long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;

    final boolean isInvalid() {
        PathStatus s = this.status;
        if (s == null) {
            this.status = s = this.path.indexOf(0) < 0 ? PathStatus.CHECKED : PathStatus.INVALID;
        }
        return s == PathStatus.INVALID;
    }

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String pathname, int prefixLength) {
        this.path = pathname;
        this.prefixLength = prefixLength;
    }

    private File(String child, File parent) {
        assert (parent.path != null);
        assert (!parent.path.isEmpty());
        this.path = fs.resolve(parent.path, child);
        this.prefixLength = parent.prefixLength;
    }

    public File(String pathname) {
        if (pathname == null) {
            throw new NullPointerException();
        }
        this.path = fs.normalize(pathname);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(String parent, String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.path = parent != null ? (parent.isEmpty() ? fs.resolve(fs.getDefaultParent(), fs.normalize(child)) : fs.resolve(fs.normalize(parent), fs.normalize(child))) : fs.normalize(child);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(File parent, String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.path = parent != null ? (parent.path.isEmpty() ? fs.resolve(fs.getDefaultParent(), fs.normalize(child)) : fs.resolve(parent.path, fs.normalize(child))) : fs.normalize(child);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String p = uri.getPath();
        if (p.isEmpty()) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        p = fs.fromURIPath(p);
        if (separatorChar != '/') {
            p = p.replace('/', separatorChar);
        }
        this.path = fs.normalize(p);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName() {
        int index = this.path.lastIndexOf(separatorChar);
        if (index < this.prefixLength) {
            return this.path.substring(this.prefixLength);
        }
        return this.path.substring(index + 1);
    }

    public String getParent() {
        int index = this.path.lastIndexOf(separatorChar);
        if (index < this.prefixLength) {
            if (this.prefixLength > 0 && this.path.length() > this.prefixLength) {
                return this.path.substring(0, this.prefixLength);
            }
            return null;
        }
        return this.path.substring(0, index);
    }

    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        if (this.getClass() != File.class) {
            p = fs.normalize(p);
        }
        return new File(p, this.prefixLength);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return fs.isAbsolute(this);
    }

    public String getAbsolutePath() {
        return fs.resolve(this);
    }

    public File getAbsoluteFile() {
        String absPath = this.getAbsolutePath();
        if (this.getClass() != File.class) {
            absPath = fs.normalize(absPath);
        }
        return new File(absPath, fs.prefixLength(absPath));
    }

    public String getCanonicalPath() throws IOException {
        if (this.isInvalid()) {
            throw new IOException("Invalid file path");
        }
        return fs.canonicalize(fs.resolve(this));
    }

    public File getCanonicalFile() throws IOException {
        String canonPath = this.getCanonicalPath();
        if (this.getClass() != File.class) {
            canonPath = fs.normalize(canonPath);
        }
        return new File(canonPath, fs.prefixLength(canonPath));
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (separatorChar != '/') {
            p = p.replace(separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }

    @Deprecated
    public URL toURL() throws MalformedURLException {
        if (this.isInvalid()) {
            throw new MalformedURLException("Invalid file path");
        }
        return new URL("file", "", File.slashify(this.getAbsolutePath(), this.isDirectory()));
    }

    public URI toURI() {
        try {
            File f = this.getAbsoluteFile();
            String sp = File.slashify(f.getPath(), f.isDirectory());
            if (sp.startsWith("//")) {
                sp = "//" + sp;
            }
            return new URI("file", null, sp, null);
        }
        catch (URISyntaxException x) {
            throw new Error(x);
        }
    }

    public boolean canRead() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 4);
    }

    public boolean canWrite() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 2);
    }

    public boolean exists() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.hasBooleanAttributes(this, 1);
    }

    public boolean isDirectory() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.hasBooleanAttributes(this, 4);
    }

    public boolean isFile() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.hasBooleanAttributes(this, 2);
    }

    public boolean isHidden() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.hasBooleanAttributes(this, 8);
    }

    public long lastModified() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getLastModifiedTime(this);
    }

    public long length() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getLength(this);
    }

    public boolean createNewFile() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            throw new IOException("Invalid file path");
        }
        return fs.createFileExclusively(this.path);
    }

    public boolean delete() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkDelete(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.delete(this);
    }

    public void deleteOnExit() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkDelete(this.path);
        }
        if (this.isInvalid()) {
            return;
        }
        DeleteOnExitHook.add(this.path);
    }

    public String[] list() {
        return this.normalizedList();
    }

    private final String[] normalizedList() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return null;
        }
        String[] s = fs.list(this);
        if (s != null && this.getClass() != File.class) {
            String[] normalized = new String[s.length];
            for (int i = 0; i < s.length; ++i) {
                normalized[i] = fs.normalize(s[i]);
            }
            s = normalized;
        }
        return s;
    }

    public String[] list(FilenameFilter filter) {
        String[] names = this.normalizedList();
        if (names == null || filter == null) {
            return names;
        }
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (!filter.accept(this, names[i])) continue;
            v.add(names[i]);
        }
        return v.toArray(new String[v.size()]);
    }

    public File[] listFiles() {
        String[] ss = this.normalizedList();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        File[] fs = new File[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new File(ss[i], this);
        }
        return fs;
    }

    public File[] listFiles(FilenameFilter filter) {
        String[] ss = this.normalizedList();
        if (ss == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String s : ss) {
            if (filter != null && !filter.accept(this, s)) continue;
            files.add(new File(s, this));
        }
        return files.toArray(new File[files.size()]);
    }

    public File[] listFiles(FileFilter filter) {
        String[] ss = this.normalizedList();
        if (ss == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String s : ss) {
            File f = new File(s, this);
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    public boolean mkdir() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.createDirectory(this);
    }

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        File canonFile = null;
        try {
            canonFile = this.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parent = canonFile.getParentFile();
        return parent != null && (parent.mkdirs() || parent.exists()) && canonFile.mkdir();
    }

    public boolean renameTo(File dest) {
        if (dest == null) {
            throw new NullPointerException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
            security.checkWrite(dest.path);
        }
        if (this.isInvalid() || dest.isInvalid()) {
            return false;
        }
        return fs.rename(this, dest);
    }

    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setLastModifiedTime(this, time);
    }

    public boolean setReadOnly() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setReadOnly(this);
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 2, writable, ownerOnly);
    }

    public boolean setWritable(boolean writable) {
        return this.setWritable(writable, true);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 4, readable, ownerOnly);
    }

    public boolean setReadable(boolean readable) {
        return this.setReadable(readable, true);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 1, executable, ownerOnly);
    }

    public boolean setExecutable(boolean executable) {
        return this.setExecutable(executable, true);
    }

    public boolean canExecute() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkExec(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 1);
    }

    public static File[] listRoots() {
        return fs.listRoots();
    }

    public long getTotalSpace() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            sm.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        long space = fs.getSpace(this, 0);
        return space >= 0L ? space : Long.MAX_VALUE;
    }

    public long getFreeSpace() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            sm.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        long space = fs.getSpace(this, 1);
        return space >= 0L ? space : Long.MAX_VALUE;
    }

    public long getUsableSpace() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            sm.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        long space = fs.getSpace(this, 2);
        return space >= 0L ? space : Long.MAX_VALUE;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File f;
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string \"" + prefix + "\" too short: length must be at least 3");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        File tmpdir = directory != null ? directory : TempDirectory.location();
        SecurityManager sm = System.getSecurityManager();
        do {
            f = TempDirectory.generateFile(prefix, suffix, tmpdir);
            if (sm == null) continue;
            try {
                sm.checkWrite(f.getPath());
            }
            catch (SecurityException se) {
                if (directory == null) {
                    throw new SecurityException("Unable to create temporary file");
                }
                throw se;
            }
        } while (fs.hasBooleanAttributes(f, 1));
        if (!fs.createFileExclusively(f.getPath())) {
            throw new IOException("Unable to create temporary file");
        }
        return f;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    @Override
    public int compareTo(File pathname) {
        return fs.compare(this, pathname);
    }

    public boolean equals(Object obj) {
        if (obj instanceof File) {
            File file = (File)obj;
            return this.compareTo(file) == 0;
        }
        return false;
    }

    public int hashCode() {
        return fs.hashCode(this);
    }

    public String toString() {
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        String pathField = (String)fields.get("path", null);
        char sep = s.readChar();
        if (sep != separatorChar) {
            pathField = pathField.replace(sep, separatorChar);
        }
        String path = fs.normalize(pathField);
        UNSAFE.putReference(this, PATH_OFFSET, path);
        UNSAFE.putIntVolatile(this, PREFIX_LENGTH_OFFSET, fs.prefixLength(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path toPath() {
        Path result = this.filePath;
        if (result == null) {
            File file = this;
            synchronized (file) {
                result = this.filePath;
                if (result == null) {
                    this.filePath = result = FileSystems.getDefault().getPath(this.path, new String[0]);
                }
            }
        }
        return result;
    }

    private static enum PathStatus {
        INVALID,
        CHECKED;

    }

    private static class TempDirectory {
        private static final File tmpdir = new File(GetPropertyAction.privilegedGetProperty("java.io.tmpdir"));
        private static final SecureRandom random = new SecureRandom();

        private TempDirectory() {
        }

        static File location() {
            return tmpdir;
        }

        private static int shortenSubName(int subNameLength, int excess, int nameMin) {
            int newLength = Math.max(nameMin, subNameLength - excess);
            if (newLength < subNameLength) {
                return newLength;
            }
            return subNameLength;
        }

        static File generateFile(String prefix, String suffix, File dir) throws IOException {
            String name;
            int nameMax;
            int suffixLength;
            int nusLength;
            long n = random.nextLong();
            String nus = Long.toUnsignedString(n);
            int prefixLength = (prefix = new File(prefix).getName()).length();
            int excess = prefixLength + (nusLength = nus.length()) + (suffixLength = suffix.length()) - (nameMax = fs.getNameMax(dir.getPath()));
            if (excess <= 0) {
                name = prefix + nus + suffix;
            } else {
                if ((excess = (prefixLength = TempDirectory.shortenSubName(prefixLength, excess, 3)) + nusLength + suffixLength - nameMax) > 0) {
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, suffix.indexOf(".") == 0 ? 4 : 0);
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, 3);
                    excess = prefixLength + nusLength + suffixLength - nameMax;
                }
                if (excess > 0 && excess <= nusLength - 5) {
                    nusLength = TempDirectory.shortenSubName(nusLength, excess, 5);
                }
                StringBuilder sb = new StringBuilder(prefixLength + nusLength + suffixLength);
                sb.append(prefixLength < prefix.length() ? prefix.substring(0, prefixLength) : prefix);
                sb.append(nusLength < nus.length() ? nus.substring(0, nusLength) : nus);
                sb.append(suffixLength < suffix.length() ? suffix.substring(0, suffixLength) : suffix);
                name = sb.toString();
            }
            name = fs.normalize(name);
            File f = new File(dir, name);
            if (!name.equals(f.getName()) || f.isInvalid()) {
                if (System.getSecurityManager() != null) {
                    throw new IOException("Unable to create temporary file");
                }
                throw new IOException("Unable to create temporary file, " + name);
            }
            return f;
        }
    }
}

