/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.FileCleanable;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.internal.access.JavaIOFileDescriptorAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.ref.PhantomCleanable;

public final class FileDescriptor {
    private int fd;
    private long handle;
    private Closeable parent;
    private List<Closeable> otherParents;
    private boolean closed;
    private boolean append;
    private PhantomCleanable<FileDescriptor> cleanup;
    public static final FileDescriptor in;
    public static final FileDescriptor out;
    public static final FileDescriptor err;

    public FileDescriptor() {
        this.fd = -1;
        this.handle = -1L;
    }

    private FileDescriptor(int fd) {
        this.fd = fd;
        this.handle = FileDescriptor.getHandle(fd);
        this.append = FileDescriptor.getAppend(fd);
    }

    public boolean valid() {
        return this.handle != -1L || this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    private static native long getHandle(int var0);

    private static native boolean getAppend(int var0);

    synchronized void set(int fd) {
        if (fd == -1 && this.cleanup != null) {
            this.cleanup.clear();
            this.cleanup = null;
        }
        this.fd = fd;
    }

    void setHandle(long handle) {
        if (handle == -1L && this.cleanup != null) {
            this.cleanup.clear();
            this.cleanup = null;
        }
        this.handle = handle;
    }

    synchronized void registerCleanup(PhantomCleanable<FileDescriptor> cleanable) {
        Objects.requireNonNull(cleanable, "cleanable");
        if (this.cleanup != null) {
            this.cleanup.clear();
        }
        this.cleanup = cleanable;
    }

    synchronized void unregisterCleanup() {
        if (this.cleanup != null) {
            this.cleanup.clear();
        }
        this.cleanup = null;
    }

    synchronized void close() throws IOException {
        this.unregisterCleanup();
        this.close0();
    }

    private native void close0() throws IOException;

    synchronized void attach(Closeable c) {
        if (this.parent == null) {
            this.parent = c;
        } else if (this.otherParents == null) {
            this.otherParents = new ArrayList<Closeable>();
            this.otherParents.add(this.parent);
            this.otherParents.add(c);
        } else {
            this.otherParents.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeAll(Closeable releaser) throws IOException {
        block18: {
            if (!this.closed) {
                this.closed = true;
                IOException ioe = null;
                try (Closeable closeable = releaser;){
                    if (this.otherParents != null) {
                        for (Closeable referent : this.otherParents) {
                            try {
                                referent.close();
                            }
                            catch (IOException x) {
                                if (ioe == null) {
                                    ioe = x;
                                    continue;
                                }
                                ioe.addSuppressed(x);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    if (ioe != null) {
                        ex.addSuppressed(ioe);
                    }
                    ioe = ex;
                }
                finally {
                    if (ioe == null) break block18;
                    throw ioe;
                }
            }
        }
    }

    static {
        FileDescriptor.initIDs();
        SharedSecrets.setJavaIOFileDescriptorAccess(new JavaIOFileDescriptorAccess(){

            @Override
            public void set(FileDescriptor fdo, int fd) {
                fdo.set(fd);
            }

            @Override
            public int get(FileDescriptor fdo) {
                return fdo.fd;
            }

            @Override
            public void setAppend(FileDescriptor fdo, boolean append) {
                fdo.append = append;
            }

            @Override
            public boolean getAppend(FileDescriptor fdo) {
                return fdo.append;
            }

            @Override
            public void close(FileDescriptor fdo) throws IOException {
                fdo.close();
            }

            @Override
            public void registerCleanup(FileDescriptor fdo) {
                FileCleanable.register(fdo);
            }

            @Override
            public void registerCleanup(FileDescriptor fdo, PhantomCleanable<FileDescriptor> cleanup) {
                fdo.registerCleanup(cleanup);
            }

            @Override
            public void unregisterCleanup(FileDescriptor fdo) {
                fdo.unregisterCleanup();
            }

            @Override
            public void setHandle(FileDescriptor fdo, long handle) {
                fdo.setHandle(handle);
            }

            @Override
            public long getHandle(FileDescriptor fdo) {
                return fdo.handle;
            }
        });
        in = new FileDescriptor(0);
        out = new FileDescriptor(1);
        err = new FileDescriptor(2);
    }
}

