/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.IO_Util;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.posix.Fcntl;

class FileInputStream$_native {
    private FileDescriptor fd;

    FileInputStream$_native() {
    }

    private void open0(String name) throws FileNotFoundException {
        IO_Util.fileOpen(this.fd, name, Fcntl.O_RDONLY);
    }

    private int read0() throws IOException {
        return IO_Util.readSingle(this.fd);
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        return IO_Util.readBytes(this.fd, b, off, len);
    }

    private long length0() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException("Stream closed");
        }
        long length = IO_Util.IO_GetLength(this.fd);
        if (length == -1L) {
            throw new IOException("GetLength failed");
        }
        return length;
    }

    private long position0() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException("Stream closed");
        }
        long length = IO_Util.handleLseek(this.fd, 0L, Fcntl.SEEK_CUR);
        if (length == -1L) {
            throw new IOException("GetLength failed");
        }
        return length;
    }

    private long skip0(long n) throws IOException {
        long end;
        if (!this.fd.valid()) {
            throw new IOException("Stream closed");
        }
        long cur = IO_Util.handleLseek(this.fd, 0L, Fcntl.SEEK_CUR);
        if (cur == -1L || (end = IO_Util.handleLseek(this.fd, n, Fcntl.SEEK_CUR)) == -1L) {
            throw new IOException("Seek error");
        }
        return end - cur;
    }

    private int available0() throws IOException {
        CNative.c_long ret = (CNative.c_long)CNative.auto();
        if (!this.fd.valid()) {
            throw new IOException("Stream closed");
        }
        if (!IO_Util.handleAvailable(this.fd, (CNative.ptr<CNative.c_long>)CNative.addr_of((CNative.object)ret))) {
            throw new IOException();
        }
        return (int)Math.min(Integer.MAX_VALUE, Math.max(0L, ret.longValue()));
    }

    private static void initIDs() {
    }
}

