/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileCleanable;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import jdk.internal.util.ArraysSupport;
import sun.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final FileDescriptor fd;
    private final String path;
    private volatile FileChannel channel;
    private final Object closeLock = new Object();
    private volatile boolean closed;

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.attach(this);
        this.path = name;
        this.open(name);
        FileCleanable.register(this.fd);
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkRead(fdObj);
        }
        this.fd = fdObj;
        this.path = null;
        this.fd.attach(this);
    }

    private native void open0(String var1) throws FileNotFoundException;

    private void open(String name) throws FileNotFoundException {
        this.open0(name);
    }

    @Override
    public int read() throws IOException {
        return this.read0();
    }

    private native int read0() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        long length = this.length();
        long position = this.position();
        long size = length - position;
        if (length <= 0L || size <= 0L) {
            return super.readAllBytes();
        }
        if (size > Integer.MAX_VALUE) {
            String msg = String.format("Required array size too large for %s: %d = %d - %d", this.path, size, length, position);
            throw new OutOfMemoryError(msg);
        }
        int capacity = (int)size;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = this.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = this.read()) < 0) break;
            capacity = Math.max(ArraysSupport.newLength(capacity, 1, capacity), 8192);
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        int n;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (len == 0) {
            return new byte[0];
        }
        long length = this.length();
        long position = this.position();
        long size = length - position;
        if (length <= 0L || size <= 0L) {
            return super.readNBytes(len);
        }
        int capacity = (int)Math.min((long)len, size);
        byte[] buf = new byte[capacity];
        int remaining = capacity;
        int nread = 0;
        do {
            if ((n = this.read(buf, nread, remaining)) > 0) {
                nread += n;
                remaining -= n;
                continue;
            }
            if (n != 0) continue;
            byte b = (byte)this.read();
            if (b == -1) break;
            buf[nread++] = b;
            --remaining;
        } while (n >= 0 && remaining > 0);
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    private long length() throws IOException {
        return this.length0();
    }

    private native long length0() throws IOException;

    private long position() throws IOException {
        return this.position0();
    }

    private native long position0() throws IOException;

    @Override
    public long skip(long n) throws IOException {
        return this.skip0(n);
    }

    private native long skip0(long var1) throws IOException;

    @Override
    public int available() throws IOException {
        return this.available0();
    }

    private native int available0() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Object object2 = this.closeLock;
        synchronized (object2) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        FileChannel fc = this.channel;
        if (fc != null) {
            fc.close();
        }
        this.fd.closeAll(new Closeable(){

            @Override
            public void close() throws IOException {
                FileInputStream.this.fd.close();
            }
        });
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileChannel fc = this.channel;
        if (fc == null) {
            FileInputStream fileInputStream = this;
            synchronized (fileInputStream) {
                fc = this.channel;
                if (fc == null) {
                    this.channel = fc = FileChannelImpl.open(this.fd, this.path, true, false, false, this);
                    if (this.closed) {
                        try {
                            fc.close();
                        }
                        catch (IOException ioe) {
                            throw new InternalError(ioe);
                        }
                    }
                }
            }
        }
        return fc;
    }

    private static native void initIDs();

    static {
        FileInputStream.initIDs();
    }
}

