/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileCleanable;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import jdk.internal.access.JavaIOFileDescriptorAccess;
import jdk.internal.access.SharedSecrets;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final FileDescriptor fd;
    private volatile FileChannel channel;
    private final String path;
    private final Object closeLock = new Object();
    private volatile boolean closed;

    public FileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null, false);
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.attach(this);
        this.path = name;
        this.open(name, append);
        FileCleanable.register(this.fd);
    }

    public FileOutputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkWrite(fdObj);
        }
        this.fd = fdObj;
        this.path = null;
        this.fd.attach(this);
    }

    private native void open0(String var1, boolean var2) throws FileNotFoundException;

    private void open(String name, boolean append) throws FileNotFoundException {
        this.open0(name, append);
    }

    private native void write(int var1, boolean var2) throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.write(b, fdAccess.getAppend(this.fd));
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length, fdAccess.getAppend(this.fd));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len, fdAccess.getAppend(this.fd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Object object2 = this.closeLock;
        synchronized (object2) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        FileChannel fc = this.channel;
        if (fc != null) {
            fc.close();
        }
        this.fd.closeAll(new Closeable(){

            @Override
            public void close() throws IOException {
                FileOutputStream.this.fd.close();
            }
        });
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileChannel fc = this.channel;
        if (fc == null) {
            FileOutputStream fileOutputStream = this;
            synchronized (fileOutputStream) {
                fc = this.channel;
                if (fc == null) {
                    this.channel = fc = FileChannelImpl.open(this.fd, this.path, false, true, false, this);
                    if (this.closed) {
                        try {
                            fc.close();
                        }
                        catch (IOException ioe) {
                            throw new InternalError(ioe);
                        }
                    }
                }
            }
        }
        return fc;
    }

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

