/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FilePermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.StringJoiner;
import jdk.internal.access.JavaIOFilePermissionAccess;
import jdk.internal.access.SharedSecrets;
import sun.nio.fs.DefaultFileSystemProvider;
import sun.security.action.GetPropertyAction;
import sun.security.util.FilePermCompat;

public final class FilePermission
extends Permission
implements Serializable {
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int READLINK = 16;
    private static final int ALL = 31;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private transient Path npath;
    private transient Path npath2;
    private transient boolean allFiles;
    private transient boolean invalid;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';
    private static final long serialVersionUID = 7930732926638008763L;
    private static final FileSystem builtInFS = DefaultFileSystemProvider.theFileSystem();
    private static final Path here = builtInFS.getPath(GetPropertyAction.privilegedGetProperty("user.dir"), new String[0]);
    private static final Path EMPTY_PATH = builtInFS.getPath("", new String[0]);
    private static final Path DASH_PATH = builtInFS.getPath("-", new String[0]);
    private static final Path DOTDOT_PATH = builtInFS.getPath("..", new String[0]);

    private FilePermission(String name, FilePermission input, Path npath, Path npath2, int mask, String actions) {
        super(name);
        this.npath = npath;
        this.npath2 = npath2;
        this.actions = actions;
        this.mask = mask;
        this.allFiles = input.allFiles;
        this.invalid = input.invalid;
        this.recursive = input.recursive;
        this.directory = input.directory;
        this.cpath = input.cpath;
    }

    private static Path altPath(Path in) {
        try {
            if (!in.isAbsolute()) {
                return here.resolve(in).normalize();
            }
            return here.relativize(in).normalize();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void init(int mask) {
        if ((mask & 0x1F) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (FilePermCompat.nb) {
            String name = this.getName();
            if (name == null) {
                throw new NullPointerException("name can't be null");
            }
            this.mask = mask;
            if (name.equals("<<ALL FILES>>")) {
                this.allFiles = true;
                this.npath = EMPTY_PATH;
                return;
            }
            boolean rememberStar = false;
            if (name.endsWith("*")) {
                rememberStar = true;
                this.recursive = false;
                name = name.substring(0, name.length() - 1) + "-";
            }
            try {
                this.npath = builtInFS.getPath(new File(name).getPath(), new String[0]).normalize();
                Path lastName = this.npath.getFileName();
                if (lastName != null && lastName.equals(DASH_PATH)) {
                    this.directory = true;
                    this.recursive = !rememberStar;
                    this.npath = this.npath.getParent();
                }
                if (this.npath == null) {
                    this.npath = EMPTY_PATH;
                }
                this.invalid = false;
            }
            catch (InvalidPathException ipe) {
                this.npath = builtInFS.getPath("-u-s-e-l-e-s-s-", new String[0]);
                this.invalid = true;
            }
        } else {
            int last;
            this.cpath = this.getName();
            if (this.cpath == null) {
                throw new NullPointerException("name can't be null");
            }
            this.mask = mask;
            if (this.cpath.equals("<<ALL FILES>>")) {
                this.allFiles = true;
                this.directory = true;
                this.recursive = true;
                this.cpath = "";
                return;
            }
            try {
                String name = this.cpath.endsWith("*") ? this.cpath.substring(0, this.cpath.length() - 1) + "-" : this.cpath;
                builtInFS.getPath(new File(name).getPath(), new String[0]);
            }
            catch (InvalidPathException ipe) {
                this.invalid = true;
                return;
            }
            this.cpath = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        String path = FilePermission.this.cpath;
                        if (FilePermission.this.cpath.endsWith("*")) {
                            path = path.substring(0, path.length() - 1) + "-";
                            path = new File(path).getCanonicalPath();
                            return path.substring(0, path.length() - 1) + "*";
                        }
                        return new File(path).getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        return FilePermission.this.cpath;
                    }
                }
            });
            int len = this.cpath.length();
            int n = last = len > 0 ? (int)this.cpath.charAt(len - 1) : 0;
            if (last == 45 && this.cpath.charAt(len - 2) == File.separatorChar) {
                this.directory = true;
                this.recursive = true;
                this.cpath = this.cpath.substring(0, --len);
            } else if (last == 42 && this.cpath.charAt(len - 2) == File.separatorChar) {
                this.directory = true;
                this.cpath = this.cpath.substring(0, --len);
            }
        }
    }

    public FilePermission(String path, String actions) {
        super(path);
        this.init(FilePermission.getMask(actions));
    }

    FilePermission(String path, int mask) {
        super(path);
        this.init(mask);
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof FilePermission)) {
            return false;
        }
        FilePermission that = (FilePermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(FilePermission that) {
        if (this == that) {
            return true;
        }
        if (this.allFiles) {
            return true;
        }
        if (this.invalid || that.invalid) {
            return false;
        }
        if (that.allFiles) {
            return false;
        }
        if (FilePermCompat.nb) {
            if ((this.recursive && that.recursive) != that.recursive || (this.directory && that.directory) != that.directory) {
                return false;
            }
            if (this.npath.equals(that.npath) && this.directory == that.directory) {
                return true;
            }
            int diff = FilePermission.containsPath(this.npath, that.npath);
            if (diff >= 1 && this.recursive) {
                return true;
            }
            if (diff == 1 && this.directory && !that.directory) {
                return true;
            }
            if (this.npath2 != null) {
                if (this.npath2.equals(that.npath) && this.directory == that.directory) {
                    return true;
                }
                diff = FilePermission.containsPath(this.npath2, that.npath);
                if (diff >= 1 && this.recursive) {
                    return true;
                }
                if (diff == 1 && this.directory && !that.directory) {
                    return true;
                }
            }
            return false;
        }
        if (this.directory) {
            if (this.recursive) {
                if (that.directory) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() > this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.directory) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf(File.separatorChar);
            if (last == -1) {
                return false;
            }
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        if (that.directory) {
            return false;
        }
        return this.cpath.equals(that.cpath);
    }

    private static int containsPath(Path p1, Path p2) {
        int i;
        if (!Objects.equals(p1.getRoot(), p2.getRoot())) {
            return -1;
        }
        if (p1.equals(EMPTY_PATH)) {
            if (p2.equals(EMPTY_PATH)) {
                return 0;
            }
            if (p2.getName(0).equals(DOTDOT_PATH)) {
                return -1;
            }
            return p2.getNameCount();
        }
        if (p2.equals(EMPTY_PATH)) {
            int c1 = p1.getNameCount();
            if (!p1.getName(c1 - 1).equals(DOTDOT_PATH)) {
                return -1;
            }
            return c1;
        }
        int c1 = p1.getNameCount();
        int c2 = p2.getNameCount();
        int n = Math.min(c1, c2);
        for (i = 0; i < n && p1.getName(i).equals(p2.getName(i)); ++i) {
        }
        if (i < c1 && !p1.getName(c1 - 1).equals(DOTDOT_PATH)) {
            return -1;
        }
        if (i < c2 && p2.getName(i).equals(DOTDOT_PATH)) {
            return -1;
        }
        return c1 - i + c2 - i;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilePermission)) {
            return false;
        }
        FilePermission that = (FilePermission)obj;
        if (this.invalid || that.invalid) {
            return false;
        }
        if (FilePermCompat.nb) {
            return this.mask == that.mask && this.allFiles == that.allFiles && this.npath.equals(that.npath) && Objects.equals(this.npath2, that.npath2) && this.directory == that.directory && this.recursive == that.recursive;
        }
        return this.mask == that.mask && this.allFiles == that.allFiles && this.cpath.equals(that.cpath) && this.directory == that.directory && this.recursive == that.recursive;
    }

    @Override
    public int hashCode() {
        if (FilePermCompat.nb) {
            return Objects.hash(this.mask, this.allFiles, this.directory, this.recursive, this.npath, this.npath2, this.invalid);
        }
        return 0;
    }

    private static int getMask(String actions) {
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        if (actions == "read") {
            return 4;
        }
        if (actions == "write") {
            return 2;
        }
        if (actions == "execute") {
            return 1;
        }
        if (actions == "delete") {
            return 8;
        }
        if (actions == "readlink") {
            return 16;
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 3 || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'a' && a[i - 1] != 'A' || a[i] != 'd' && a[i] != 'D')) {
                matchlen = 4;
                mask |= 4;
            } else if (!(i < 4 || a[i - 4] != 'w' && a[i - 4] != 'W' || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'i' && a[i - 2] != 'I' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 5;
                mask |= 2;
            } else if (!(i < 6 || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'x' && a[i - 5] != 'X' || a[i - 4] != 'e' && a[i - 4] != 'E' || a[i - 3] != 'c' && a[i - 3] != 'C' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 7;
                mask |= 1;
            } else if (!(i < 5 || a[i - 5] != 'd' && a[i - 5] != 'D' || a[i - 4] != 'e' && a[i - 4] != 'E' || a[i - 3] != 'l' && a[i - 3] != 'L' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 6;
                mask |= 8;
            } else if (!(i < 7 || a[i - 7] != 'r' && a[i - 7] != 'R' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'a' && a[i - 5] != 'A' || a[i - 4] != 'd' && a[i - 4] != 'D' || a[i - 3] != 'l' && a[i - 3] != 'L' || a[i - 2] != 'i' && a[i - 2] != 'I' || a[i - 1] != 'n' && a[i - 1] != 'N' || a[i] != 'k' && a[i] != 'K')) {
                matchlen = 8;
                mask |= 0x10;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            boolean seencomma = false;
            while (i >= matchlen && !seencomma) {
                c = a[i - matchlen];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        if (c == ',' && i > matchlen) {
                            seencomma = true;
                            break;
                        }
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        return mask;
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int mask) {
        StringJoiner sj = new StringJoiner(",");
        if ((mask & 4) == 4) {
            sj.add("read");
        }
        if ((mask & 2) == 2) {
            sj.add("write");
        }
        if ((mask & 1) == 1) {
            sj.add("execute");
        }
        if ((mask & 8) == 8) {
            sj.add("delete");
        }
        if ((mask & 0x10) == 16) {
            sj.add("readlink");
        }
        return sj.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = FilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new FilePermissionCollection();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(FilePermission.getMask(this.actions));
    }

    FilePermission withNewActions(int effective) {
        return new FilePermission(this.getName(), this, this.npath, this.npath2, effective, null);
    }

    static {
        SharedSecrets.setJavaIOFilePermissionAccess(new JavaIOFilePermissionAccess(){

            @Override
            public FilePermission newPermPlusAltPath(FilePermission input) {
                Path npath2;
                if (!input.invalid && input.npath2 == null && !input.allFiles && (npath2 = FilePermission.altPath(input.npath)) != null) {
                    return new FilePermission(input.getName() + "#plus", input, input.npath, npath2, input.mask, input.actions);
                }
                return input;
            }

            @Override
            public FilePermission newPermUsingAltPath(FilePermission input) {
                Path npath2;
                if (!input.invalid && !input.allFiles && (npath2 = FilePermission.altPath(input.npath)) != null) {
                    return new FilePermission(input.getName() + "#using", input, npath2, null, input.mask, input.actions);
                }
                return null;
            }
        });
    }
}

