/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

final class FilePermissionCollection
extends PermissionCollection
implements Serializable {
    private transient ConcurrentHashMap<String, Permission> perms = new ConcurrentHashMap();
    private static final long serialVersionUID = 2202956749081564585L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Vector.class)};

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        FilePermission fp = (FilePermission)permission;
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.perms.merge(fp.getName(), fp, new BiFunction<Permission, Permission, Permission>(){

            @Override
            public Permission apply(Permission existingVal, Permission newVal) {
                int newMask;
                int oldMask = ((FilePermission)existingVal).getMask();
                if (oldMask != (newMask = ((FilePermission)newVal).getMask())) {
                    int effective = oldMask | newMask;
                    if (effective == newMask) {
                        return newVal;
                    }
                    if (effective != oldMask) {
                        return ((FilePermission)newVal).withNewActions(effective);
                    }
                }
                return existingVal;
            }
        });
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission fperm = (FilePermission)permission;
        int desired = fperm.getMask();
        int effective = 0;
        int needed = desired;
        for (Permission perm : this.perms.values()) {
            FilePermission fp = (FilePermission)perm;
            if ((needed & fp.getMask()) == 0 || !fp.impliesIgnoreMask(fperm)) continue;
            if (((effective |= fp.getMask()) & desired) == desired) {
                return true;
            }
            needed = desired & ~effective;
        }
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.perms.elements();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Vector<Permission> permissions = new Vector<Permission>(this.perms.values());
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", permissions);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Vector permissions = (Vector)gfields.get("permissions", null);
        this.perms = new ConcurrentHashMap(permissions.size());
        for (Permission perm : permissions) {
            this.perms.put(perm.getName(), perm);
        }
    }
}

