/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileDescriptor;
import java.io.FileDescriptor$_native;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.qbicc.runtime.Build;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.posix.Fcntl;
import org.qbicc.runtime.posix.SysStat;
import org.qbicc.runtime.posix.SysTypes;
import org.qbicc.runtime.posix.Unistd;
import org.qbicc.runtime.stdc.Errno;
import org.qbicc.runtime.stdc.Stddef;
import org.qbicc.runtime.stdc.Stdint;
import org.qbicc.runtime.stdc.Stdlib;
import org.qbicc.runtime.stdc.String;

final class IO_Util {
    private static final int BUF_SIZE = 8192;

    IO_Util() {
    }

    static int readSingle(FileDescriptor fd) throws IOException {
        if (Build.Target.isPosix()) {
            if (!fd.valid()) {
                throw new IOException("Stream closed");
            }
            CNative.c_char ret = (CNative.c_char)CNative.auto();
            int cnt = IO_Util.handleRead(fd, (CNative.ptr<CNative.c_char>)CNative.addr_of((CNative.object)ret), 1).intValue();
            if (cnt == 0) {
                return -1;
            }
            if (cnt == -1) {
                throw new IOException("Read error");
            }
            return ret.byteValue() & 0xFF;
        }
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    static void writeSingle(FileDescriptor fd, byte b, boolean append) throws IOException {
        if (Build.Target.isPosix()) {
            if (!fd.valid()) {
                throw new IOException("Stream closed");
            }
            int cnt = IO_Util.handleWrite(fd, (CNative.ptr<CNative.c_char>)((CNative.ptr)CNative.addr_of((byte)b).cast()), 1).intValue();
            if (cnt == -1) {
                throw new IOException("Write error");
            }
        } else {
            if (Build.Target.isWindows()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
    }

    static CNative.char_ptr mallocStringChars(java.lang.String str) throws OutOfMemoryError {
        byte[] bytes = str.getBytes(Charset.defaultCharset());
        CNative.char_ptr ptr2 = (CNative.char_ptr)Stdlib.malloc((Stddef.size_t)((Stddef.size_t)CNative.word((int)(bytes.length + 1))));
        if (ptr2.isNull()) {
            throw new OutOfMemoryError("malloc failed");
        }
        CNative.copy((Stdint.int8_t_ptr)((Stdint.int8_t_ptr)ptr2.cast()), (byte[])bytes, (int)0, (int)bytes.length);
        ((CNative.c_char[])ptr2.asArray())[bytes.length] = (CNative.c_char)CNative.zero();
        return ptr2;
    }

    static long handleOpen(// Could not load outer class - annotation placement on inner may be incorrect
    CNative.ptr<// Could not load outer class - annotation placement on inner may be incorrect
    @CNative.c_const CNative.c_char> path, CNative.c_int flags, CNative.c_int mode) {
        if (Build.Target.isPosix()) {
            int result;
            CNative.c_int ofd;
            while ((ofd = Fcntl.open((CNative.const_char_ptr)((CNative.const_char_ptr)path.cast()), (CNative.c_int)flags, (SysTypes.mode_t)((SysTypes.mode_t)mode.cast()))).intValue() == -1 && Errno.errno == org.qbicc.runtime.posix.Errno.EINTR.intValue()) {
            }
            if (ofd.intValue() == -1) {
                return -1L;
            }
            SysStat.struct_stat buf = (SysStat.struct_stat)CNative.auto();
            while ((result = SysStat.fstat((CNative.c_int)ofd, (SysStat.struct_stat_ptr)((SysStat.struct_stat_ptr)CNative.addr_of((CNative.object)buf))).intValue()) == -1 && Errno.errno == org.qbicc.runtime.posix.Errno.EINTR.intValue()) {
            }
            if (result == -1) {
                Unistd.close((CNative.c_int)ofd);
                return -1L;
            }
            if ((buf.st_mode.longValue() & SysStat.S_IFDIR.longValue()) != 0L) {
                Unistd.close((CNative.c_int)ofd);
                Errno.errno = org.qbicc.runtime.posix.Errno.EISDIR.intValue();
                return -1L;
            }
            return ofd.longValue();
        }
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fileOpen(FileDescriptor fd, java.lang.String name, CNative.c_int flags) throws FileNotFoundException {
        if (Build.Target.isPosix()) {
            CNative.char_ptr ptr2 = IO_Util.mallocStringChars(name);
            try {
                int fdes;
                if (Build.Target.isLinux()) {
                    CNative.char_ptr p = (CNative.char_ptr)ptr2.plus(String.strlen((CNative.const_char_ptr)((CNative.const_char_ptr)ptr2.cast())).intValue() - 1);
                    while (p.isGt((CNative.word)ptr2) && ((CNative.c_char)p.loadUnshared()).byteValue() == 47) {
                        p.storeUnshared((Object)((CNative.c_char)CNative.zero()));
                        p = (CNative.char_ptr)p.minus(1);
                    }
                }
                if ((fdes = (int)IO_Util.handleOpen((CNative.ptr<CNative.c_char>)ptr2, flags, (CNative.c_int)CNative.word((int)438))) == -1) {
                    throw new FileNotFoundException(name);
                }
                ((FileDescriptor$_native)((Object)fd)).fd = fdes;
                ((FileDescriptor$_native)((Object)fd)).append = (flags.intValue() & Fcntl.O_APPEND.intValue()) != 0;
            }
            finally {
                Stdlib.free((CNative.ptr)ptr2);
            }
        } else {
            if (Build.Target.isWindows()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int readBytes(FileDescriptor fd, byte[] b, int off, int len) throws IOException {
        CNative.char_ptr buf;
        Objects.requireNonNull(b, "b");
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (!fd.valid()) {
            throw new IOException("Stream closed");
        }
        CNative.char_ptr stackBuf = (CNative.char_ptr)CNative.alloca((Stddef.size_t)((Stddef.size_t)CNative.word((long)(CNative.sizeof(CNative.c_char.class).longValue() * 8192L))));
        if (len == 0) {
            return 0;
        }
        if (len > 8192) {
            buf = (CNative.char_ptr)Stdlib.malloc((Stddef.size_t)((Stddef.size_t)CNative.word((int)len)));
            if (buf.isNull()) {
                throw new OutOfMemoryError();
            }
        } else {
            buf = stackBuf;
        }
        try {
            int nread = IO_Util.handleRead(fd, (CNative.ptr<CNative.c_char>)buf, len).intValue();
            if (nread > 0) {
                CNative.copy((byte[])b, (int)off, (int)len, (Stdint.const_int8_t_ptr)((Stdint.const_int8_t_ptr)buf.cast()));
                int n = nread;
                return n;
            }
            if (nread == -1) {
                throw new IOException("Read error");
            }
            int n = -1;
            return n;
        }
        finally {
            if (buf != stackBuf) {
                Stdlib.free((CNative.ptr)buf);
            }
        }
    }

    static void writeBytes(FileDescriptor fd, byte[] b, int off, int len, boolean append) throws IOException {
        Objects.requireNonNull(b, "b");
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (!fd.valid()) {
            throw new IOException("Stream closed");
        }
        while (len > 0) {
            SysTypes.ssize_t nw = Build.Target.isPosix() || !append ? IO_Util.handleWrite(fd, (CNative.ptr<CNative.c_char>)((CNative.ptr)CNative.addr_of((byte)b[off]).cast()), len) : IO_Util.handleAppend(fd, (CNative.ptr<CNative.c_char>)((CNative.ptr)CNative.addr_of((byte)b[off]).cast()), len);
            len -= nw.intValue();
            off += nw.intValue();
        }
    }

    static long IO_GetLength(FileDescriptor fd) {
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        if (Build.Target.isPosix()) {
            int res;
            int fdes = ((FileDescriptor$_native)((Object)fd)).fd;
            SysStat.struct_stat buf = (SysStat.struct_stat)CNative.auto();
            while ((res = SysStat.fstat((CNative.c_int)((CNative.c_int)CNative.word((int)fdes)), (SysStat.struct_stat_ptr)((SysStat.struct_stat_ptr)CNative.addr_of((CNative.object)buf))).intValue()) == -1 && Errno.errno == org.qbicc.runtime.posix.Errno.EINTR.intValue()) {
            }
            if (res < 0) {
                return -1L;
            }
            return buf.st_size.longValue();
        }
        throw new UnsupportedOperationException();
    }

    static long handleLseek(FileDescriptor fd, long offs, CNative.c_int whence) {
        if (Build.Target.isPosix()) {
            int fdes = ((FileDescriptor$_native)((Object)fd)).fd;
            return Unistd.lseek((CNative.c_int)((CNative.c_int)CNative.word((int)fdes)), (SysTypes.off_t)((SysTypes.off_t)CNative.word((long)offs)), (CNative.c_int)whence).longValue();
        }
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    static boolean handleAvailable(FileDescriptor fd, CNative.ptr<CNative.c_long> cntPtr) {
        if (Build.Target.isPosix()) {
            throw new UnsupportedOperationException();
        }
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    static SysTypes.ssize_t handleRead(FileDescriptor fd, CNative.ptr<CNative.c_char> buf, int cnt) throws IOException {
        if (!fd.valid()) {
            throw new IOException("Stream closed");
        }
        if (Build.Target.isPosix()) {
            SysTypes.ssize_t result;
            int fdes = ((FileDescriptor$_native)((Object)fd)).fd;
            while ((result = Unistd.read((CNative.c_int)((CNative.c_int)CNative.word((int)fdes)), (CNative.void_ptr)((CNative.void_ptr)buf.cast()), (Stddef.size_t)((Stddef.size_t)CNative.word((int)cnt)))).longValue() == -1L && Errno.errno == org.qbicc.runtime.posix.Errno.EINTR.intValue()) {
            }
            return result;
        }
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    static SysTypes.ssize_t handleWrite(FileDescriptor fd, CNative.ptr<CNative.c_char> buf, int cnt) throws IOException {
        if (!fd.valid()) {
            throw new IOException("Stream closed");
        }
        if (Build.Target.isPosix()) {
            SysTypes.ssize_t result;
            int fdes = ((FileDescriptor$_native)((Object)fd)).fd;
            while ((result = Unistd.write((CNative.c_int)((CNative.c_int)CNative.word((int)fdes)), (CNative.const_void_ptr)((CNative.const_void_ptr)buf.cast()), (Stddef.size_t)((Stddef.size_t)CNative.word((int)cnt)))).longValue() == -1L && Errno.errno == org.qbicc.runtime.posix.Errno.EINTR.intValue()) {
            }
            return result;
        }
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    static SysTypes.ssize_t handleAppend(FileDescriptor fd, CNative.ptr<CNative.c_char> buf, int cnt) throws IOException {
        throw new UnsupportedOperationException();
    }
}

