/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public abstract class InputStream
implements Closeable {
    private static final int MAX_SKIP_BUFFER_SIZE = 2048;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public static InputStream nullInputStream() {
        return new InputStream(){
            private volatile boolean closed;

            private void ensureOpen() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
            }

            @Override
            public int available() throws IOException {
                this.ensureOpen();
                return 0;
            }

            @Override
            public int read() throws IOException {
                this.ensureOpen();
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                Objects.checkFromIndexSize(off, len, b.length);
                if (len == 0) {
                    return 0;
                }
                this.ensureOpen();
                return -1;
            }

            @Override
            public byte[] readAllBytes() throws IOException {
                this.ensureOpen();
                return new byte[0];
            }

            @Override
            public int readNBytes(byte[] b, int off, int len) throws IOException {
                Objects.checkFromIndexSize(off, len, b.length);
                this.ensureOpen();
                return 0;
            }

            @Override
            public byte[] readNBytes(int len) throws IOException {
                if (len < 0) {
                    throw new IllegalArgumentException("len < 0");
                }
                this.ensureOpen();
                return new byte[0];
            }

            @Override
            public long skip(long n) throws IOException {
                this.ensureOpen();
                return 0L;
            }

            @Override
            public void skipNBytes(long n) throws IOException {
                this.ensureOpen();
                if (n > 0L) {
                    throw new EOFException();
                }
            }

            @Override
            public long transferTo(OutputStream out) throws IOException {
                Objects.requireNonNull(out);
                this.ensureOpen();
                return 0L;
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    public byte[] readAllBytes() throws IOException {
        return this.readNBytes(Integer.MAX_VALUE);
    }

    public byte[] readNBytes(int len) throws IOException {
        int n;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = this.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            if (nread < buf.length) {
                buf = Arrays.copyOfRange(buf, 0, nread);
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    public int readNBytes(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        Objects.checkFromIndexSize(off, len, b.length);
        for (n = 0; n < len && (count = this.read(b, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }

    public long skip(long n) throws IOException {
        int nr;
        long remaining;
        if (n <= 0L) {
            return 0L;
        }
        int size = (int)Math.min(2048L, remaining);
        byte[] skipBuffer = new byte[size];
        for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    public void skipNBytes(long n) throws IOException {
        while (n > 0L) {
            long ns = this.skip(n);
            if (ns > 0L && ns <= n) {
                n -= ns;
                continue;
            }
            if (ns == 0L) {
                if (this.read() == -1) {
                    throw new EOFException();
                }
                --n;
                continue;
            }
            throw new IOException("Unable to skip exactly");
        }
    }

    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public long transferTo(OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = this.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }
}

