/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private static final int NONE = 0;
    private static final int CHAR = 1;
    private static final int EOL = 2;
    private static final int EOF = 3;
    private int prevChar = 0;
    private int lineNumber = 0;
    private int markedLineNumber;
    private boolean skipLF;
    private boolean markedSkipLF;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    public LineNumberReader(Reader in) {
        super(in);
    }

    public LineNumberReader(Reader in, int sz) {
        super(in, sz);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            int c = super.read();
            if (this.skipLF) {
                if (c == 10) {
                    c = super.read();
                }
                this.skipLF = false;
            }
            switch (c) {
                case 13: {
                    this.skipLF = true;
                }
                case 10: {
                    ++this.lineNumber;
                    this.prevChar = 2;
                    return 10;
                }
                case -1: {
                    if (this.prevChar == 1) {
                        ++this.lineNumber;
                    }
                    this.prevChar = 3;
                    break;
                }
                default: {
                    this.prevChar = 1;
                }
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            int n = super.read(cbuf, off, len);
            if (n == -1) {
                if (this.prevChar == 1) {
                    ++this.lineNumber;
                }
                this.prevChar = 3;
                return -1;
            }
            for (int i = off; i < off + n; ++i) {
                char c = cbuf[i];
                if (this.skipLF) {
                    this.skipLF = false;
                    if (c == '\n') continue;
                }
                switch (c) {
                    case '\r': {
                        this.skipLF = true;
                    }
                    case '\n': {
                        ++this.lineNumber;
                    }
                }
            }
            if (n > 0) {
                switch (cbuf[off + n - 1]) {
                    case '\n': 
                    case '\r': {
                        this.prevChar = 2;
                        break;
                    }
                    default: {
                        this.prevChar = 1;
                    }
                }
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine() throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            boolean[] term = new boolean[1];
            String l = super.readLine(this.skipLF, term);
            this.skipLF = false;
            if (l != null) {
                ++this.lineNumber;
                this.prevChar = term[0] ? 2 : 3;
            } else {
                if (this.prevChar == 1) {
                    ++this.lineNumber;
                }
                this.prevChar = 3;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        int nn = (int)Math.min(n, 8192L);
        Object object2 = this.lock;
        synchronized (object2) {
            long r;
            int nc;
            if (this.skipBuffer == null || this.skipBuffer.length < nn) {
                this.skipBuffer = new char[nn];
            }
            for (r = n; r > 0L && (nc = this.read(this.skipBuffer, 0, (int)Math.min(r, (long)nn))) != -1; r -= (long)nc) {
            }
            if (n - r > 0L) {
                this.prevChar = 0;
            }
            return n - r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.skipLF) {
                ++readAheadLimit;
            }
            super.mark(readAheadLimit);
            this.markedLineNumber = this.lineNumber;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            super.reset();
            this.lineNumber = this.markedLineNumber;
            this.skipLF = this.markedSkipLF;
        }
    }
}

