/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ObjectStreamConstants;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.internal.access.SharedSecrets;
import jdk.internal.util.StaticProperty;

@FunctionalInterface
public interface ObjectInputFilter {
    public Status checkInput(FilterInfo var1);

    public static ObjectInputFilter allowFilter(Predicate<Class<?>> predicate, Status otherStatus) {
        Objects.requireNonNull(predicate, "predicate");
        Objects.requireNonNull(otherStatus, "otherStatus");
        return new Config.PredicateFilter(predicate, Status.ALLOWED, otherStatus);
    }

    public static ObjectInputFilter rejectFilter(Predicate<Class<?>> predicate, Status otherStatus) {
        Objects.requireNonNull(predicate, "predicate");
        Objects.requireNonNull(otherStatus, "otherStatus");
        return new Config.PredicateFilter(predicate, Status.REJECTED, otherStatus);
    }

    public static ObjectInputFilter merge(ObjectInputFilter filter, ObjectInputFilter anotherFilter) {
        Objects.requireNonNull(filter, "filter");
        return anotherFilter == null ? filter : new Config.MergeFilter(filter, anotherFilter);
    }

    public static ObjectInputFilter rejectUndecidedClass(ObjectInputFilter filter) {
        Objects.requireNonNull(filter, "filter");
        return new Config.RejectUndecidedFilter(filter);
    }

    public static final class Config {
        private static final Object serialFilterLock;
        private static final String SERIAL_FILTER_PROPNAME = "jdk.serialFilter";
        private static final String SERIAL_FILTER_FACTORY_PROPNAME = "jdk.serialFilterFactory";
        private static volatile ObjectInputFilter serialFilter;
        private static volatile BinaryOperator<ObjectInputFilter> serialFilterFactory;
        private static final AtomicBoolean filterFactoryNoReplace;
        private static final System.Logger configLog;

        private Config() {
        }

        private static void traceFilter(String msg, Object ... args) {
            configLog.log(System.Logger.Level.TRACE, msg, args);
        }

        public static ObjectInputFilter getSerialFilter() {
            return serialFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setSerialFilter(ObjectInputFilter filter) {
            Objects.requireNonNull(filter, "filter");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ObjectStreamConstants.SERIAL_FILTER_PERMISSION);
            }
            Object object2 = serialFilterLock;
            synchronized (object2) {
                if (serialFilter != null) {
                    throw new IllegalStateException("Serial filter can only be set once");
                }
                serialFilter = filter;
            }
        }

        public static BinaryOperator<ObjectInputFilter> getSerialFilterFactory() {
            if (serialFilterFactory == null) {
                throw new IllegalStateException("Serial filter factory initialization incomplete");
            }
            return serialFilterFactory;
        }

        static BinaryOperator<ObjectInputFilter> getSerialFilterFactorySingleton() {
            filterFactoryNoReplace.set(true);
            return Config.getSerialFilterFactory();
        }

        public static void setSerialFilterFactory(BinaryOperator<ObjectInputFilter> filterFactory) {
            Objects.requireNonNull(filterFactory, "filterFactory");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ObjectStreamConstants.SERIAL_FILTER_PERMISSION);
            }
            if (filterFactoryNoReplace.getAndSet(true)) {
                String msg = serialFilterFactory != null ? serialFilterFactory.getClass().getName() : "initialization incomplete";
                throw new IllegalStateException("Cannot replace filter factory: " + msg);
            }
            configLog.log(System.Logger.Level.DEBUG, "Setting deserialization filter factory to {0}", filterFactory.getClass().getName());
            serialFilterFactory = filterFactory;
        }

        public static ObjectInputFilter createFilter(String pattern) {
            Objects.requireNonNull(pattern, "pattern");
            return Global.createFilter(pattern, true);
        }

        static ObjectInputFilter createFilter2(String pattern) {
            Objects.requireNonNull(pattern, "pattern");
            return Global.createFilter(pattern, false);
        }

        static {
            String filterString;
            serialFilterLock = new Object();
            filterFactoryNoReplace = new AtomicBoolean();
            configLog = System.getLogger("java.io.serialization");
            String factoryClassName = StaticProperty.jdkSerialFilterFactory();
            if (factoryClassName == null) {
                factoryClassName = AccessController.doPrivileged(() -> Security.getProperty(SERIAL_FILTER_FACTORY_PROPNAME));
            }
            if ((filterString = StaticProperty.jdkSerialFilter()) == null) {
                filterString = AccessController.doPrivileged(() -> Security.getProperty(SERIAL_FILTER_PROPNAME));
            }
            ObjectInputFilter filter = null;
            if (filterString != null) {
                configLog.log(System.Logger.Level.DEBUG, "Creating deserialization filter from {0}", filterString);
                try {
                    filter = Config.createFilter(filterString);
                }
                catch (RuntimeException re) {
                    configLog.log(System.Logger.Level.ERROR, "Error configuring filter: {0}", (Throwable)re);
                }
            }
            serialFilter = filter;
            if (factoryClassName == null) {
                serialFilterFactory = new BuiltinFilterFactory();
            } else {
                try {
                    filterFactoryNoReplace.set(true);
                    Class<?> factoryClass = Class.forName(factoryClassName, true, ClassLoader.getSystemClassLoader());
                    BinaryOperator factory = (BinaryOperator)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    configLog.log(System.Logger.Level.DEBUG, "Creating deserialization filter factory for {0}", factoryClassName);
                    serialFilterFactory = factory;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException ex) {
                    Throwable throwable;
                    if (ex instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)ex;
                        throwable = ite.getCause();
                    } else {
                        throwable = ex;
                    }
                    Exception th = throwable;
                    configLog.log(System.Logger.Level.ERROR, "Error configuring filter factory: {0}", new Object[]{th});
                    throw new ExceptionInInitializerError(th);
                }
            }
            SharedSecrets.setJavaObjectInputFilterAccess(Config::createFilter2);
        }

        static final class Global
        implements ObjectInputFilter {
            private final String pattern;
            private final List<Function<Class<?>, Status>> filters;
            private long maxStreamBytes;
            private long maxDepth;
            private long maxReferences;
            private long maxArrayLength;
            private final boolean checkComponentType;

            static ObjectInputFilter createFilter(String pattern, boolean checkComponentType) {
                try {
                    return new Global(pattern, checkComponentType);
                }
                catch (UnsupportedOperationException uoe) {
                    return null;
                }
            }

            private Global(String pattern, boolean checkComponentType) {
                boolean hasLimits = false;
                this.pattern = pattern;
                this.checkComponentType = checkComponentType;
                this.maxArrayLength = Long.MAX_VALUE;
                this.maxDepth = Long.MAX_VALUE;
                this.maxReferences = Long.MAX_VALUE;
                this.maxStreamBytes = Long.MAX_VALUE;
                String[] patterns = pattern.split(";");
                this.filters = new ArrayList(patterns.length);
                for (int i = 0; i < patterns.length; ++i) {
                    Function<Class, Status> patternFilter;
                    String p = patterns[i];
                    int nameLen = p.length();
                    if (nameLen == 0) continue;
                    if (this.parseLimit(p)) {
                        hasLimits = true;
                        continue;
                    }
                    boolean negate = p.charAt(0) == '!';
                    int poffset = negate ? 1 : 0;
                    int slash = p.indexOf(47, poffset);
                    if (slash == poffset) {
                        throw new IllegalArgumentException("module name is missing in: \"" + pattern + "\"");
                    }
                    String moduleName = slash >= 0 ? p.substring(poffset, slash) : null;
                    int n = poffset = slash >= 0 ? slash + 1 : poffset;
                    if (p.endsWith("*")) {
                        if (p.endsWith(".*")) {
                            String pkg = p.substring(poffset, nameLen - 2);
                            if (pkg.isEmpty()) {
                                throw new IllegalArgumentException("package missing in: \"" + pattern + "\"");
                            }
                            patternFilter = negate ? c -> Global.matchesPackage(c, pkg) ? Status.REJECTED : Status.UNDECIDED : c -> Global.matchesPackage(c, pkg) ? Status.ALLOWED : Status.UNDECIDED;
                        } else if (p.endsWith(".**")) {
                            String pkgs = p.substring(poffset, nameLen - 2);
                            if (pkgs.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + pattern + "\"");
                            }
                            patternFilter = negate ? c -> c.getName().startsWith(pkgs) ? Status.REJECTED : Status.UNDECIDED : c -> c.getName().startsWith(pkgs) ? Status.ALLOWED : Status.UNDECIDED;
                        } else {
                            String className = p.substring(poffset, nameLen - 1);
                            patternFilter = negate ? c -> c.getName().startsWith(className) ? Status.REJECTED : Status.UNDECIDED : c -> c.getName().startsWith(className) ? Status.ALLOWED : Status.UNDECIDED;
                        }
                    } else {
                        String name = p.substring(poffset);
                        if (name.isEmpty()) {
                            throw new IllegalArgumentException("class or package missing in: \"" + pattern + "\"");
                        }
                        patternFilter = negate ? c -> c.getName().equals(name) ? Status.REJECTED : Status.UNDECIDED : c -> c.getName().equals(name) ? Status.ALLOWED : Status.UNDECIDED;
                    }
                    if (moduleName == null) {
                        this.filters.add(patternFilter);
                        continue;
                    }
                    this.filters.add(c -> moduleName.equals(c.getModule().getName()) ? (Status)((Object)((Object)patternFilter.apply((Class)c))) : Status.UNDECIDED);
                }
                if (this.filters.isEmpty() && !hasLimits) {
                    throw new UnsupportedOperationException("no non-empty patterns");
                }
            }

            private boolean parseLimit(String pattern) {
                int eqNdx = pattern.indexOf(61);
                if (eqNdx < 0) {
                    return false;
                }
                String valueString = pattern.substring(eqNdx + 1);
                if (pattern.startsWith("maxdepth=")) {
                    this.maxDepth = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxarray=")) {
                    this.maxArrayLength = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxrefs=")) {
                    this.maxReferences = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxbytes=")) {
                    this.maxStreamBytes = Global.parseValue(valueString);
                } else {
                    throw new IllegalArgumentException("unknown limit: " + pattern.substring(0, eqNdx));
                }
                return true;
            }

            private static long parseValue(String string) throws IllegalArgumentException {
                long value = Long.parseLong(string);
                if (value < 0L) {
                    throw new IllegalArgumentException("negative limit: " + string);
                }
                return value;
            }

            @Override
            public Status checkInput(FilterInfo filterInfo) {
                if (filterInfo.references() < 0L || filterInfo.depth() < 0L || filterInfo.streamBytes() < 0L || filterInfo.references() > this.maxReferences || filterInfo.depth() > this.maxDepth || filterInfo.streamBytes() > this.maxStreamBytes) {
                    return Status.REJECTED;
                }
                Class<?> clazz = filterInfo.serialClass();
                if (clazz != null) {
                    if (clazz.isArray()) {
                        if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > this.maxArrayLength) {
                            return Status.REJECTED;
                        }
                        if (!this.checkComponentType) {
                            Config.traceFilter("Pattern filter array class: {0}, filter: {1}", clazz, this);
                            return Status.UNDECIDED;
                        }
                        while ((clazz = clazz.getComponentType()).isArray()) {
                        }
                    }
                    if (clazz.isPrimitive()) {
                        Config.traceFilter("Pattern filter UNDECIDED, primitive class: {0}, filter: {1}", clazz, this);
                        return Status.UNDECIDED;
                    }
                    Class<?> cl = clazz;
                    Optional<Status> status = this.filters.stream().map(f -> (Status)((Object)((Object)f.apply(cl)))).filter(p -> p != Status.UNDECIDED).findFirst();
                    Status s = status.orElse(Status.UNDECIDED);
                    Config.traceFilter("Pattern filter {0}, class: {1}, filter: {2}", new Object[]{s, cl, this});
                    return s;
                }
                return Status.UNDECIDED;
            }

            private static boolean matchesPackage(Class<?> c, String pkg) {
                return pkg.equals(c.getPackageName());
            }

            public String toString() {
                return this.pattern;
            }
        }

        private static final class BuiltinFilterFactory
        implements BinaryOperator<ObjectInputFilter> {
            private BuiltinFilterFactory() {
            }

            @Override
            public ObjectInputFilter apply(ObjectInputFilter oldFilter, ObjectInputFilter newFilter) {
                Config.traceFilter("Builtin factory: {0} -> new: {1}", oldFilter, newFilter);
                return newFilter;
            }

            public String toString() {
                return this.getClass().getName();
            }
        }

        private static class RejectUndecidedFilter
        implements ObjectInputFilter {
            private final ObjectInputFilter filter;

            private RejectUndecidedFilter(ObjectInputFilter filter) {
                this.filter = Objects.requireNonNull(filter, "filter");
            }

            @Override
            public Status checkInput(FilterInfo info) {
                Status status = Objects.requireNonNull(this.filter.checkInput(info), "status");
                Class<?> clazz = info.serialClass();
                if (clazz == null || !Status.UNDECIDED.equals((Object)status)) {
                    return status;
                }
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                if (clazz.isPrimitive()) {
                    status = Status.UNDECIDED;
                } else {
                    SerialInfo clazzInfo = new SerialInfo(info, clazz);
                    Status clazzStatus = this.filter.checkInput(clazzInfo);
                    Config.traceFilter("RejectUndecidedFilter Array Component type {0} class: {1}, filter: {2}", new Object[]{clazzStatus, clazz, this});
                    status = Status.ALLOWED.equals((Object)clazzStatus) ? Status.ALLOWED : Status.REJECTED;
                }
                Config.traceFilter("RejectUndecidedFilter {0} class: {1}, filter: {2}", new Object[]{status, info.serialClass(), this});
                return status;
            }

            public String toString() {
                return "rejectUndecidedClass(" + this.filter + ")";
            }

            static class SerialInfo
            implements FilterInfo {
                private final FilterInfo base;
                private final Class<?> clazz;

                SerialInfo(FilterInfo base, Class<?> clazz) {
                    this.base = base;
                    this.clazz = clazz;
                }

                @Override
                public Class<?> serialClass() {
                    return this.clazz;
                }

                @Override
                public long arrayLength() {
                    return this.base.arrayLength();
                }

                @Override
                public long depth() {
                    return this.base.depth();
                }

                @Override
                public long references() {
                    return this.base.references();
                }

                @Override
                public long streamBytes() {
                    return this.base.streamBytes();
                }
            }
        }

        private static class MergeFilter
        implements ObjectInputFilter {
            private final ObjectInputFilter first;
            private final ObjectInputFilter second;

            MergeFilter(ObjectInputFilter first, ObjectInputFilter second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public Status checkInput(FilterInfo info) {
                Status firstStatus = Objects.requireNonNull(this.first.checkInput(info), "status");
                if (Status.REJECTED.equals((Object)firstStatus)) {
                    Config.traceFilter("MergeFilter REJECTED first: {0}, filter: {1}", new Object[]{firstStatus, this});
                    return Status.REJECTED;
                }
                Status secondStatus = Objects.requireNonNull(this.second.checkInput(info), "other status");
                if (Status.REJECTED.equals((Object)secondStatus)) {
                    Config.traceFilter("MergeFilter REJECTED {0}, {1}, filter: {2}", new Object[]{firstStatus, secondStatus, this});
                    return Status.REJECTED;
                }
                if (Status.ALLOWED.equals((Object)firstStatus) || Status.ALLOWED.equals((Object)secondStatus)) {
                    Config.traceFilter("MergeFilter ALLOWED either: {0}, {1}, filter: {2}", new Object[]{firstStatus, secondStatus, this});
                    return Status.ALLOWED;
                }
                Config.traceFilter("MergeFilter UNDECIDED {0}, {1}, filter: {2}", new Object[]{firstStatus, secondStatus, this});
                return Status.UNDECIDED;
            }

            public String toString() {
                return "merge(" + this.first + ", " + this.second + ")";
            }
        }

        private static class PredicateFilter
        implements ObjectInputFilter {
            private final Predicate<Class<?>> predicate;
            private final Status ifTrueStatus;
            private final Status ifFalseStatus;

            PredicateFilter(Predicate<Class<?>> predicate, Status ifTrueStatus, Status ifFalseStatus) {
                this.predicate = predicate;
                this.ifTrueStatus = ifTrueStatus;
                this.ifFalseStatus = ifFalseStatus;
            }

            @Override
            public Status checkInput(FilterInfo info) {
                Class<?> clazz = info.serialClass();
                Status status = clazz == null ? Status.UNDECIDED : (this.predicate.test(clazz) ? this.ifTrueStatus : this.ifFalseStatus);
                Config.traceFilter("PredicateFilter {0}, filter: {1}", new Object[]{status, this});
                return status;
            }

            public String toString() {
                return "predicate(" + this.predicate + ", ifTrue: " + (Object)((Object)this.ifTrueStatus) + ", ifFalse:" + (Object)((Object)this.ifFalseStatus) + ")";
            }
        }
    }

    public static enum Status {
        UNDECIDED,
        ALLOWED,
        REJECTED;

    }

    public static interface FilterInfo {
        public Class<?> serialClass();

        public long arrayLength();

        public long depth();

        public long references();

        public long streamBytes();
    }
}

