/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.internal.access.JavaSecurityAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.reflect.ReflectionFactory;
import sun.reflect.misc.ReflectUtil;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static final ReflectionFactory reflFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    private Class<?> cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean isRecord;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private ExceptionInfo deserializeEx;
    private ExceptionInfo serializeEx;
    private ExceptionInfo defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor<?> cons;
    private MethodHandle canonicalCtr;
    private DeserializationConstructorsCache deserializationCtrs;
    private MethodHandle deserializationCtr;
    private ProtectionDomain[] domains;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;
    private boolean initialized;

    private static native void initNative();

    public static ObjectStreamClass lookup(Class<?> cl) {
        return ObjectStreamClass.lookup(cl, false);
    }

    public static ObjectStreamClass lookupAny(Class<?> cl) {
        return ObjectStreamClass.lookup(cl, true);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            if (this.isRecord) {
                return 0L;
            }
            this.suid = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return ObjectStreamClass.computeDefaultSUID(ObjectStreamClass.this.cl);
                }
            });
        }
        return this.suid;
    }

    @CallerSensitive
    public Class<?> forClass() {
        Class<?> caller;
        if (this.cl == null) {
            return null;
        }
        this.requireInitialized();
        if (System.getSecurityManager() != null && ReflectUtil.needsPackageAccessCheck((caller = Reflection.getCallerClass()).getClassLoader(), this.cl.getClassLoader())) {
            ReflectUtil.checkPackageAccess(this.cl);
        }
        return this.cl;
    }

    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String name) {
        return this.getField(name, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    static ObjectStreamClass lookup(Class<?> cl, boolean all) {
        if (!all && !Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        ObjectStreamClass.processQueue(Caches.localDescsQueue, Caches.localDescs);
        WeakClassKey key = new WeakClassKey(cl, Caches.localDescsQueue);
        Reference ref = (Reference)Caches.localDescs.get(key);
        Object entry = null;
        if (ref != null) {
            entry = ref.get();
        }
        EntryFuture future = null;
        if (entry == null) {
            EntryFuture newEntry = new EntryFuture();
            SoftReference<EntryFuture> newRef = new SoftReference<EntryFuture>(newEntry);
            do {
                if (ref != null) {
                    Caches.localDescs.remove(key, ref);
                }
                if ((ref = (Reference)Caches.localDescs.putIfAbsent(key, newRef)) == null) continue;
                entry = ref.get();
            } while (ref != null && entry == null);
            if (entry == null) {
                future = newEntry;
            }
        }
        if (entry instanceof ObjectStreamClass) {
            return (ObjectStreamClass)entry;
        }
        if (entry instanceof EntryFuture) {
            future = (EntryFuture)entry;
            entry = future.getOwner() == Thread.currentThread() ? null : future.get();
        }
        if (entry == null) {
            try {
                entry = new ObjectStreamClass(cl);
            }
            catch (Throwable th) {
                entry = th;
            }
            if (future.set(entry)) {
                Caches.localDescs.put(key, new SoftReference<Object>(entry));
            } else {
                entry = future.get();
            }
        }
        if (entry instanceof ObjectStreamClass) {
            return (ObjectStreamClass)entry;
        }
        if (entry instanceof RuntimeException) {
            throw (RuntimeException)entry;
        }
        if (entry instanceof Error) {
            throw (Error)entry;
        }
        throw new InternalError("unexpected entry: " + entry);
    }

    private ObjectStreamClass(final Class<?> cl) {
        this.cl = cl;
        this.name = cl.getName();
        this.isProxy = Proxy.isProxyClass(cl);
        this.isEnum = Enum.class.isAssignableFrom(cl);
        this.isRecord = cl.isRecord();
        this.serializable = Serializable.class.isAssignableFrom(cl);
        this.externalizable = Externalizable.class.isAssignableFrom(cl);
        Class<?> superCl = cl.getSuperclass();
        this.superDesc = superCl != null ? ObjectStreamClass.lookup(superCl, false) : null;
        this.localDesc = this;
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    if (ObjectStreamClass.this.isEnum) {
                        ObjectStreamClass.this.suid = 0L;
                        ObjectStreamClass.this.fields = NO_FIELDS;
                        return null;
                    }
                    if (cl.isArray()) {
                        ObjectStreamClass.this.fields = NO_FIELDS;
                        return null;
                    }
                    ObjectStreamClass.this.suid = ObjectStreamClass.getDeclaredSUID(cl);
                    try {
                        ObjectStreamClass.this.fields = ObjectStreamClass.getSerialFields(cl);
                        ObjectStreamClass.this.computeFieldOffsets();
                    }
                    catch (InvalidClassException e) {
                        ObjectStreamClass.this.serializeEx = ObjectStreamClass.this.deserializeEx = new ExceptionInfo(e.classname, e.getMessage());
                        ObjectStreamClass.this.fields = NO_FIELDS;
                    }
                    if (ObjectStreamClass.this.isRecord) {
                        ObjectStreamClass.this.canonicalCtr = ObjectStreamClass.canonicalRecordCtr(cl);
                        ObjectStreamClass.this.deserializationCtrs = new DeserializationConstructorsCache();
                    } else if (ObjectStreamClass.this.externalizable) {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getExternalizableConstructor(cl);
                    } else {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getSerializableConstructor(cl);
                        ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(cl, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
                        ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(cl, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
                        ObjectStreamClass.this.readObjectNoDataMethod = ObjectStreamClass.getPrivateMethod(cl, "readObjectNoData", null, Void.TYPE);
                        ObjectStreamClass.this.hasWriteObjectData = ObjectStreamClass.this.writeObjectMethod != null;
                    }
                    ObjectStreamClass.this.domains = ObjectStreamClass.this.getProtectionDomains(ObjectStreamClass.this.cons, cl);
                    ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.getInheritableMethod(cl, "writeReplace", null, Object.class);
                    ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.getInheritableMethod(cl, "readResolve", null, Object.class);
                    return null;
                }
            });
        } else {
            this.suid = 0L;
            this.fields = NO_FIELDS;
        }
        try {
            this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this);
        }
        catch (InvalidClassException ex) {
            throw new InternalError(ex);
        }
        if (this.deserializeEx == null) {
            if (this.isEnum) {
                this.deserializeEx = new ExceptionInfo(this.name, "enum type");
            } else if (this.cons == null && !this.isRecord) {
                this.deserializeEx = new ExceptionInfo(this.name, "no valid constructor");
            }
        }
        if (this.isRecord && this.canonicalCtr == null) {
            this.deserializeEx = new ExceptionInfo(this.name, "record canonical constructor not found");
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].getField() != null) continue;
                this.defaultSerializeEx = new ExceptionInfo(this.name, "unmatched serializable field(s) declared");
            }
        }
        this.initialized = true;
    }

    ObjectStreamClass() {
    }

    private ProtectionDomain noPermissionsDomain() {
        Permissions perms = new Permissions();
        perms.setReadOnly();
        return new ProtectionDomain(null, perms);
    }

    private ProtectionDomain[] getProtectionDomains(Constructor<?> cons, Class<?> cl) {
        ProtectionDomain[] domains = null;
        if (cons != null && cl.getClassLoader() != null && System.getSecurityManager() != null) {
            Class<?> cls = cl;
            Class<?> fnscl = cons.getDeclaringClass();
            HashSet<ProtectionDomain> pds = null;
            while (cls != fnscl) {
                ProtectionDomain pd = cls.getProtectionDomain();
                if (pd != null) {
                    if (pds == null) {
                        pds = new HashSet<ProtectionDomain>();
                    }
                    pds.add(pd);
                }
                if ((cls = cls.getSuperclass()) != null) continue;
                if (pds == null) {
                    pds = new HashSet();
                } else {
                    pds.clear();
                }
                pds.add(this.noPermissionsDomain());
                break;
            }
            if (pds != null) {
                domains = pds.toArray(new ProtectionDomain[0]);
            }
        }
        return domains;
    }

    void initProxy(Class<?> cl, ClassNotFoundException resolveEx, ObjectStreamClass superDesc) throws InvalidClassException {
        ObjectStreamClass osc = null;
        if (cl != null) {
            osc = ObjectStreamClass.lookup(cl, true);
            if (!osc.isProxy) {
                throw new InvalidClassException("cannot bind proxy descriptor to a non-proxy class");
            }
        }
        this.cl = cl;
        this.resolveEx = resolveEx;
        this.superDesc = superDesc;
        this.isProxy = true;
        this.serializable = true;
        this.suid = 0L;
        this.fields = NO_FIELDS;
        if (osc != null) {
            this.localDesc = osc;
            this.name = this.localDesc.name;
            this.externalizable = this.localDesc.externalizable;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
            this.domains = this.localDesc.domains;
            this.cons = this.localDesc.cons;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.initialized = true;
    }

    void initNonProxy(ObjectStreamClass model, Class<?> cl, ClassNotFoundException resolveEx, ObjectStreamClass superDesc) throws InvalidClassException {
        long suid = model.getSerialVersionUID();
        ObjectStreamClass osc = null;
        if (cl != null) {
            osc = ObjectStreamClass.lookup(cl, true);
            if (osc.isProxy) {
                throw new InvalidClassException("cannot bind non-proxy descriptor to a proxy class");
            }
            if (model.isEnum != osc.isEnum) {
                throw new InvalidClassException(model.isEnum ? "cannot bind enum descriptor to a non-enum class" : "cannot bind non-enum descriptor to an enum class");
            }
            if (model.serializable == osc.serializable && !cl.isArray() && !cl.isRecord() && suid != osc.getSerialVersionUID()) {
                throw new InvalidClassException(osc.name, "local class incompatible: stream classdesc serialVersionUID = " + suid + ", local class serialVersionUID = " + osc.getSerialVersionUID());
            }
            if (!ObjectStreamClass.classNamesEqual(model.name, osc.name)) {
                throw new InvalidClassException(osc.name, "local class name incompatible with stream class name \"" + model.name + "\"");
            }
            if (!model.isEnum) {
                if (model.serializable == osc.serializable && model.externalizable != osc.externalizable) {
                    throw new InvalidClassException(osc.name, "Serializable incompatible with Externalizable");
                }
                if (model.serializable != osc.serializable || model.externalizable != osc.externalizable || !model.serializable && !model.externalizable) {
                    this.deserializeEx = new ExceptionInfo(osc.name, "class invalid for deserialization");
                }
            }
        }
        this.cl = cl;
        this.resolveEx = resolveEx;
        this.superDesc = superDesc;
        this.name = model.name;
        this.suid = suid;
        this.isProxy = false;
        this.isEnum = model.isEnum;
        this.serializable = model.serializable;
        this.externalizable = model.externalizable;
        this.hasBlockExternalData = model.hasBlockExternalData;
        this.hasWriteObjectData = model.hasWriteObjectData;
        this.fields = model.fields;
        this.primDataSize = model.primDataSize;
        this.numObjFields = model.numObjFields;
        if (osc != null) {
            this.localDesc = osc;
            this.isRecord = this.localDesc.isRecord;
            this.canonicalCtr = this.localDesc.canonicalCtr;
            this.deserializationCtrs = this.localDesc.deserializationCtrs;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
            this.domains = this.localDesc.domains;
            assert (!cl.isRecord() || this.localDesc.cons == null);
            this.cons = this.localDesc.cons;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.fields = this.fieldRefl.getFields();
        this.initialized = true;
    }

    void readNonProxy(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean sflag;
        this.name = in.readUTF();
        this.suid = in.readLong();
        this.isProxy = false;
        byte flags = in.readByte();
        this.hasWriteObjectData = (flags & 1) != 0;
        this.hasBlockExternalData = (flags & 8) != 0;
        this.externalizable = (flags & 4) != 0;
        boolean bl = sflag = (flags & 2) != 0;
        if (this.externalizable && sflag) {
            throw new InvalidClassException(this.name, "serializable and externalizable flags conflict");
        }
        this.serializable = this.externalizable || sflag;
        boolean bl2 = this.isEnum = (flags & 0x10) != 0;
        if (this.isEnum && this.suid != 0L) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero serialVersionUID: " + this.suid);
        }
        int numFields = in.readShort();
        if (this.isEnum && numFields != 0) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero field count: " + numFields);
        }
        this.fields = numFields > 0 ? new ObjectStreamField[numFields] : NO_FIELDS;
        for (int i = 0; i < numFields; ++i) {
            char tcode = (char)in.readByte();
            String fname = in.readUTF();
            String signature = tcode == 'L' || tcode == '[' ? in.readTypeString() : String.valueOf(tcode);
            try {
                this.fields[i] = new ObjectStreamField(fname, signature, false);
                continue;
            }
            catch (RuntimeException e) {
                throw (IOException)new InvalidClassException(this.name, "invalid descriptor for field " + fname).initCause(e);
            }
        }
        this.computeFieldOffsets();
    }

    void writeNonProxy(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.getSerialVersionUID());
        int flags = 0;
        if (this.externalizable) {
            flags = (byte)(flags | 4);
            int protocol = out.getProtocolVersion();
            if (protocol != 1) {
                flags = (byte)(flags | 8);
            }
        } else if (this.serializable) {
            flags = (byte)(flags | 2);
        }
        if (this.hasWriteObjectData) {
            flags = (byte)(flags | 1);
        }
        if (this.isEnum) {
            flags = (byte)(flags | 0x10);
        }
        out.writeByte(flags);
        out.writeShort(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            out.writeByte(f.getTypeCode());
            out.writeUTF(f.getName());
            if (f.isPrimitive()) continue;
            out.writeTypeString(f.getTypeString());
        }
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    private final void requireInitialized() {
        if (!this.initialized) {
            throw new InternalError("Unexpected call when not initialized");
        }
    }

    final void checkInitialized() throws InvalidClassException {
        if (!this.initialized) {
            throw new InvalidClassException("Class descriptor should be initialized");
        }
    }

    void checkDeserialize() throws InvalidClassException {
        this.requireInitialized();
        if (this.deserializeEx != null) {
            throw this.deserializeEx.newInvalidClassException();
        }
    }

    void checkSerialize() throws InvalidClassException {
        this.requireInitialized();
        if (this.serializeEx != null) {
            throw this.serializeEx.newInvalidClassException();
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        this.requireInitialized();
        if (this.defaultSerializeEx != null) {
            throw this.defaultSerializeEx.newInvalidClassException();
        }
    }

    ObjectStreamClass getSuperDesc() {
        this.requireInitialized();
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        this.requireInitialized();
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean copy) {
        return copy ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String name, Class<?> type) {
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            if (!f.getName().equals(name)) continue;
            if (type == null || type == Object.class && !f.isPrimitive()) {
                return f;
            }
            Class<?> ftype = f.getType();
            if (ftype == null || !type.isAssignableFrom(ftype)) continue;
            return f;
        }
        return null;
    }

    boolean isProxy() {
        this.requireInitialized();
        return this.isProxy;
    }

    boolean isEnum() {
        this.requireInitialized();
        return this.isEnum;
    }

    boolean isRecord() {
        this.requireInitialized();
        return this.isRecord;
    }

    boolean isExternalizable() {
        this.requireInitialized();
        return this.externalizable;
    }

    boolean isSerializable() {
        this.requireInitialized();
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        this.requireInitialized();
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        this.requireInitialized();
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        this.requireInitialized();
        return this.cons != null;
    }

    boolean hasWriteObjectMethod() {
        this.requireInitialized();
        return this.writeObjectMethod != null;
    }

    boolean hasReadObjectMethod() {
        this.requireInitialized();
        return this.readObjectMethod != null;
    }

    boolean hasReadObjectNoDataMethod() {
        this.requireInitialized();
        return this.readObjectNoDataMethod != null;
    }

    boolean hasWriteReplaceMethod() {
        this.requireInitialized();
        return this.writeReplaceMethod != null;
    }

    boolean hasReadResolveMethod() {
        this.requireInitialized();
        return this.readResolveMethod != null;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.cons != null) {
            try {
                if (this.domains == null || this.domains.length == 0) {
                    return this.cons.newInstance(new Object[0]);
                }
                JavaSecurityAccess jsa = SharedSecrets.getJavaSecurityAccess();
                PrivilegedAction<Object> pea = () -> {
                    try {
                        return this.cons.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException x) {
                        throw new UndeclaredThrowableException(x);
                    }
                };
                try {
                    return jsa.doIntersectionPrivilege(pea, AccessController.getContext(), new AccessControlContext(this.domains));
                }
                catch (UndeclaredThrowableException x) {
                    Throwable cause = x.getCause();
                    if (cause instanceof InstantiationException) {
                        throw (InstantiationException)cause;
                    }
                    if (cause instanceof InvocationTargetException) {
                        throw (InvocationTargetException)cause;
                    }
                    if (cause instanceof IllegalAccessException) {
                        throw (IllegalAccessException)cause;
                    }
                    throw x;
                }
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(ex);
            }
            catch (InstantiationError err) {
                InstantiationException ex = new InstantiationException();
                ex.initCause(err);
                throw ex;
            }
        }
        throw new UnsupportedOperationException();
    }

    void invokeWriteObject(Object obj, ObjectOutputStream out) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.writeObjectMethod != null) {
            try {
                this.writeObjectMethod.invoke(obj, out);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getCause();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObject(Object obj, ObjectInputStream in) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.readObjectMethod != null) {
            try {
                this.readObjectMethod.invoke(obj, in);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getCause();
                if (th instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)th;
                }
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObjectNoData(Object obj) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getCause();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    Object invokeWriteReplace(Object obj) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getCause();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
                throw new InternalError(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(ex);
            }
        }
        throw new UnsupportedOperationException();
    }

    Object invokeReadResolve(Object obj) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getCause();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
                throw new InternalError(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(ex);
            }
        }
        throw new UnsupportedOperationException();
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        Class<?> end;
        ArrayList<ClassDataSlot> slots = new ArrayList<ClassDataSlot>();
        Class<?> start = this.cl;
        for (end = this.cl; end != null && Serializable.class.isAssignableFrom(end); end = end.getSuperclass()) {
        }
        HashSet<String> oscNames = new HashSet<String>(3);
        ObjectStreamClass d = this;
        while (d != null) {
            Class<?> c;
            if (oscNames.contains(d.name)) {
                throw new InvalidClassException("Circular reference.");
            }
            oscNames.add(d.name);
            String searchName = d.cl != null ? d.cl.getName() : d.name;
            Class<?> match = null;
            for (c = start; c != end; c = c.getSuperclass()) {
                if (!searchName.equals(c.getName())) continue;
                match = c;
                break;
            }
            if (match != null) {
                for (c = start; c != match; c = c.getSuperclass()) {
                    slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
                }
                start = match.getSuperclass();
            }
            slots.add(new ClassDataSlot(d.getVariantFor(match), true));
            d = d.superDesc;
        }
        for (Class<?> c = start; c != end; c = c.getSuperclass()) {
            slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
        }
        Collections.reverse(slots);
        return slots.toArray(new ClassDataSlot[slots.size()]);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    void getPrimFieldValues(Object obj, byte[] buf) {
        this.fieldRefl.getPrimFieldValues(obj, buf);
    }

    void setPrimFieldValues(Object obj, byte[] buf) {
        this.fieldRefl.setPrimFieldValues(obj, buf);
    }

    void getObjFieldValues(Object obj, Object[] vals) {
        this.fieldRefl.getObjFieldValues(obj, vals);
    }

    void checkObjFieldValueTypes(Object obj, Object[] vals) {
        this.fieldRefl.checkObjectFieldValueTypes(obj, vals);
    }

    void setObjFieldValues(Object obj, Object[] vals) {
        this.fieldRefl.setObjFieldValues(obj, vals);
    }

    private void computeFieldOffsets() throws InvalidClassException {
        this.primDataSize = 0;
        this.numObjFields = 0;
        int firstObjIndex = -1;
        block7: for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            switch (f.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    f.setOffset(this.primDataSize++);
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    f.setOffset(this.numObjFields++);
                    if (firstObjIndex != -1) continue block7;
                    firstObjIndex = i;
                    continue block7;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (firstObjIndex != -1 && firstObjIndex + this.numObjFields != this.fields.length) {
            throw new InvalidClassException(this.name, "illegal field order");
        }
    }

    private ObjectStreamClass getVariantFor(Class<?> cl) throws InvalidClassException {
        if (this.cl == cl) {
            return this;
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        if (this.isProxy) {
            desc.initProxy(cl, null, this.superDesc);
        } else {
            desc.initNonProxy(this, cl, null, this.superDesc);
        }
        return desc;
    }

    private static Constructor<?> getExternalizableConstructor(Class<?> cl) {
        try {
            Constructor<?> cons = cl.getDeclaredConstructor(null);
            cons.setAccessible(true);
            return (cons.getModifiers() & 1) != 0 ? cons : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Constructor<?> getSerializableConstructor(Class<?> cl) {
        return reflFactory.newConstructorForSerialization(cl);
    }

    private static MethodHandle canonicalRecordCtr(Class<?> cls) {
        assert (cls.isRecord()) : "Expected record, got: " + cls;
        PrivilegedAction<MethodHandle> pa = () -> {
            Class[] paramTypes = (Class[])Arrays.stream(cls.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
            try {
                Constructor ctr = cls.getDeclaredConstructor(paramTypes);
                ctr.setAccessible(true);
                return MethodHandles.lookup().unreflectConstructor(ctr);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                return null;
            }
        };
        return AccessController.doPrivileged(pa);
    }

    MethodHandle getRecordConstructor() {
        return this.canonicalCtr;
    }

    private static Method getInheritableMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        Class<?> defCl;
        Method meth = null;
        for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                meth = defCl.getDeclaredMethod(name, argTypes);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (meth == null || meth.getReturnType() != returnType) {
            return null;
        }
        meth.setAccessible(true);
        int mods = meth.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            return meth;
        }
        if ((mods & 2) != 0) {
            return cl == defCl ? meth : null;
        }
        return ObjectStreamClass.packageEquals(cl, defCl) ? meth : null;
    }

    private static Method getPrivateMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        try {
            Method meth = cl.getDeclaredMethod(name, argTypes);
            meth.setAccessible(true);
            int mods = meth.getModifiers();
            return meth.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0 ? meth : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && cl1.getPackageName() == cl2.getPackageName();
    }

    private static boolean classNamesEqual(String name1, String name2) {
        int len2;
        int idx1 = name1.lastIndexOf(46) + 1;
        int idx2 = name2.lastIndexOf(46) + 1;
        int len1 = name1.length() - idx1;
        return len1 == (len2 = name2.length() - idx2) && name1.regionMatches(idx1, name2, idx2, len1);
    }

    private static String getMethodSignature(Class<?>[] paramTypes, Class<?> retType) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            ObjectStreamField.appendClassSignature(sb, paramTypes[i]);
        }
        sb.append(')');
        ObjectStreamField.appendClassSignature(sb, retType);
        return sb.toString();
    }

    private static void throwMiscException(Throwable th) throws IOException {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        IOException ex = new IOException("unexpected exception type");
        ex.initCause(th);
        throw ex;
    }

    private static ObjectStreamField[] getSerialFields(Class<?> cl) throws InvalidClassException {
        Object[] fields;
        if (!Serializable.class.isAssignableFrom(cl)) {
            return NO_FIELDS;
        }
        if (cl.isRecord()) {
            fields = ObjectStreamClass.getDefaultSerialFields(cl);
            Arrays.sort(fields);
        } else if (!(Externalizable.class.isAssignableFrom(cl) || Proxy.isProxyClass(cl) || cl.isInterface())) {
            fields = ObjectStreamClass.getDeclaredSerialFields(cl);
            if (fields == null) {
                fields = ObjectStreamClass.getDefaultSerialFields(cl);
            }
            Arrays.sort(fields);
        } else {
            fields = NO_FIELDS;
        }
        return fields;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class<?> cl) throws InvalidClassException {
        ObjectStreamField[] serialPersistentFields = null;
        try {
            Field f = cl.getDeclaredField("serialPersistentFields");
            int mask = 26;
            if ((f.getModifiers() & mask) == mask) {
                f.setAccessible(true);
                serialPersistentFields = (ObjectStreamField[])f.get(null);
            }
        }
        catch (Exception f) {
            // empty catch block
        }
        if (serialPersistentFields == null) {
            return null;
        }
        if (serialPersistentFields.length == 0) {
            return NO_FIELDS;
        }
        ObjectStreamField[] boundFields = new ObjectStreamField[serialPersistentFields.length];
        HashSet<String> fieldNames = new HashSet<String>(serialPersistentFields.length);
        for (int i = 0; i < serialPersistentFields.length; ++i) {
            ObjectStreamField spf = serialPersistentFields[i];
            String fname = spf.getName();
            if (fieldNames.contains(fname)) {
                throw new InvalidClassException("multiple serializable fields named " + fname);
            }
            fieldNames.add(fname);
            try {
                Field f = cl.getDeclaredField(fname);
                if (f.getType() == spf.getType() && (f.getModifiers() & 8) == 0) {
                    boundFields[i] = new ObjectStreamField(f, spf.isUnshared(), true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (boundFields[i] != null) continue;
            boundFields[i] = new ObjectStreamField(fname, spf.getType(), spf.isUnshared());
        }
        return boundFields;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class<?> cl) {
        Field[] clFields = cl.getDeclaredFields();
        ArrayList<ObjectStreamField> list = new ArrayList<ObjectStreamField>();
        int mask = 136;
        for (int i = 0; i < clFields.length; ++i) {
            if ((clFields[i].getModifiers() & mask) != 0) continue;
            list.add(new ObjectStreamField(clFields[i], false, true));
        }
        int size = list.size();
        return size == 0 ? NO_FIELDS : list.toArray(new ObjectStreamField[size]);
    }

    private static Long getDeclaredSUID(Class<?> cl) {
        try {
            Field f = cl.getDeclaredField("serialVersionUID");
            int mask = 24;
            if ((f.getModifiers() & mask) == mask) {
                f.setAccessible(true);
                return f.getLong(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static long computeDefaultSUID(Class<?> cl) {
        if (!Serializable.class.isAssignableFrom(cl) || Proxy.isProxyClass(cl)) {
            return 0L;
        }
        try {
            int i;
            int i2;
            int i3;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(cl.getName());
            int classMods = cl.getModifiers() & 0x611;
            Method[] methods = cl.getDeclaredMethods();
            if ((classMods & 0x200) != 0) {
                classMods = methods.length > 0 ? classMods | 0x400 : classMods & 0xFFFFFBFF;
            }
            dout.writeInt(classMods);
            if (!cl.isArray()) {
                Class<?>[] interfaces = cl.getInterfaces();
                Object[] ifaceNames = new String[interfaces.length];
                for (i3 = 0; i3 < interfaces.length; ++i3) {
                    ifaceNames[i3] = interfaces[i3].getName();
                }
                Arrays.sort(ifaceNames);
                for (i3 = 0; i3 < ifaceNames.length; ++i3) {
                    dout.writeUTF((String)ifaceNames[i3]);
                }
            }
            Field[] fields = cl.getDeclaredFields();
            MemberSignature[] fieldSigs = new MemberSignature[fields.length];
            for (i3 = 0; i3 < fields.length; ++i3) {
                fieldSigs[i3] = new MemberSignature(fields[i3]);
            }
            Arrays.sort(fieldSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    return ms1.name.compareTo(ms2.name);
                }
            });
            for (i3 = 0; i3 < fieldSigs.length; ++i3) {
                MemberSignature sig = fieldSigs[i3];
                int mods = sig.member.getModifiers() & 0xDF;
                if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature);
            }
            if (ObjectStreamClass.hasStaticInitializer(cl)) {
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
            }
            Constructor<?>[] cons = cl.getDeclaredConstructors();
            MemberSignature[] consSigs = new MemberSignature[cons.length];
            for (i2 = 0; i2 < cons.length; ++i2) {
                consSigs[i2] = new MemberSignature(cons[i2]);
            }
            Arrays.sort(consSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    return ms1.signature.compareTo(ms2.signature);
                }
            });
            for (i2 = 0; i2 < consSigs.length; ++i2) {
                MemberSignature sig = consSigs[i2];
                int mods = sig.member.getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            MemberSignature[] methSigs = new MemberSignature[methods.length];
            for (i = 0; i < methods.length; ++i) {
                methSigs[i] = new MemberSignature(methods[i]);
            }
            Arrays.sort(methSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    int comp = ms1.name.compareTo(ms2.name);
                    if (comp == 0) {
                        comp = ms1.signature.compareTo(ms2.signature);
                    }
                    return comp;
                }
            });
            for (i = 0; i < methSigs.length; ++i) {
                MemberSignature sig = methSigs[i];
                int mods = sig.member.getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i4 = Math.min(hashBytes.length, 8) - 1; i4 >= 0; --i4) {
                hash = hash << 8 | (long)(hashBytes[i4] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    private static native boolean hasStaticInitializer(Class<?> var0);

    private static FieldReflector getReflector(ObjectStreamField[] fields, ObjectStreamClass localDesc) throws InvalidClassException {
        Class<?> cl = localDesc != null && fields.length > 0 ? localDesc.cl : null;
        ObjectStreamClass.processQueue(Caches.reflectorsQueue, Caches.reflectors);
        FieldReflectorKey key = new FieldReflectorKey(cl, fields, Caches.reflectorsQueue);
        Reference ref = (Reference)Caches.reflectors.get(key);
        Object entry = null;
        if (ref != null) {
            entry = ref.get();
        }
        EntryFuture future = null;
        if (entry == null) {
            EntryFuture newEntry = new EntryFuture();
            SoftReference<EntryFuture> newRef = new SoftReference<EntryFuture>(newEntry);
            do {
                if (ref != null) {
                    Caches.reflectors.remove(key, ref);
                }
                if ((ref = (Reference)Caches.reflectors.putIfAbsent(key, newRef)) == null) continue;
                entry = ref.get();
            } while (ref != null && entry == null);
            if (entry == null) {
                future = newEntry;
            }
        }
        if (entry instanceof FieldReflector) {
            return (FieldReflector)entry;
        }
        if (entry instanceof EntryFuture) {
            entry = ((EntryFuture)entry).get();
        } else if (entry == null) {
            try {
                entry = new FieldReflector(ObjectStreamClass.matchFields(fields, localDesc));
            }
            catch (Throwable th) {
                entry = th;
            }
            future.set(entry);
            Caches.reflectors.put(key, new SoftReference<Object>(entry));
        }
        if (entry instanceof FieldReflector) {
            return (FieldReflector)entry;
        }
        if (entry instanceof InvalidClassException) {
            throw (InvalidClassException)entry;
        }
        if (entry instanceof RuntimeException) {
            throw (RuntimeException)entry;
        }
        if (entry instanceof Error) {
            throw (Error)entry;
        }
        throw new InternalError("unexpected entry: " + entry);
    }

    private static ObjectStreamField[] matchFields(ObjectStreamField[] fields, ObjectStreamClass localDesc) throws InvalidClassException {
        ObjectStreamField[] localFields = localDesc != null ? localDesc.fields : NO_FIELDS;
        ObjectStreamField[] matches = new ObjectStreamField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField f = fields[i];
            ObjectStreamField m = null;
            for (int j = 0; j < localFields.length; ++j) {
                ObjectStreamField lf = localFields[j];
                if (!f.getName().equals(lf.getName())) continue;
                if ((f.isPrimitive() || lf.isPrimitive()) && f.getTypeCode() != lf.getTypeCode()) {
                    throw new InvalidClassException(localDesc.name, "incompatible types for field " + f.getName());
                }
                m = lf.getField() != null ? new ObjectStreamField(lf.getField(), lf.isUnshared(), false) : new ObjectStreamField(lf.getName(), lf.getSignature(), lf.isUnshared());
            }
            if (m == null) {
                m = new ObjectStreamField(f.getName(), f.getSignature(), false);
            }
            m.setOffset(f.getOffset());
            matches[i] = m;
        }
        return matches;
    }

    static void processQueue(ReferenceQueue<Class<?>> queue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> map) {
        Reference<Class<?>> ref;
        while ((ref = queue.poll()) != null) {
            map.remove(ref);
        }
    }

    static {
        ObjectStreamClass.initNative();
    }

    private static class Caches {
        static final ConcurrentMap<WeakClassKey, Reference<?>> localDescs = new ConcurrentHashMap();
        static final ConcurrentMap<FieldReflectorKey, Reference<?>> reflectors = new ConcurrentHashMap();
        private static final ReferenceQueue<Class<?>> localDescsQueue = new ReferenceQueue();
        private static final ReferenceQueue<Class<?>> reflectorsQueue = new ReferenceQueue();

        private Caches() {
        }
    }

    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> cl, ReferenceQueue<Class<?>> refQueue) {
            super(cl, refQueue);
            this.hash = System.identityHashCode(cl);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakClassKey) {
                Class referent = (Class)this.get();
                return referent != null && ((WeakClassKey)obj).refersTo(referent);
            }
            return false;
        }
    }

    private static class EntryFuture {
        private static final Object unset = new Object();
        private final Thread owner = Thread.currentThread();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized boolean set(Object entry) {
            if (this.entry != unset) {
                return false;
            }
            this.entry = entry;
            this.notifyAll();
            return true;
        }

        synchronized Object get() {
            boolean interrupted = false;
            while (this.entry == unset) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                });
            }
            return this.entry;
        }

        Thread getOwner() {
            return this.owner;
        }
    }

    private static class FieldReflector {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final long[] readKeys;
        private final long[] writeKeys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class<?>[] types;

        FieldReflector(ObjectStreamField[] fields) {
            this.fields = fields;
            int nfields = fields.length;
            this.readKeys = new long[nfields];
            this.writeKeys = new long[nfields];
            this.offsets = new int[nfields];
            this.typeCodes = new char[nfields];
            ArrayList typeList = new ArrayList();
            HashSet<Long> usedKeys = new HashSet<Long>();
            for (int i = 0; i < nfields; ++i) {
                long key;
                ObjectStreamField f = fields[i];
                Field rf = f.getField();
                this.readKeys[i] = key = rf != null ? unsafe.objectFieldOffset(rf) : -1L;
                this.writeKeys[i] = usedKeys.add(key) ? key : -1L;
                this.offsets[i] = f.getOffset();
                this.typeCodes[i] = f.getTypeCode();
                if (f.isPrimitive()) continue;
                typeList.add(rf != null ? rf.getType() : null);
            }
            this.types = typeList.toArray(new Class[typeList.size()]);
            this.numPrimFields = nfields - this.types.length;
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object obj, byte[] buf) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long key = this.readKeys[i];
                int off = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        Bits.putBoolean(buf, off, unsafe.getBoolean(obj, key));
                        continue block10;
                    }
                    case 'B': {
                        buf[off] = unsafe.getByte(obj, key);
                        continue block10;
                    }
                    case 'C': {
                        Bits.putChar(buf, off, unsafe.getChar(obj, key));
                        continue block10;
                    }
                    case 'S': {
                        Bits.putShort(buf, off, unsafe.getShort(obj, key));
                        continue block10;
                    }
                    case 'I': {
                        Bits.putInt(buf, off, unsafe.getInt(obj, key));
                        continue block10;
                    }
                    case 'F': {
                        Bits.putFloat(buf, off, unsafe.getFloat(obj, key));
                        continue block10;
                    }
                    case 'J': {
                        Bits.putLong(buf, off, unsafe.getLong(obj, key));
                        continue block10;
                    }
                    case 'D': {
                        Bits.putDouble(buf, off, unsafe.getDouble(obj, key));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setPrimFieldValues(Object obj, byte[] buf) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long key = this.writeKeys[i];
                if (key == -1L) continue;
                int off = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        unsafe.putBoolean(obj, key, Bits.getBoolean(buf, off));
                        continue block10;
                    }
                    case 'B': {
                        unsafe.putByte(obj, key, buf[off]);
                        continue block10;
                    }
                    case 'C': {
                        unsafe.putChar(obj, key, Bits.getChar(buf, off));
                        continue block10;
                    }
                    case 'S': {
                        unsafe.putShort(obj, key, Bits.getShort(buf, off));
                        continue block10;
                    }
                    case 'I': {
                        unsafe.putInt(obj, key, Bits.getInt(buf, off));
                        continue block10;
                    }
                    case 'F': {
                        unsafe.putFloat(obj, key, Bits.getFloat(buf, off));
                        continue block10;
                    }
                    case 'J': {
                        unsafe.putLong(obj, key, Bits.getLong(buf, off));
                        continue block10;
                    }
                    case 'D': {
                        unsafe.putDouble(obj, key, Bits.getDouble(buf, off));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void getObjFieldValues(Object obj, Object[] vals) {
            if (obj == null) {
                throw new NullPointerException();
            }
            for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                vals[this.offsets[i]] = unsafe.getReference(obj, this.readKeys[i]);
            }
        }

        void checkObjectFieldValueTypes(Object obj, Object[] vals) {
            this.setObjFieldValues(obj, vals, true);
        }

        void setObjFieldValues(Object obj, Object[] vals) {
            this.setObjFieldValues(obj, vals, false);
        }

        private void setObjFieldValues(Object obj, Object[] vals, boolean dryRun) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                long key = this.writeKeys[i];
                if (key == -1L) continue;
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        Object val = vals[this.offsets[i]];
                        if (val != null && !this.types[i - this.numPrimFields].isInstance(val)) {
                            Field f = this.fields[i].getField();
                            throw new ClassCastException("cannot assign instance of " + val.getClass().getName() + " to field " + f.getDeclaringClass().getName() + "." + f.getName() + " of type " + f.getType().getName() + " in instance of " + obj.getClass().getName());
                        }
                        if (dryRun) continue block3;
                        unsafe.putReference(obj, key, val);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }
    }

    private static class ExceptionInfo {
        private final String className;
        private final String message;

        ExceptionInfo(String cn, String msg) {
            this.className = cn;
            this.message = msg;
        }

        InvalidClassException newInvalidClassException() {
            return new InvalidClassException(this.className, this.message);
        }
    }

    private static final class DeserializationConstructorsCache
    extends ConcurrentHashMap<Key, MethodHandle> {
        private static final int MAX_SIZE = 10;
        private Key.Impl first;
        private Key.Impl last;

        DeserializationConstructorsCache() {
            super(2);
        }

        MethodHandle get(ObjectStreamField[] fields) {
            return (MethodHandle)this.get(new Key.Lookup(fields));
        }

        synchronized MethodHandle putIfAbsentAndGet(ObjectStreamField[] fields, MethodHandle mh) {
            Key.Impl key = new Key.Impl(fields);
            MethodHandle oldMh = this.putIfAbsent(key, mh);
            if (oldMh != null) {
                return oldMh;
            }
            this.last = this.last == null ? (this.first = key) : (this.last.next = key);
            if (this.size() > 10) {
                assert (this.first != null);
                this.remove(this.first);
                this.first = this.first.next;
                if (this.first == null) {
                    this.last = null;
                }
            }
            return mh;
        }

        static abstract class Key {
            Key() {
            }

            abstract int length();

            abstract String fieldName(int var1);

            abstract Class<?> fieldType(int var1);

            public final int hashCode() {
                int i;
                int n = this.length();
                int h = 0;
                for (i = 0; i < n; ++i) {
                    h = h * 31 + this.fieldType(i).hashCode();
                }
                for (i = 0; i < n; ++i) {
                    h = h * 31 + this.fieldName(i).hashCode();
                }
                return h;
            }

            public final boolean equals(Object obj) {
                int i;
                if (!(obj instanceof Key)) {
                    return false;
                }
                Key other = (Key)obj;
                int n = this.length();
                if (n != other.length()) {
                    return false;
                }
                for (i = 0; i < n; ++i) {
                    if (this.fieldType(i) == other.fieldType(i)) continue;
                    return false;
                }
                for (i = 0; i < n; ++i) {
                    if (this.fieldName(i).equals(other.fieldName(i))) continue;
                    return false;
                }
                return true;
            }

            static final class Impl
            extends Key {
                Impl next;
                final String[] fieldNames;
                final Class<?>[] fieldTypes;

                Impl(ObjectStreamField[] fields) {
                    this.fieldNames = new String[fields.length];
                    this.fieldTypes = new Class[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        this.fieldNames[i] = fields[i].getName();
                        this.fieldTypes[i] = fields[i].getType();
                    }
                }

                @Override
                int length() {
                    return this.fieldNames.length;
                }

                @Override
                String fieldName(int i) {
                    return this.fieldNames[i];
                }

                @Override
                Class<?> fieldType(int i) {
                    return this.fieldTypes[i];
                }
            }

            static final class Lookup
            extends Key {
                final ObjectStreamField[] fields;

                Lookup(ObjectStreamField[] fields) {
                    this.fields = fields;
                }

                @Override
                int length() {
                    return this.fields.length;
                }

                @Override
                String fieldName(int i) {
                    return this.fields[i].getName();
                }

                @Override
                Class<?> fieldType(int i) {
                    return this.fields[i].getType();
                }
            }
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass desc, boolean hasData) {
            this.desc = desc;
            this.hasData = hasData;
        }
    }

    private static class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = ObjectStreamField.getClassSignature(field.getType());
        }

        public MemberSignature(Constructor<?> cons) {
            this.member = cons;
            this.name = cons.getName();
            this.signature = ObjectStreamClass.getMethodSignature(cons.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method meth) {
            this.member = meth;
            this.name = meth.getName();
            this.signature = ObjectStreamClass.getMethodSignature(meth.getParameterTypes(), meth.getReturnType());
        }
    }

    private static class FieldReflectorKey
    extends WeakReference<Class<?>> {
        private final String[] sigs;
        private final int hash;
        private final boolean nullClass;

        FieldReflectorKey(Class<?> cl, ObjectStreamField[] fields, ReferenceQueue<Class<?>> queue) {
            super(cl, queue);
            this.nullClass = cl == null;
            this.sigs = new String[2 * fields.length];
            int j = 0;
            for (int i = 0; i < fields.length; ++i) {
                ObjectStreamField f = fields[i];
                this.sigs[j++] = f.getName();
                this.sigs[j++] = f.getSignature();
            }
            this.hash = System.identityHashCode(cl) + Arrays.hashCode(this.sigs);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FieldReflectorKey) {
                Class referent;
                FieldReflectorKey other = (FieldReflectorKey)obj;
                return (this.nullClass ? other.nullClass : (referent = (Class)this.get()) != null && other.refersTo(referent)) && Arrays.equals(this.sigs, other.sigs);
            }
            return false;
        }
    }

    static final class RecordSupport {
        private static final Map<Class<?>, MethodHandle> PRIM_VALUE_EXTRACTORS;

        RecordSupport() {
        }

        static MethodHandle deserializationCtr(ObjectStreamClass desc) {
            RecordComponent[] recordComponents;
            MethodHandle mh = desc.deserializationCtr;
            if (mh != null) {
                return mh;
            }
            mh = desc.deserializationCtrs.get(desc.getFields(false));
            if (mh != null) {
                desc.deserializationCtr = mh;
                return desc.deserializationCtr;
            }
            try {
                Class<?> cls = desc.forClass();
                PrivilegedExceptionAction<RecordComponent[]> pa = cls::getRecordComponents;
                recordComponents = AccessController.doPrivileged(pa);
            }
            catch (PrivilegedActionException e) {
                throw new InternalError(e.getCause());
            }
            mh = desc.getRecordConstructor();
            mh = mh.asType(mh.type().changeReturnType(Object.class));
            mh = MethodHandles.dropArguments(mh, mh.type().parameterCount(), byte[].class, Object[].class);
            for (int i = recordComponents.length - 1; i >= 0; --i) {
                String name = recordComponents[i].getName();
                Class<?> type = recordComponents[i].getType();
                MethodHandle combiner = RecordSupport.streamFieldExtractor(name, type, desc);
                mh = MethodHandles.foldArguments(mh, i, combiner);
            }
            desc.deserializationCtr = desc.deserializationCtrs.putIfAbsentAndGet(desc.getFields(false), mh);
            return desc.deserializationCtr;
        }

        private static int numberPrimValues(ObjectStreamClass desc) {
            ObjectStreamField[] fields = desc.getFields();
            int primValueCount = 0;
            for (int i = 0; i < fields.length && fields[i].isPrimitive(); ++i) {
                ++primValueCount;
            }
            return primValueCount;
        }

        private static MethodHandle streamFieldExtractor(String pName, Class<?> pType, ObjectStreamClass desc) {
            ObjectStreamField[] fields = desc.getFields(false);
            for (int i = 0; i < fields.length; ++i) {
                ObjectStreamField f = fields[i];
                String fName = f.getName();
                if (!fName.equals(pName)) continue;
                Class<?> fType = f.getField().getType();
                if (!pType.isAssignableFrom(fType)) {
                    throw new InternalError(fName + " unassignable, pType:" + pType + ", fType:" + fType);
                }
                if (f.isPrimitive()) {
                    MethodHandle mh = PRIM_VALUE_EXTRACTORS.get(fType);
                    if (mh == null) {
                        throw new InternalError("Unexpected type: " + fType);
                    }
                    mh = MethodHandles.insertArguments(mh, 1, f.getOffset());
                    mh = MethodHandles.dropArguments(mh, 1, Object[].class);
                    if (pType != fType) {
                        mh = mh.asType(mh.type().changeReturnType(pType));
                    }
                    return mh;
                }
                MethodHandle mh = MethodHandles.arrayElementGetter(Object[].class);
                mh = MethodHandles.insertArguments(mh, 1, i - RecordSupport.numberPrimValues(desc));
                mh = MethodHandles.dropArguments(mh, 0, byte[].class);
                if (pType != Object.class) {
                    mh = mh.asType(mh.type().changeReturnType(pType));
                }
                return mh;
            }
            return MethodHandles.empty(MethodType.methodType(pType, byte[].class, Object[].class));
        }

        static {
            MethodHandles.Lookup lkp = MethodHandles.lookup();
            try {
                PRIM_VALUE_EXTRACTORS = Map.of(Byte.TYPE, MethodHandles.arrayElementGetter(byte[].class), Short.TYPE, lkp.findStatic(Bits.class, "getShort", MethodType.methodType(Short.TYPE, byte[].class, Integer.TYPE)), Integer.TYPE, lkp.findStatic(Bits.class, "getInt", MethodType.methodType(Integer.TYPE, byte[].class, Integer.TYPE)), Long.TYPE, lkp.findStatic(Bits.class, "getLong", MethodType.methodType(Long.TYPE, byte[].class, Integer.TYPE)), Float.TYPE, lkp.findStatic(Bits.class, "getFloat", MethodType.methodType(Float.TYPE, byte[].class, Integer.TYPE)), Double.TYPE, lkp.findStatic(Bits.class, "getDouble", MethodType.methodType(Double.TYPE, byte[].class, Integer.TYPE)), Character.TYPE, lkp.findStatic(Bits.class, "getChar", MethodType.methodType(Character.TYPE, byte[].class, Integer.TYPE)), Boolean.TYPE, lkp.findStatic(Bits.class, "getBoolean", MethodType.methodType(Boolean.TYPE, byte[].class, Integer.TYPE)));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new InternalError("Can't lookup Bits.getXXX", e);
            }
        }
    }
}

