/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.lang.reflect.Field;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class ObjectStreamField
implements Comparable<Object> {
    private final String name;
    private final String signature;
    private final Class<?> type;
    private String typeSignature;
    private final boolean unshared;
    private final Field field;
    private int offset;

    public ObjectStreamField(String name, Class<?> type) {
        this(name, type, false);
    }

    public ObjectStreamField(String name, Class<?> type, boolean unshared) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.type = type;
        this.unshared = unshared;
        this.field = null;
        this.signature = null;
    }

    ObjectStreamField(String name, String signature, boolean unshared) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.signature = signature.intern();
        this.unshared = unshared;
        this.field = null;
        this.type = switch (signature.charAt(0)) {
            case 'Z' -> Boolean.TYPE;
            case 'B' -> Byte.TYPE;
            case 'C' -> Character.TYPE;
            case 'S' -> Short.TYPE;
            case 'I' -> Integer.TYPE;
            case 'J' -> Long.TYPE;
            case 'F' -> Float.TYPE;
            case 'D' -> Double.TYPE;
            case 'L', '[' -> Object.class;
            default -> throw new IllegalArgumentException("illegal signature");
        };
    }

    private static String getPrimitiveSignature(Class<?> cl) {
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        throw new InternalError();
    }

    static String getClassSignature(Class<?> cl) {
        if (cl.isPrimitive()) {
            return ObjectStreamField.getPrimitiveSignature(cl);
        }
        return ObjectStreamField.appendClassSignature(new StringBuilder(), cl).toString();
    }

    static StringBuilder appendClassSignature(StringBuilder sbuf, Class<?> cl) {
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            sbuf.append(ObjectStreamField.getPrimitiveSignature(cl));
        } else {
            sbuf.append('L').append(cl.getName().replace('.', '/')).append(';');
        }
        return sbuf;
    }

    ObjectStreamField(Field field, boolean unshared, boolean showType) {
        this.field = field;
        this.unshared = unshared;
        this.name = field.getName();
        Class<?> ftype = field.getType();
        this.type = showType || ftype.isPrimitive() ? ftype : Object.class;
        this.signature = ObjectStreamField.getClassSignature(ftype).intern();
    }

    public String getName() {
        return this.name;
    }

    @CallerSensitive
    public Class<?> getType() {
        Class<?> caller;
        if (System.getSecurityManager() != null && ReflectUtil.needsPackageAccessCheck((caller = Reflection.getCallerClass()).getClassLoader(), this.type.getClassLoader())) {
            ReflectUtil.checkPackageAccess(this.type);
        }
        return this.type;
    }

    public char getTypeCode() {
        return this.getSignature().charAt(0);
    }

    public String getTypeString() {
        return this.isPrimitive() ? null : this.getSignature();
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isPrimitive() {
        char tcode = this.getTypeCode();
        return tcode != 'L' && tcode != '[';
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    @Override
    public int compareTo(Object obj) {
        ObjectStreamField other = (ObjectStreamField)obj;
        boolean isPrim = this.isPrimitive();
        if (isPrim != other.isPrimitive()) {
            return isPrim ? -1 : 1;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.getSignature() + ' ' + this.name;
    }

    Field getField() {
        return this.field;
    }

    String getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        String sig = this.typeSignature;
        if (sig == null) {
            this.typeSignature = sig = ObjectStreamField.getClassSignature(this.type).intern();
        }
        return sig;
    }
}

