/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new char[size];
        this.pos = size;
    }

    public PushbackReader(Reader in) {
        this(in, 1);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.ensureOpen();
            if (this.pos < this.buf.length) {
                return this.buf[this.pos++];
            }
            return super.read();
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.ensureOpen();
            try {
                Objects.checkFromIndexSize(off, len, cbuf.length);
                if (len == 0) {
                    return 0;
                }
                int avail = this.buf.length - this.pos;
                if (avail > 0) {
                    if (len < avail) {
                        avail = len;
                    }
                    System.arraycopy(this.buf, this.pos, cbuf, off, avail);
                    this.pos += avail;
                    off += avail;
                    len -= avail;
                }
                if (len > 0) {
                    if ((len = super.read(cbuf, off, len)) == -1) {
                        return avail == 0 ? -1 : avail;
                    }
                    return avail + len;
                }
                return avail;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int c) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.ensureOpen();
            if (this.pos == 0) {
                throw new IOException("Pushback buffer overflow");
            }
            this.buf[--this.pos] = (char)c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(char[] cbuf, int off, int len) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.ensureOpen();
            if (len > this.pos) {
                throw new IOException("Pushback buffer overflow");
            }
            this.pos -= len;
            System.arraycopy(cbuf, off, this.buf, this.pos, len);
        }
    }

    public void unread(char[] cbuf) throws IOException {
        this.unread(cbuf, 0, cbuf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.ensureOpen();
            return this.pos < this.buf.length || super.ready();
        }
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            super.close();
            this.buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.ensureOpen();
            int avail = this.buf.length - this.pos;
            if (avail > 0) {
                if (n <= (long)avail) {
                    this.pos = (int)((long)this.pos + n);
                    return n;
                }
                this.pos = this.buf.length;
                n -= (long)avail;
            }
            return (long)avail + super.skip(n);
        }
    }
}

