/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;

public abstract class Reader
implements Readable,
Closeable {
    private static final int TRANSFER_BUFFER_SIZE = 8192;
    protected Object lock;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    public static Reader nullReader() {
        return new Reader(){
            private volatile boolean closed;

            private void ensureOpen() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
            }

            @Override
            public int read() throws IOException {
                this.ensureOpen();
                return -1;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                Objects.checkFromIndexSize(off, len, cbuf.length);
                this.ensureOpen();
                if (len == 0) {
                    return 0;
                }
                return -1;
            }

            @Override
            public int read(CharBuffer target) throws IOException {
                Objects.requireNonNull(target);
                this.ensureOpen();
                if (target.hasRemaining()) {
                    return -1;
                }
                return 0;
            }

            @Override
            public boolean ready() throws IOException {
                this.ensureOpen();
                return false;
            }

            @Override
            public long skip(long n) throws IOException {
                this.ensureOpen();
                return 0L;
            }

            @Override
            public long transferTo(Writer out) throws IOException {
                Objects.requireNonNull(out);
                this.ensureOpen();
                return 0L;
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int nread;
        if (target.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (target.hasArray()) {
            char[] cbuf = target.array();
            int pos = target.position();
            int rem = Math.max(target.limit() - pos, 0);
            int off = target.arrayOffset() + pos;
            nread = this.read(cbuf, off, rem);
            if (nread > 0) {
                target.position(pos + nread);
            }
        } else {
            int len = target.remaining();
            char[] cbuf = new char[len];
            nread = this.read(cbuf, 0, len);
            if (nread > 0) {
                target.put(cbuf, 0, nread);
            }
        }
        return nread;
    }

    public int read() throws IOException {
        char[] cb = new char[1];
        if (this.read(cb, 0, 1) == -1) {
            return -1;
        }
        return cb[0];
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int nn = (int)Math.min(n, 8192L);
        Object object2 = this.lock;
        synchronized (object2) {
            long r;
            int nc;
            if (this.skipBuffer == null || this.skipBuffer.length < nn) {
                this.skipBuffer = new char[nn];
            }
            for (r = n; r > 0L && (nc = this.read(this.skipBuffer, 0, (int)Math.min(r, (long)nn))) != -1; r -= (long)nc) {
            }
            return n - r;
        }
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public abstract void close() throws IOException;

    public long transferTo(Writer out) throws IOException {
        int nRead;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        char[] buffer = new char[8192];
        while ((nRead = this.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, nRead);
            transferred += (long)nRead;
        }
        return transferred;
    }
}

