/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Locale;
import java.util.Properties;
import sun.security.action.GetPropertyAction;

class WinNTFileSystem
extends FileSystem {
    private final char slash;
    private final char altSlash;
    private final char semicolon;
    private final String userDir;
    private static String[] driveDirCache = new String[26];
    private final ExpiringCache cache;
    private final ExpiringCache prefixCache;

    public WinNTFileSystem() {
        Properties props = GetPropertyAction.privilegedGetProperties();
        this.slash = props.getProperty("file.separator").charAt(0);
        this.semicolon = props.getProperty("path.separator").charAt(0);
        this.altSlash = (char)(this.slash == '\\' ? 47 : 92);
        this.userDir = this.normalize(props.getProperty("user.dir"));
        this.cache = useCanonCaches ? new ExpiringCache() : null;
        this.prefixCache = useCanonPrefixCache ? new ExpiringCache() : null;
    }

    private boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private String slashify(String p) {
        if (!p.isEmpty() && p.charAt(0) != this.slash) {
            return this.slash + p;
        }
        return p;
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.semicolon;
    }

    @Override
    public String normalize(String path) {
        int n = path.length();
        char slash = this.slash;
        char altSlash = this.altSlash;
        char prev = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (c == altSlash) {
                return this.normalize(path, n, prev == slash ? i - 1 : i);
            }
            if (c == slash && prev == slash && i > 1) {
                return this.normalize(path, n, i - 1);
            }
            if (c == ':' && i > 1) {
                return this.normalize(path, n, 0);
            }
            prev = c;
        }
        if (prev == slash) {
            return this.normalize(path, n, n - 1);
        }
        return path;
    }

    private String normalize(String path, int len, int off) {
        int src;
        if (len == 0) {
            return path;
        }
        if (off < 3) {
            off = 0;
        }
        char slash = this.slash;
        StringBuilder sb = new StringBuilder(len);
        if (off == 0) {
            src = this.normalizePrefix(path, len, sb);
        } else {
            src = off;
            sb.append(path, 0, off);
        }
        while (src < len) {
            char c;
            if (this.isSlash(c = path.charAt(src++))) {
                while (src < len && this.isSlash(path.charAt(src))) {
                    ++src;
                }
                if (src == len) {
                    int sn = sb.length();
                    if (sn == 2 && sb.charAt(1) == ':') {
                        sb.append(slash);
                        break;
                    }
                    if (sn == 0) {
                        sb.append(slash);
                        break;
                    }
                    if (sn != 1 || !this.isSlash(sb.charAt(0))) break;
                    sb.append(slash);
                    break;
                }
                sb.append(slash);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private int normalizePrefix(String path, int len, StringBuilder sb) {
        char c;
        int src;
        for (src = 0; src < len && this.isSlash(path.charAt(src)); ++src) {
        }
        if (len - src >= 2 && this.isLetter(c = path.charAt(src)) && path.charAt(src + 1) == ':') {
            sb.append(c);
            sb.append(':');
            src += 2;
        } else {
            src = 0;
            if (len >= 2 && this.isSlash(path.charAt(0)) && this.isSlash(path.charAt(1))) {
                src = 1;
                sb.append(this.slash);
            }
        }
        return src;
    }

    @Override
    public int prefixLength(String path) {
        char c1;
        char slash = this.slash;
        int n = path.length();
        if (n == 0) {
            return 0;
        }
        char c0 = path.charAt(0);
        char c = c1 = n > 1 ? path.charAt(1) : (char)'\u0000';
        if (c0 == slash) {
            if (c1 == slash) {
                return 2;
            }
            return 1;
        }
        if (this.isLetter(c0) && c1 == ':') {
            if (n > 2 && path.charAt(2) == slash) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public String resolve(String parent, String child) {
        boolean isDirectoryRelative;
        int pn = parent.length();
        if (pn == 0) {
            return child;
        }
        int cn = child.length();
        if (cn == 0) {
            return parent;
        }
        String c = child;
        int childStart = 0;
        int parentEnd = pn;
        boolean bl = isDirectoryRelative = pn == 2 && this.isLetter(parent.charAt(0)) && parent.charAt(1) == ':';
        if (cn > 1 && c.charAt(0) == this.slash) {
            if (c.charAt(1) == this.slash) {
                childStart = 2;
            } else if (!isDirectoryRelative) {
                childStart = 1;
            }
            if (cn == childStart) {
                if (parent.charAt(pn - 1) == this.slash) {
                    return parent.substring(0, pn - 1);
                }
                return parent;
            }
        }
        if (parent.charAt(pn - 1) == this.slash) {
            --parentEnd;
        }
        int strlen = parentEnd + cn - childStart;
        char[] theChars = null;
        if (child.charAt(childStart) == this.slash || isDirectoryRelative) {
            theChars = new char[strlen];
            parent.getChars(0, parentEnd, theChars, 0);
            child.getChars(childStart, cn, theChars, parentEnd);
        } else {
            theChars = new char[strlen + 1];
            parent.getChars(0, parentEnd, theChars, 0);
            theChars[parentEnd] = this.slash;
            child.getChars(childStart, cn, theChars, parentEnd + 1);
        }
        return new String(theChars);
    }

    @Override
    public String getDefaultParent() {
        return "" + this.slash;
    }

    @Override
    public String fromURIPath(String path) {
        String p = path;
        if (p.length() > 2 && p.charAt(2) == ':') {
            if ((p = p.substring(1)).length() > 3 && p.endsWith("/")) {
                p = p.substring(0, p.length() - 1);
            }
        } else if (p.length() > 1 && p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    @Override
    public boolean isAbsolute(File f) {
        int pl = f.getPrefixLength();
        return pl == 2 && f.getPath().charAt(0) == this.slash || pl == 3;
    }

    @Override
    public String resolve(File f) {
        String path = f.getPath();
        int pl = f.getPrefixLength();
        if (pl == 2 && path.charAt(0) == this.slash) {
            return path;
        }
        if (pl == 3) {
            return path;
        }
        if (pl == 0) {
            return this.getUserPath() + this.slashify(path);
        }
        if (pl == 1) {
            String up = this.getUserPath();
            String ud = this.getDrive(up);
            if (ud != null) {
                return ud + path;
            }
            return up + path;
        }
        if (pl == 2) {
            String up = this.getUserPath();
            String ud = this.getDrive(up);
            if (ud != null && path.startsWith(ud)) {
                return up + this.slashify(path.substring(2));
            }
            char drive = path.charAt(0);
            String dir = this.getDriveDirectory(drive);
            if (dir != null) {
                String p = "" + drive + ':' + dir + this.slashify(path.substring(2));
                SecurityManager security = System.getSecurityManager();
                try {
                    if (security != null) {
                        security.checkRead(p);
                    }
                }
                catch (SecurityException x) {
                    throw new SecurityException("Cannot resolve path " + path);
                }
                return p;
            }
            return drive + ":" + this.slashify(path.substring(2));
        }
        throw new InternalError("Unresolvable path: " + path);
    }

    private String getUserPath() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess("user.dir");
        }
        return this.normalize(this.userDir);
    }

    private String getDrive(String path) {
        int pl = this.prefixLength(path);
        return pl == 3 ? path.substring(0, 2) : null;
    }

    private static int driveIndex(char d) {
        if (d >= 'a' && d <= 'z') {
            return d - 97;
        }
        if (d >= 'A' && d <= 'Z') {
            return d - 65;
        }
        return -1;
    }

    private native String getDriveDirectory(int var1);

    private String getDriveDirectory(char drive) {
        int i = WinNTFileSystem.driveIndex(drive);
        if (i < 0) {
            return null;
        }
        String s = driveDirCache[i];
        if (s != null) {
            return s;
        }
        WinNTFileSystem.driveDirCache[i] = s = this.getDriveDirectory(i + 1);
        return s;
    }

    @Override
    public String canonicalize(String path) throws IOException {
        int len = path.length();
        if (len == 2 && this.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            char c = path.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return path;
            }
            return "" + (char)(c - 32) + ':';
        }
        if (len == 3 && this.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '\\') {
            char c = path.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return path;
            }
            return "" + (char)(c - 32) + ':' + '\\';
        }
        if (!useCanonCaches) {
            return this.canonicalize0(path);
        }
        String res = this.cache.get(path);
        if (res == null) {
            String dir = null;
            String resDir = null;
            if (useCanonPrefixCache && (dir = WinNTFileSystem.parentOrNull(path)) != null && (resDir = this.prefixCache.get(dir)) != null) {
                String filename = path.substring(1 + dir.length());
                res = this.canonicalizeWithPrefix(resDir, filename);
                this.cache.put(dir + File.separatorChar + filename, res);
            }
            if (res == null) {
                File f;
                res = this.canonicalize0(path);
                this.cache.put(path, res);
                if (useCanonPrefixCache && dir != null && (resDir = WinNTFileSystem.parentOrNull(res)) != null && (f = new File(res)).exists() && !f.isDirectory()) {
                    this.prefixCache.put(dir, resDir);
                }
            }
        }
        return res;
    }

    private native String canonicalize0(String var1) throws IOException;

    private String canonicalizeWithPrefix(String canonicalPrefix, String filename) throws IOException {
        return this.canonicalizeWithPrefix0(canonicalPrefix, canonicalPrefix + File.separatorChar + filename);
    }

    private native String canonicalizeWithPrefix0(String var1, String var2) throws IOException;

    private static String parentOrNull(String path) {
        int last;
        if (path == null) {
            return null;
        }
        char sep = File.separatorChar;
        char altSep = '/';
        int adjacentDots = 0;
        int nonDotCount = 0;
        for (int idx = last = path.length() - 1; idx > 0; --idx) {
            char c = path.charAt(idx);
            if (c == '.') {
                if (++adjacentDots >= 2) {
                    return null;
                }
                if (nonDotCount != 0) continue;
                return null;
            }
            if (c == sep) {
                if (adjacentDots == 1 && nonDotCount == 0) {
                    return null;
                }
                if (idx == 0 || idx >= last - 1 || path.charAt(idx - 1) == sep || path.charAt(idx - 1) == altSep) {
                    return null;
                }
                return path.substring(0, idx);
            }
            if (c == altSep) {
                return null;
            }
            if (c == '*' || c == '?') {
                return null;
            }
            ++nonDotCount;
            adjacentDots = 0;
        }
        return null;
    }

    @Override
    public native int getBooleanAttributes(File var1);

    @Override
    public native boolean checkAccess(File var1, int var2);

    @Override
    public native long getLastModifiedTime(File var1);

    @Override
    public native long getLength(File var1);

    @Override
    public native boolean setPermission(File var1, int var2, boolean var3, boolean var4);

    @Override
    public native boolean createFileExclusively(String var1) throws IOException;

    @Override
    public native String[] list(File var1);

    @Override
    public native boolean createDirectory(File var1);

    @Override
    public native boolean setLastModifiedTime(File var1, long var2);

    @Override
    public native boolean setReadOnly(File var1);

    @Override
    public boolean delete(File f) {
        if (useCanonCaches) {
            this.cache.clear();
        }
        if (useCanonPrefixCache) {
            this.prefixCache.clear();
        }
        return this.delete0(f);
    }

    private native boolean delete0(File var1);

    @Override
    public boolean rename(File f1, File f2) {
        if (useCanonCaches) {
            this.cache.clear();
        }
        if (useCanonPrefixCache) {
            this.prefixCache.clear();
        }
        return this.rename0(f1, f2);
    }

    private native boolean rename0(File var1, File var2);

    @Override
    public File[] listRoots() {
        return (File[])BitSet.valueOf(new long[]{WinNTFileSystem.listRoots0()}).stream().mapToObj(i -> new File((char)(65 + i) + ":" + this.slash)).filter(f -> this.access(f.getPath()) && f.exists()).toArray(File[]::new);
    }

    private static native int listRoots0();

    private boolean access(String path) {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(path);
            }
            return true;
        }
        catch (SecurityException x) {
            return false;
        }
    }

    @Override
    public long getSpace(File f, int t) {
        if (f.exists()) {
            return this.getSpace0(f, t);
        }
        return 0L;
    }

    private native long getSpace0(File var1, int var2);

    private native int getNameMax0(String var1);

    @Override
    public int getNameMax(String path) {
        Path root;
        File f;
        String s = null;
        if (path != null && (f = new File(path)).isAbsolute() && (root = f.toPath().getRoot()) != null && !(s = root.toString()).endsWith("\\")) {
            s = s + "\\";
        }
        return this.getNameMax0(s);
    }

    @Override
    public int compare(File f1, File f2) {
        return f1.getPath().compareToIgnoreCase(f2.getPath());
    }

    @Override
    public int hashCode(File f) {
        return f.getPath().toLowerCase(Locale.ENGLISH).hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        WinNTFileSystem.initIDs();
    }
}

