/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;

public abstract class Writer
implements Appendable,
Closeable,
Flushable {
    private char[] writeBuffer;
    private static final int WRITE_BUFFER_SIZE = 1024;
    protected Object lock;

    public static Writer nullWriter() {
        return new Writer(){
            private volatile boolean closed;

            private void ensureOpen() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
            }

            @Override
            public Writer append(char c) throws IOException {
                this.ensureOpen();
                return this;
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                this.ensureOpen();
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                this.ensureOpen();
                if (csq != null) {
                    Objects.checkFromToIndex(start, end, csq.length());
                }
                return this;
            }

            @Override
            public void write(int c) throws IOException {
                this.ensureOpen();
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                Objects.checkFromIndexSize(off, len, cbuf.length);
                this.ensureOpen();
            }

            @Override
            public void write(String str) throws IOException {
                Objects.requireNonNull(str);
                this.ensureOpen();
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                Objects.checkFromIndexSize(off, len, str.length());
                this.ensureOpen();
            }

            @Override
            public void flush() throws IOException {
                this.ensureOpen();
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.writeBuffer == null) {
                this.writeBuffer = new char[1024];
            }
            this.writeBuffer[0] = (char)c;
            this.write(this.writeBuffer, 0, 1);
        }
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int off, int len) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            char[] cbuf;
            if (len <= 1024) {
                if (this.writeBuffer == null) {
                    this.writeBuffer = new char[1024];
                }
                cbuf = this.writeBuffer;
            } else {
                cbuf = new char[len];
            }
            str.getChars(off, off + len, cbuf, 0);
            this.write(cbuf, 0, len);
        }
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.write(String.valueOf(csq));
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (csq == null) {
            csq = "null";
        }
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;
}

