/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public interface CharSequence {
    public int length();

    public char charAt(int var1);

    default public boolean isEmpty() {
        return this.length() == 0;
    }

    public CharSequence subSequence(int var1, int var2);

    public String toString();

    default public IntStream chars() {
        return StreamSupport.intStream(() -> {
            class CharIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                CharIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.cur < CharSequence.this.length();
                }

                @Override
                public int nextInt() {
                    if (this.hasNext()) {
                        return CharSequence.this.charAt(this.cur++);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void forEachRemaining(IntConsumer block) {
                    while (this.cur < CharSequence.this.length()) {
                        block.accept(CharSequence.this.charAt(this.cur));
                        ++this.cur;
                    }
                }
            }
            return Spliterators.spliterator(new CharIterator(), (long)this.length(), 16);
        }, 16464, false);
    }

    default public IntStream codePoints() {
        return StreamSupport.intStream(() -> {
            class CodePointIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                CodePointIterator() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void forEachRemaining(IntConsumer block) {
                    int length = CharSequence.this.length();
                    int i = this.cur;
                    try {
                        while (i < length) {
                            char c1;
                            if (!Character.isHighSurrogate(c1 = CharSequence.this.charAt(i++)) || i >= length) {
                                block.accept(c1);
                                continue;
                            }
                            char c2 = CharSequence.this.charAt(i);
                            if (Character.isLowSurrogate(c2)) {
                                ++i;
                                block.accept(Character.toCodePoint(c1, c2));
                                continue;
                            }
                            block.accept(c1);
                        }
                    }
                    finally {
                        this.cur = i;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.cur < CharSequence.this.length();
                }

                @Override
                public int nextInt() {
                    char c2;
                    char c1;
                    int length = CharSequence.this.length();
                    if (this.cur >= length) {
                        throw new NoSuchElementException();
                    }
                    if (Character.isHighSurrogate(c1 = CharSequence.this.charAt(this.cur++)) && this.cur < length && Character.isLowSurrogate(c2 = CharSequence.this.charAt(this.cur))) {
                        ++this.cur;
                        return Character.toCodePoint(c1, c2);
                    }
                    return c1;
                }
            }
            return Spliterators.spliteratorUnknownSize(new CodePointIterator(), 16);
        }, 16, false);
    }

    public static int compare(CharSequence cs1, CharSequence cs2) {
        if (Objects.requireNonNull(cs1) == Objects.requireNonNull(cs2)) {
            return 0;
        }
        if (cs1.getClass() == cs2.getClass() && cs1 instanceof Comparable) {
            return ((Comparable)((Object)cs1)).compareTo(cs2);
        }
        int len = Math.min(cs1.length(), cs2.length());
        for (int i = 0; i < len; ++i) {
            char b;
            char a = cs1.charAt(i);
            if (a == (b = cs2.charAt(i))) continue;
            return a - b;
        }
        return cs1.length() - cs2.length();
    }
}

